<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternetSalesInformation StructType
 * @subpackage Structs
 */
class InternetSalesInformation extends AbstractStructBase
{
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentDate;
    /**
     * The WebAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddress;
    /**
     * The PaymentMidierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMidierName;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The ShipmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ShipmentInformation
     */
    public $ShipmentInfo;
    /**
     * Constructor method for InternetSalesInformation
     * @uses InternetSalesInformation::setPaymentDate()
     * @uses InternetSalesInformation::setWebAddress()
     * @uses InternetSalesInformation::setPaymentMidierName()
     * @uses InternetSalesInformation::setPaymentType()
     * @uses InternetSalesInformation::setShipmentInfo()
     * @param string $paymentDate
     * @param string $webAddress
     * @param string $paymentMidierName
     * @param string $paymentType
     * @param \Mnm\StructType\ShipmentInformation $shipmentInfo
     */
    public function __construct($paymentDate = null, $webAddress = null, $paymentMidierName = null, $paymentType = null, \Mnm\StructType\ShipmentInformation $shipmentInfo = null)
    {
        $this
            ->setPaymentDate($paymentDate)
            ->setWebAddress($webAddress)
            ->setPaymentMidierName($paymentMidierName)
            ->setPaymentType($paymentType)
            ->setShipmentInfo($shipmentInfo);
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public function setPaymentDate($paymentDate = null)
    {
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get WebAddress value
     * @return string|null
     */
    public function getWebAddress()
    {
        return $this->WebAddress;
    }
    /**
     * Set WebAddress value
     * @param string $webAddress
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public function setWebAddress($webAddress = null)
    {
        $this->WebAddress = $webAddress;
        return $this;
    }
    /**
     * Get PaymentMidierName value
     * @return string|null
     */
    public function getPaymentMidierName()
    {
        return $this->PaymentMidierName;
    }
    /**
     * Set PaymentMidierName value
     * @param string $paymentMidierName
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public function setPaymentMidierName($paymentMidierName = null)
    {
        $this->PaymentMidierName = $paymentMidierName;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public function setPaymentType($paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get ShipmentInfo value
     * @return \Mnm\StructType\ShipmentInformation|null
     */
    public function getShipmentInfo()
    {
        return $this->ShipmentInfo;
    }
    /**
     * Set ShipmentInfo value
     * @param \Mnm\StructType\ShipmentInformation $shipmentInfo
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public function setShipmentInfo(\Mnm\StructType\ShipmentInformation $shipmentInfo = null)
    {
        $this->ShipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InternetSalesInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
