<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q111:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q112:Description
     * @var \Mnm\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q113:HazardousRiskIndicator
     * @var \Mnm\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q114:DeclaredCustomsValueAmount
     * @var \Mnm\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q115:DeclaredForCarriageValueAmount
     * @var \Mnm\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q116:DeclaredStatisticsValueAmount
     * @var \Mnm\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q117:FreeOnBoardValueAmount
     * @var \Mnm\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q118:InsuranceValueAmount
     * @var \Mnm\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q119:ValueAmount
     * @var \Mnm\StructType\ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q120:GrossWeightMeasure
     * @var \Mnm\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q121:NetWeightMeasure
     * @var \Mnm\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q122:ChargeableWeightMeasure
     * @var \Mnm\StructType\ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q123:GrossVolumeMeasure
     * @var \Mnm\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q124:NetVolumeMeasure
     * @var \Mnm\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q125:Quantity
     * @var \Mnm\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q126:RequiredCustomsID
     * @var \Mnm\StructType\RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q127:CustomsStatusCode
     * @var \Mnm\StructType\CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q128:CustomsTariffQuantity
     * @var \Mnm\StructType\CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q129:CustomsImportClassifiedIndicator
     * @var \Mnm\StructType\CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q130:ChargeableQuantity
     * @var \Mnm\StructType\ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q131:ReturnableQuantity
     * @var \Mnm\StructType\ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q132:TraceID
     * @var \Mnm\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for GoodsItemType
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\DescriptionType[] $description
     * @param \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Mnm\StructType\ValueAmountType $valueAmount
     * @param \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Mnm\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Mnm\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Mnm\StructType\QuantityType $quantity
     * @param \Mnm\StructType\RequiredCustomsIDType $requiredCustomsID
     * @param \Mnm\StructType\CustomsStatusCodeType $customsStatusCode
     * @param \Mnm\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @param \Mnm\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param \Mnm\StructType\ChargeableQuantityType $chargeableQuantity
     * @param \Mnm\StructType\ReturnableQuantityType $returnableQuantity
     * @param \Mnm\StructType\TraceIDType $traceID
     * @param \Mnm\StructType\ItemType[] $item
     * @param \Mnm\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @param \Mnm\StructType\InvoiceLineType[] $invoiceLine
     * @param \Mnm\StructType\TemperatureType[] $temperature
     * @param \Mnm\StructType\AddressType $originAddress
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, array $description = array(), \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Mnm\StructType\ValueAmountType $valueAmount = null, \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Mnm\StructType\NetWeightMeasureType $netWeightMeasure = null, \Mnm\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null, \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Mnm\StructType\QuantityType $quantity = null, \Mnm\StructType\RequiredCustomsIDType $requiredCustomsID = null, \Mnm\StructType\CustomsStatusCodeType $customsStatusCode = null, \Mnm\StructType\CustomsTariffQuantityType $customsTariffQuantity = null, \Mnm\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, \Mnm\StructType\ChargeableQuantityType $chargeableQuantity = null, \Mnm\StructType\ReturnableQuantityType $returnableQuantity = null, \Mnm\StructType\TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), \Mnm\StructType\AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return \Mnm\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\StructType\DescriptionType[] $description
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DescriptionType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToDescription(\Mnm\StructType\DescriptionType $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Mnm\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setHazardousRiskIndicator(\Mnm\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Mnm\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(\Mnm\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Mnm\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(\Mnm\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Mnm\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(\Mnm\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Mnm\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setFreeOnBoardValueAmount(\Mnm\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Mnm\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setInsuranceValueAmount(\Mnm\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \Mnm\StructType\ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \Mnm\StructType\ValueAmountType $valueAmount
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setValueAmount(\Mnm\StructType\ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Mnm\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setGrossWeightMeasure(\Mnm\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Mnm\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Mnm\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setNetWeightMeasure(\Mnm\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get ChargeableWeightMeasure value
     * @return \Mnm\StructType\ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }
    /**
     * Set ChargeableWeightMeasure value
     * @param \Mnm\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setChargeableWeightMeasure(\Mnm\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Mnm\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setGrossVolumeMeasure(\Mnm\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Mnm\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setNetVolumeMeasure(\Mnm\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\StructType\QuantityType $quantity
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setQuantity(\Mnm\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * @return \Mnm\StructType\RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }
    /**
     * Set RequiredCustomsID value
     * @param \Mnm\StructType\RequiredCustomsIDType $requiredCustomsID
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setRequiredCustomsID(\Mnm\StructType\RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * @return \Mnm\StructType\CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }
    /**
     * Set CustomsStatusCode value
     * @param \Mnm\StructType\CustomsStatusCodeType $customsStatusCode
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setCustomsStatusCode(\Mnm\StructType\CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return \Mnm\StructType\CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param \Mnm\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setCustomsTariffQuantity(\Mnm\StructType\CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return \Mnm\StructType\CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param \Mnm\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(\Mnm\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return \Mnm\StructType\ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param \Mnm\StructType\ChargeableQuantityType $chargeableQuantity
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setChargeableQuantity(\Mnm\StructType\ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return \Mnm\StructType\ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param \Mnm\StructType\ReturnableQuantityType $returnableQuantity
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setReturnableQuantity(\Mnm\StructType\ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Mnm\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Mnm\StructType\TraceIDType $traceID
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setTraceID(\Mnm\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get Item value
     * @return \Mnm\StructType\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Mnm\StructType\ItemType[] $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setItem(array $item = array())
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ItemType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToItem(\Mnm\StructType\ItemType $item)
    {
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * @return \Mnm\StructType\AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }
    /**
     * Set FreightAllowanceCharge value
     * @param \Mnm\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }
    /**
     * Add item to FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\AllowanceChargeType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToFreightAllowanceCharge(\Mnm\StructType\AllowanceChargeType $item)
    {
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Mnm\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * Set InvoiceLine value
     * @param \Mnm\StructType\InvoiceLineType[] $invoiceLine
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\InvoiceLineType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToInvoiceLine(\Mnm\StructType\InvoiceLineType $item)
    {
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \Mnm\StructType\TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * Set Temperature value
     * @param \Mnm\StructType\TemperatureType[] $temperature
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setTemperature(array $temperature = array())
    {
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TemperatureType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToTemperature(\Mnm\StructType\TemperatureType $item)
    {
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \Mnm\StructType\AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \Mnm\StructType\AddressType $originAddress
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setOriginAddress(\Mnm\StructType\AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\StructType\DimensionType[] $measurementDimension
     * @return \Mnm\StructType\GoodsItemType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DimensionType $item
     * @return \Mnm\StructType\GoodsItemType
     */
    public function addToMeasurementDimension(\Mnm\StructType\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\GoodsItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
