<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeRateType StructType
 * @subpackage Structs
 */
class ExchangeRateType extends AbstractStructBase
{
    /**
     * The SourceCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q248:SourceCurrencyCode
     * @var \Mnm\StructType\SourceCurrencyCodeType
     */
    public $SourceCurrencyCode;
    /**
     * The TargetCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q249:TargetCurrencyCode
     * @var \Mnm\StructType\TargetCurrencyCodeType
     */
    public $TargetCurrencyCode;
    /**
     * The CalculationRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q250:CalculationRate
     * @var \Mnm\StructType\CalculationRateType
     */
    public $CalculationRate;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q251:Date
     * @var \Mnm\StructType\DateType
     */
    public $Date;
    /**
     * Constructor method for ExchangeRateType
     * @uses ExchangeRateType::setSourceCurrencyCode()
     * @uses ExchangeRateType::setTargetCurrencyCode()
     * @uses ExchangeRateType::setCalculationRate()
     * @uses ExchangeRateType::setDate()
     * @param \Mnm\StructType\SourceCurrencyCodeType $sourceCurrencyCode
     * @param \Mnm\StructType\TargetCurrencyCodeType $targetCurrencyCode
     * @param \Mnm\StructType\CalculationRateType $calculationRate
     * @param \Mnm\StructType\DateType $date
     */
    public function __construct(\Mnm\StructType\SourceCurrencyCodeType $sourceCurrencyCode = null, \Mnm\StructType\TargetCurrencyCodeType $targetCurrencyCode = null, \Mnm\StructType\CalculationRateType $calculationRate = null, \Mnm\StructType\DateType $date = null)
    {
        $this
            ->setSourceCurrencyCode($sourceCurrencyCode)
            ->setTargetCurrencyCode($targetCurrencyCode)
            ->setCalculationRate($calculationRate)
            ->setDate($date);
    }
    /**
     * Get SourceCurrencyCode value
     * @return \Mnm\StructType\SourceCurrencyCodeType|null
     */
    public function getSourceCurrencyCode()
    {
        return $this->SourceCurrencyCode;
    }
    /**
     * Set SourceCurrencyCode value
     * @param \Mnm\StructType\SourceCurrencyCodeType $sourceCurrencyCode
     * @return \Mnm\StructType\ExchangeRateType
     */
    public function setSourceCurrencyCode(\Mnm\StructType\SourceCurrencyCodeType $sourceCurrencyCode = null)
    {
        $this->SourceCurrencyCode = $sourceCurrencyCode;
        return $this;
    }
    /**
     * Get TargetCurrencyCode value
     * @return \Mnm\StructType\TargetCurrencyCodeType|null
     */
    public function getTargetCurrencyCode()
    {
        return $this->TargetCurrencyCode;
    }
    /**
     * Set TargetCurrencyCode value
     * @param \Mnm\StructType\TargetCurrencyCodeType $targetCurrencyCode
     * @return \Mnm\StructType\ExchangeRateType
     */
    public function setTargetCurrencyCode(\Mnm\StructType\TargetCurrencyCodeType $targetCurrencyCode = null)
    {
        $this->TargetCurrencyCode = $targetCurrencyCode;
        return $this;
    }
    /**
     * Get CalculationRate value
     * @return \Mnm\StructType\CalculationRateType|null
     */
    public function getCalculationRate()
    {
        return $this->CalculationRate;
    }
    /**
     * Set CalculationRate value
     * @param \Mnm\StructType\CalculationRateType $calculationRate
     * @return \Mnm\StructType\ExchangeRateType
     */
    public function setCalculationRate(\Mnm\StructType\CalculationRateType $calculationRate = null)
    {
        $this->CalculationRate = $calculationRate;
        return $this;
    }
    /**
     * Get Date value
     * @return \Mnm\StructType\DateType|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \Mnm\StructType\DateType $date
     * @return \Mnm\StructType\ExchangeRateType
     */
    public function setDate(\Mnm\StructType\DateType $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ExchangeRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
