<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q11:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:IssueDate
     * @var \Mnm\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:DocumentTypeCode
     * @var \Mnm\StructType\DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:DocumentType
     * @var \Mnm\StructType\DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q15:DocumentDescription
     * @var \Mnm\StructType\DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $IssuerParty;
    /**
     * Constructor method for DocumentReferenceType
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @param \Mnm\StructType\DocumentTypeCodeType $documentTypeCode
     * @param \Mnm\StructType\DocumentTypeType $documentType
     * @param \Mnm\StructType\DocumentDescriptionType[] $documentDescription
     * @param \Mnm\StructType\AttachmentType $attachment
     * @param \Mnm\StructType\PeriodType $validityPeriod
     * @param \Mnm\StructType\PartyType $issuerParty
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\IssueDateType $issueDate = null, \Mnm\StructType\DocumentTypeCodeType $documentTypeCode = null, \Mnm\StructType\DocumentTypeType $documentType = null, array $documentDescription = array(), \Mnm\StructType\AttachmentType $attachment = null, \Mnm\StructType\PeriodType $validityPeriod = null, \Mnm\StructType\PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setIssueDate(\Mnm\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return \Mnm\StructType\DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param \Mnm\StructType\DocumentTypeCodeType $documentTypeCode
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setDocumentTypeCode(\Mnm\StructType\DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \Mnm\StructType\DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \Mnm\StructType\DocumentTypeType $documentType
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setDocumentType(\Mnm\StructType\DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return \Mnm\StructType\DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * Set DocumentDescription value
     * @param \Mnm\StructType\DocumentDescriptionType[] $documentDescription
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Add item to DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentDescriptionType $item
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function addToDocumentDescription(\Mnm\StructType\DocumentDescriptionType $item)
    {
        $this->DocumentDescription[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Mnm\StructType\AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Mnm\StructType\AttachmentType $attachment
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setAttachment(\Mnm\StructType\AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \Mnm\StructType\PeriodType $validityPeriod
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setValidityPeriod(\Mnm\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IssuerParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }
    /**
     * Set IssuerParty value
     * @param \Mnm\StructType\PartyType $issuerParty
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public function setIssuerParty(\Mnm\StructType\PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\DocumentReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
