<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceType StructType
 * @subpackage Structs
 */
class BillingReferenceType extends AbstractStructBase
{
    /**
     * The InvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $InvoiceDocumentReference;
    /**
     * The SelfBilledInvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $SelfBilledInvoiceDocumentReference;
    /**
     * The CreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $CreditNoteDocumentReference;
    /**
     * The SelfBilledCreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $SelfBilledCreditNoteDocumentReference;
    /**
     * The DebitNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $DebitNoteDocumentReference;
    /**
     * The ReminderDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $ReminderDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $AdditionalDocumentReference;
    /**
     * The BillingReferenceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\BillingReferenceLineType[]
     */
    public $BillingReferenceLine;
    /**
     * Constructor method for BillingReferenceType
     * @uses BillingReferenceType::setInvoiceDocumentReference()
     * @uses BillingReferenceType::setSelfBilledInvoiceDocumentReference()
     * @uses BillingReferenceType::setCreditNoteDocumentReference()
     * @uses BillingReferenceType::setSelfBilledCreditNoteDocumentReference()
     * @uses BillingReferenceType::setDebitNoteDocumentReference()
     * @uses BillingReferenceType::setReminderDocumentReference()
     * @uses BillingReferenceType::setAdditionalDocumentReference()
     * @uses BillingReferenceType::setBillingReferenceLine()
     * @param \Mnm\StructType\DocumentReferenceType $invoiceDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $creditNoteDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $debitNoteDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $reminderDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType $additionalDocumentReference
     * @param \Mnm\StructType\BillingReferenceLineType[] $billingReferenceLine
     */
    public function __construct(\Mnm\StructType\DocumentReferenceType $invoiceDocumentReference = null, \Mnm\StructType\DocumentReferenceType $selfBilledInvoiceDocumentReference = null, \Mnm\StructType\DocumentReferenceType $creditNoteDocumentReference = null, \Mnm\StructType\DocumentReferenceType $selfBilledCreditNoteDocumentReference = null, \Mnm\StructType\DocumentReferenceType $debitNoteDocumentReference = null, \Mnm\StructType\DocumentReferenceType $reminderDocumentReference = null, \Mnm\StructType\DocumentReferenceType $additionalDocumentReference = null, array $billingReferenceLine = array())
    {
        $this
            ->setInvoiceDocumentReference($invoiceDocumentReference)
            ->setSelfBilledInvoiceDocumentReference($selfBilledInvoiceDocumentReference)
            ->setCreditNoteDocumentReference($creditNoteDocumentReference)
            ->setSelfBilledCreditNoteDocumentReference($selfBilledCreditNoteDocumentReference)
            ->setDebitNoteDocumentReference($debitNoteDocumentReference)
            ->setReminderDocumentReference($reminderDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setBillingReferenceLine($billingReferenceLine);
    }
    /**
     * Get InvoiceDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getInvoiceDocumentReference()
    {
        return $this->InvoiceDocumentReference;
    }
    /**
     * Set InvoiceDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $invoiceDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setInvoiceDocumentReference(\Mnm\StructType\DocumentReferenceType $invoiceDocumentReference = null)
    {
        $this->InvoiceDocumentReference = $invoiceDocumentReference;
        return $this;
    }
    /**
     * Get SelfBilledInvoiceDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getSelfBilledInvoiceDocumentReference()
    {
        return $this->SelfBilledInvoiceDocumentReference;
    }
    /**
     * Set SelfBilledInvoiceDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setSelfBilledInvoiceDocumentReference(\Mnm\StructType\DocumentReferenceType $selfBilledInvoiceDocumentReference = null)
    {
        $this->SelfBilledInvoiceDocumentReference = $selfBilledInvoiceDocumentReference;
        return $this;
    }
    /**
     * Get CreditNoteDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getCreditNoteDocumentReference()
    {
        return $this->CreditNoteDocumentReference;
    }
    /**
     * Set CreditNoteDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $creditNoteDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setCreditNoteDocumentReference(\Mnm\StructType\DocumentReferenceType $creditNoteDocumentReference = null)
    {
        $this->CreditNoteDocumentReference = $creditNoteDocumentReference;
        return $this;
    }
    /**
     * Get SelfBilledCreditNoteDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getSelfBilledCreditNoteDocumentReference()
    {
        return $this->SelfBilledCreditNoteDocumentReference;
    }
    /**
     * Set SelfBilledCreditNoteDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setSelfBilledCreditNoteDocumentReference(\Mnm\StructType\DocumentReferenceType $selfBilledCreditNoteDocumentReference = null)
    {
        $this->SelfBilledCreditNoteDocumentReference = $selfBilledCreditNoteDocumentReference;
        return $this;
    }
    /**
     * Get DebitNoteDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getDebitNoteDocumentReference()
    {
        return $this->DebitNoteDocumentReference;
    }
    /**
     * Set DebitNoteDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $debitNoteDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setDebitNoteDocumentReference(\Mnm\StructType\DocumentReferenceType $debitNoteDocumentReference = null)
    {
        $this->DebitNoteDocumentReference = $debitNoteDocumentReference;
        return $this;
    }
    /**
     * Get ReminderDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getReminderDocumentReference()
    {
        return $this->ReminderDocumentReference;
    }
    /**
     * Set ReminderDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $reminderDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setReminderDocumentReference(\Mnm\StructType\DocumentReferenceType $reminderDocumentReference = null)
    {
        $this->ReminderDocumentReference = $reminderDocumentReference;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * Set AdditionalDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $additionalDocumentReference
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setAdditionalDocumentReference(\Mnm\StructType\DocumentReferenceType $additionalDocumentReference = null)
    {
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Get BillingReferenceLine value
     * @return \Mnm\StructType\BillingReferenceLineType[]|null
     */
    public function getBillingReferenceLine()
    {
        return $this->BillingReferenceLine;
    }
    /**
     * Set BillingReferenceLine value
     * @param \Mnm\StructType\BillingReferenceLineType[] $billingReferenceLine
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function setBillingReferenceLine(array $billingReferenceLine = array())
    {
        $this->BillingReferenceLine = $billingReferenceLine;
        return $this;
    }
    /**
     * Add item to BillingReferenceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\BillingReferenceLineType $item
     * @return \Mnm\StructType\BillingReferenceType
     */
    public function addToBillingReferenceLine(\Mnm\StructType\BillingReferenceLineType $item)
    {
        $this->BillingReferenceLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\BillingReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
