<?php

namespace Mnm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IsEInvoiceUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Mnm\StructType\IsEInvoiceUser $parameters
     * @return \Mnm\StructType\IsEInvoiceUserResponse|bool
     */
    public function IsEInvoiceUser(\Mnm\StructType\IsEInvoiceUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsEInvoiceUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Mnm\StructType\IsEInvoiceUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
