<?php

namespace Mnm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoice ServiceType
 * @subpackage Services
 */
class Invoice extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Mnm\StructType\SendInvoice $parameters
     * @return \Mnm\StructType\SendInvoiceResponse|bool
     */
    public function SendInvoice(\Mnm\StructType\SendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Mnm\StructType\SendInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
