<?php

namespace Mnm\EnumType;

/**
 * This class stands for InvoiceStatus EnumType
 * @subpackage Enumerations
 */
class InvoiceStatus
{
    /**
     * Constant for value 'NotPrepared'
     * @return string 'NotPrepared'
     */
    const VALUE_NOT_PREPARED = 'NotPrepared';
    /**
     * Constant for value 'NotSend'
     * @return string 'NotSend'
     */
    const VALUE_NOT_SEND = 'NotSend';
    /**
     * Constant for value 'Draft'
     * @return string 'Draft'
     */
    const VALUE_DRAFT = 'Draft';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Queued'
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'SentToGib'
     * @return string 'SentToGib'
     */
    const VALUE_SENT_TO_GIB = 'SentToGib';
    /**
     * Constant for value 'Approved'
     * @return string 'Approved'
     */
    const VALUE_APPROVED = 'Approved';
    /**
     * Constant for value 'WaitingForAprovement'
     * @return string 'WaitingForAprovement'
     */
    const VALUE_WAITING_FOR_APROVEMENT = 'WaitingForAprovement';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'Return'
     * @return string 'Return'
     */
    const VALUE_RETURN = 'Return';
    /**
     * Constant for value 'EArchivedCanceled'
     * @return string 'EArchivedCanceled'
     */
    const VALUE_EARCHIVED_CANCELED = 'EArchivedCanceled';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_PREPARED
     * @uses self::VALUE_NOT_SEND
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_SENT_TO_GIB
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_WAITING_FOR_APROVEMENT
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_RETURN
     * @uses self::VALUE_EARCHIVED_CANCELED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_PREPARED,
            self::VALUE_NOT_SEND,
            self::VALUE_DRAFT,
            self::VALUE_CANCELED,
            self::VALUE_QUEUED,
            self::VALUE_PROCESSING,
            self::VALUE_SENT_TO_GIB,
            self::VALUE_APPROVED,
            self::VALUE_WAITING_FOR_APROVEMENT,
            self::VALUE_DECLINED,
            self::VALUE_RETURN,
            self::VALUE_EARCHIVED_CANCELED,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
