<?php

namespace Mnm\EnumType;

/**
 * This class stands for InvoiceDeliveryType EnumType
 * @subpackage Enumerations
 */
class InvoiceDeliveryType
{
    /**
     * Constant for value 'Paper'
     * @return string 'Paper'
     */
    const VALUE_PAPER = 'Paper';
    /**
     * Constant for value 'Electronic'
     * @return string 'Electronic'
     */
    const VALUE_ELECTRONIC = 'Electronic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAPER
     * @uses self::VALUE_ELECTRONIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAPER,
            self::VALUE_ELECTRONIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
