<?php

namespace Mnm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineResponseInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfLineResponseInfo extends AbstractStructArrayBase
{
    /**
     * The LineResponseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Mnm\StructType\LineResponseInfo[]
     */
    public $LineResponseInfo;
    /**
     * Constructor method for ArrayOfLineResponseInfo
     * @uses ArrayOfLineResponseInfo::setLineResponseInfo()
     * @param \Mnm\StructType\LineResponseInfo[] $lineResponseInfo
     */
    public function __construct(array $lineResponseInfo = array())
    {
        $this
            ->setLineResponseInfo($lineResponseInfo);
    }
    /**
     * Get LineResponseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Mnm\StructType\LineResponseInfo[]|null
     */
    public function getLineResponseInfo()
    {
        return isset($this->LineResponseInfo) ? $this->LineResponseInfo : null;
    }
    /**
     * Set LineResponseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Mnm\StructType\LineResponseInfo[] $lineResponseInfo
     * @return \Mnm\ArrayType\ArrayOfLineResponseInfo
     */
    public function setLineResponseInfo(array $lineResponseInfo = array())
    {
        if (is_null($lineResponseInfo) || (is_array($lineResponseInfo) && empty($lineResponseInfo))) {
            unset($this->LineResponseInfo);
        } else {
            $this->LineResponseInfo = $lineResponseInfo;
        }
        return $this;
    }
    /**
     * Add item to LineResponseInfo value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\LineResponseInfo $item
     * @return \Mnm\ArrayType\ArrayOfLineResponseInfo
     */
    public function addToLineResponseInfo(\Mnm\StructType\LineResponseInfo $item)
    {
        $this->LineResponseInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Mnm\StructType\LineResponseInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Mnm\StructType\LineResponseInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Mnm\StructType\LineResponseInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Mnm\StructType\LineResponseInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Mnm\StructType\LineResponseInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineResponseInfo
     */
    public function getAttributeName()
    {
        return 'LineResponseInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ArrayType\ArrayOfLineResponseInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
