<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonType StructType
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q61:FirstName
     * @var \Mnm\StructType\FirstNameType
     */
    public $FirstName;
    /**
     * The FamilyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q62:FamilyName
     * @var \Mnm\StructType\FamilyNameType
     */
    public $FamilyName;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q63:Title
     * @var \Mnm\StructType\TitleType
     */
    public $Title;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q64:MiddleName
     * @var \Mnm\StructType\MiddleNameType
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q65:NameSuffix
     * @var \Mnm\StructType\NameSuffixType
     */
    public $NameSuffix;
    /**
     * The NationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q66:NationalityID
     * @var \Mnm\StructType\NationalityIDType
     */
    public $NationalityID;
    /**
     * The FinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\FinancialAccountType
     */
    public $FinancialAccount;
    /**
     * The IdentityDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $IdentityDocumentReference;
    /**
     * Constructor method for PersonType
     * @uses PersonType::setFirstName()
     * @uses PersonType::setFamilyName()
     * @uses PersonType::setTitle()
     * @uses PersonType::setMiddleName()
     * @uses PersonType::setNameSuffix()
     * @uses PersonType::setNationalityID()
     * @uses PersonType::setFinancialAccount()
     * @uses PersonType::setIdentityDocumentReference()
     * @param \Mnm\StructType\FirstNameType $firstName
     * @param \Mnm\StructType\FamilyNameType $familyName
     * @param \Mnm\StructType\TitleType $title
     * @param \Mnm\StructType\MiddleNameType $middleName
     * @param \Mnm\StructType\NameSuffixType $nameSuffix
     * @param \Mnm\StructType\NationalityIDType $nationalityID
     * @param \Mnm\StructType\FinancialAccountType $financialAccount
     * @param \Mnm\StructType\DocumentReferenceType $identityDocumentReference
     */
    public function __construct(\Mnm\StructType\FirstNameType $firstName = null, \Mnm\StructType\FamilyNameType $familyName = null, \Mnm\StructType\TitleType $title = null, \Mnm\StructType\MiddleNameType $middleName = null, \Mnm\StructType\NameSuffixType $nameSuffix = null, \Mnm\StructType\NationalityIDType $nationalityID = null, \Mnm\StructType\FinancialAccountType $financialAccount = null, \Mnm\StructType\DocumentReferenceType $identityDocumentReference = null)
    {
        $this
            ->setFirstName($firstName)
            ->setFamilyName($familyName)
            ->setTitle($title)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setNationalityID($nationalityID)
            ->setFinancialAccount($financialAccount)
            ->setIdentityDocumentReference($identityDocumentReference);
    }
    /**
     * Get FirstName value
     * @return \Mnm\StructType\FirstNameType|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param \Mnm\StructType\FirstNameType $firstName
     * @return \Mnm\StructType\PersonType
     */
    public function setFirstName(\Mnm\StructType\FirstNameType $firstName = null)
    {
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get FamilyName value
     * @return \Mnm\StructType\FamilyNameType|null
     */
    public function getFamilyName()
    {
        return $this->FamilyName;
    }
    /**
     * Set FamilyName value
     * @param \Mnm\StructType\FamilyNameType $familyName
     * @return \Mnm\StructType\PersonType
     */
    public function setFamilyName(\Mnm\StructType\FamilyNameType $familyName = null)
    {
        $this->FamilyName = $familyName;
        return $this;
    }
    /**
     * Get Title value
     * @return \Mnm\StructType\TitleType|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param \Mnm\StructType\TitleType $title
     * @return \Mnm\StructType\PersonType
     */
    public function setTitle(\Mnm\StructType\TitleType $title = null)
    {
        $this->Title = $title;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return \Mnm\StructType\MiddleNameType|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param \Mnm\StructType\MiddleNameType $middleName
     * @return \Mnm\StructType\PersonType
     */
    public function setMiddleName(\Mnm\StructType\MiddleNameType $middleName = null)
    {
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return \Mnm\StructType\NameSuffixType|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param \Mnm\StructType\NameSuffixType $nameSuffix
     * @return \Mnm\StructType\PersonType
     */
    public function setNameSuffix(\Mnm\StructType\NameSuffixType $nameSuffix = null)
    {
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get NationalityID value
     * @return \Mnm\StructType\NationalityIDType|null
     */
    public function getNationalityID()
    {
        return $this->NationalityID;
    }
    /**
     * Set NationalityID value
     * @param \Mnm\StructType\NationalityIDType $nationalityID
     * @return \Mnm\StructType\PersonType
     */
    public function setNationalityID(\Mnm\StructType\NationalityIDType $nationalityID = null)
    {
        $this->NationalityID = $nationalityID;
        return $this;
    }
    /**
     * Get FinancialAccount value
     * @return \Mnm\StructType\FinancialAccountType|null
     */
    public function getFinancialAccount()
    {
        return $this->FinancialAccount;
    }
    /**
     * Set FinancialAccount value
     * @param \Mnm\StructType\FinancialAccountType $financialAccount
     * @return \Mnm\StructType\PersonType
     */
    public function setFinancialAccount(\Mnm\StructType\FinancialAccountType $financialAccount = null)
    {
        $this->FinancialAccount = $financialAccount;
        return $this;
    }
    /**
     * Get IdentityDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getIdentityDocumentReference()
    {
        return $this->IdentityDocumentReference;
    }
    /**
     * Set IdentityDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $identityDocumentReference
     * @return \Mnm\StructType\PersonType
     */
    public function setIdentityDocumentReference(\Mnm\StructType\DocumentReferenceType $identityDocumentReference = null)
    {
        $this->IdentityDocumentReference = $identityDocumentReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
