<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q243:Note
     * @var \Mnm\StructType\NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q244:PenaltySurchargePercent
     * @var \Mnm\StructType\PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q245:Amount
     * @var \Mnm\StructType\AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q246:PenaltyAmount
     * @var \Mnm\StructType\PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q247:PaymentDueDate
     * @var \Mnm\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTermsType
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     * @param \Mnm\StructType\NoteType $note
     * @param \Mnm\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @param \Mnm\StructType\AmountType $amount
     * @param \Mnm\StructType\PenaltyAmountType $penaltyAmount
     * @param \Mnm\StructType\PaymentDueDateType $paymentDueDate
     * @param \Mnm\StructType\PeriodType $settlementPeriod
     */
    public function __construct(\Mnm\StructType\NoteType $note = null, \Mnm\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null, \Mnm\StructType\AmountType $amount = null, \Mnm\StructType\PenaltyAmountType $penaltyAmount = null, \Mnm\StructType\PaymentDueDateType $paymentDueDate = null, \Mnm\StructType\PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Note value
     * @return \Mnm\StructType\NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\StructType\NoteType $note
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setNote(\Mnm\StructType\NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return \Mnm\StructType\PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param \Mnm\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setPenaltySurchargePercent(\Mnm\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Mnm\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Mnm\StructType\AmountType $amount
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setAmount(\Mnm\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return \Mnm\StructType\PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param \Mnm\StructType\PenaltyAmountType $penaltyAmount
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setPenaltyAmount(\Mnm\StructType\PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Mnm\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Mnm\StructType\PaymentDueDateType $paymentDueDate
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setPaymentDueDate(\Mnm\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }
    /**
     * Set SettlementPeriod value
     * @param \Mnm\StructType\PeriodType $settlementPeriod
     * @return \Mnm\StructType\PaymentTermsType
     */
    public function setSettlementPeriod(\Mnm\StructType\PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PaymentTermsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
