<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedResponseOfInvoiceData StructType
 * @subpackage Structs
 */
class PagedResponseOfInvoiceData extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalCount;
    /**
     * The TotalPages
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\InvoiceData[]
     */
    public $Items;
    /**
     * Constructor method for PagedResponseOfInvoiceData
     * @uses PagedResponseOfInvoiceData::setPageIndex()
     * @uses PagedResponseOfInvoiceData::setPageSize()
     * @uses PagedResponseOfInvoiceData::setTotalCount()
     * @uses PagedResponseOfInvoiceData::setTotalPages()
     * @uses PagedResponseOfInvoiceData::setItems()
     * @param int $pageIndex
     * @param int $pageSize
     * @param int $totalCount
     * @param int $totalPages
     * @param \Mnm\StructType\InvoiceData[] $items
     */
    public function __construct($pageIndex = null, $pageSize = null, $totalCount = null, $totalPages = null, array $items = array())
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setTotalCount($totalCount)
            ->setTotalPages($totalPages)
            ->setItems($items);
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function setPageIndex($pageIndex = null)
    {
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function setPageSize($pageSize = null)
    {
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get TotalCount value
     * @return int
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }
    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function setTotalCount($totalCount = null)
    {
        $this->TotalCount = $totalCount;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function setTotalPages($totalPages = null)
    {
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get Items value
     * @return \Mnm\StructType\InvoiceData[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \Mnm\StructType\InvoiceData[] $items
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function setItems(array $items = array())
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Add item to Items value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\InvoiceData $item
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public function addToItems(\Mnm\StructType\InvoiceData $item)
    {
        $this->Items[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\PagedResponseOfInvoiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
