<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLineReferenceType StructType
 * @subpackage Structs
 */
class OrderLineReferenceType extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q171:LineID
     * @var \Mnm\StructType\LineIDType
     */
    public $LineID;
    /**
     * The SalesOrderLineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q172:SalesOrderLineID
     * @var \Mnm\StructType\SalesOrderLineIDType
     */
    public $SalesOrderLineID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q173:UUID
     * @var \Mnm\StructType\UUIDType
     */
    public $UUID;
    /**
     * The LineStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q174:LineStatusCode
     * @var \Mnm\StructType\LineStatusCodeType
     */
    public $LineStatusCode;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * Constructor method for OrderLineReferenceType
     * @uses OrderLineReferenceType::setLineID()
     * @uses OrderLineReferenceType::setSalesOrderLineID()
     * @uses OrderLineReferenceType::setUUID()
     * @uses OrderLineReferenceType::setLineStatusCode()
     * @uses OrderLineReferenceType::setOrderReference()
     * @param \Mnm\StructType\LineIDType $lineID
     * @param \Mnm\StructType\SalesOrderLineIDType $salesOrderLineID
     * @param \Mnm\StructType\UUIDType $uUID
     * @param \Mnm\StructType\LineStatusCodeType $lineStatusCode
     * @param \Mnm\StructType\OrderReferenceType $orderReference
     */
    public function __construct(\Mnm\StructType\LineIDType $lineID = null, \Mnm\StructType\SalesOrderLineIDType $salesOrderLineID = null, \Mnm\StructType\UUIDType $uUID = null, \Mnm\StructType\LineStatusCodeType $lineStatusCode = null, \Mnm\StructType\OrderReferenceType $orderReference = null)
    {
        $this
            ->setLineID($lineID)
            ->setSalesOrderLineID($salesOrderLineID)
            ->setUUID($uUID)
            ->setLineStatusCode($lineStatusCode)
            ->setOrderReference($orderReference);
    }
    /**
     * Get LineID value
     * @return \Mnm\StructType\LineIDType|null
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param \Mnm\StructType\LineIDType $lineID
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public function setLineID(\Mnm\StructType\LineIDType $lineID = null)
    {
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get SalesOrderLineID value
     * @return \Mnm\StructType\SalesOrderLineIDType|null
     */
    public function getSalesOrderLineID()
    {
        return $this->SalesOrderLineID;
    }
    /**
     * Set SalesOrderLineID value
     * @param \Mnm\StructType\SalesOrderLineIDType $salesOrderLineID
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public function setSalesOrderLineID(\Mnm\StructType\SalesOrderLineIDType $salesOrderLineID = null)
    {
        $this->SalesOrderLineID = $salesOrderLineID;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Mnm\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Mnm\StructType\UUIDType $uUID
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public function setUUID(\Mnm\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get LineStatusCode value
     * @return \Mnm\StructType\LineStatusCodeType|null
     */
    public function getLineStatusCode()
    {
        return $this->LineStatusCode;
    }
    /**
     * Set LineStatusCode value
     * @param \Mnm\StructType\LineStatusCodeType $lineStatusCode
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public function setLineStatusCode(\Mnm\StructType\LineStatusCodeType $lineStatusCode = null)
    {
        $this->LineStatusCode = $lineStatusCode;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Mnm\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Mnm\StructType\OrderReferenceType $orderReference
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public function setOrderReference(\Mnm\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\OrderLineReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
