<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q209:VesselID
     * @var \Mnm\StructType\VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q210:VesselName
     * @var \Mnm\StructType\VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q211:RadioCallSignID
     * @var \Mnm\StructType\RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q212:ShipsRequirements
     * @var \Mnm\StructType\ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q213:GrossTonnageMeasure
     * @var \Mnm\StructType\GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q214:NetTonnageMeasure
     * @var \Mnm\StructType\NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LocationType
     */
    public $RegistryPortLocation;
    /**
     * Constructor method for MaritimeTransportType
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     * @param \Mnm\StructType\VesselIDType $vesselID
     * @param \Mnm\StructType\VesselNameType $vesselName
     * @param \Mnm\StructType\RadioCallSignIDType $radioCallSignID
     * @param \Mnm\StructType\ShipsRequirementsType[] $shipsRequirements
     * @param \Mnm\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @param \Mnm\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @param \Mnm\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @param \Mnm\StructType\LocationType $registryPortLocation
     */
    public function __construct(\Mnm\StructType\VesselIDType $vesselID = null, \Mnm\StructType\VesselNameType $vesselName = null, \Mnm\StructType\RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), \Mnm\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null, \Mnm\StructType\NetTonnageMeasureType $netTonnageMeasure = null, \Mnm\StructType\DocumentReferenceType $registryCertificateDocumentReference = null, \Mnm\StructType\LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }
    /**
     * Get VesselID value
     * @return \Mnm\StructType\VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }
    /**
     * Set VesselID value
     * @param \Mnm\StructType\VesselIDType $vesselID
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setVesselID(\Mnm\StructType\VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }
    /**
     * Get VesselName value
     * @return \Mnm\StructType\VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }
    /**
     * Set VesselName value
     * @param \Mnm\StructType\VesselNameType $vesselName
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setVesselName(\Mnm\StructType\VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }
    /**
     * Get RadioCallSignID value
     * @return \Mnm\StructType\RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }
    /**
     * Set RadioCallSignID value
     * @param \Mnm\StructType\RadioCallSignIDType $radioCallSignID
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setRadioCallSignID(\Mnm\StructType\RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }
    /**
     * Get ShipsRequirements value
     * @return \Mnm\StructType\ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }
    /**
     * Set ShipsRequirements value
     * @param \Mnm\StructType\ShipsRequirementsType[] $shipsRequirements
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }
    /**
     * Add item to ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ShipsRequirementsType $item
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function addToShipsRequirements(\Mnm\StructType\ShipsRequirementsType $item)
    {
        $this->ShipsRequirements[] = $item;
        return $this;
    }
    /**
     * Get GrossTonnageMeasure value
     * @return \Mnm\StructType\GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }
    /**
     * Set GrossTonnageMeasure value
     * @param \Mnm\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setGrossTonnageMeasure(\Mnm\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }
    /**
     * Get NetTonnageMeasure value
     * @return \Mnm\StructType\NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }
    /**
     * Set NetTonnageMeasure value
     * @param \Mnm\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setNetTonnageMeasure(\Mnm\StructType\NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }
    /**
     * Get RegistryCertificateDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }
    /**
     * Set RegistryCertificateDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(\Mnm\StructType\DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }
    /**
     * Get RegistryPortLocation value
     * @return \Mnm\StructType\LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }
    /**
     * Set RegistryPortLocation value
     * @param \Mnm\StructType\LocationType $registryPortLocation
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public function setRegistryPortLocation(\Mnm\StructType\LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\MaritimeTransportType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
