<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q1:UBLExtensions
     * @var \Mnm\ArrayType\ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q2:UBLVersionID
     * @var \Mnm\StructType\UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q3:CustomizationID
     * @var \Mnm\StructType\CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q4:ProfileID
     * @var \Mnm\StructType\ProfileIDType
     */
    public $ProfileID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q5:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q6:CopyIndicator
     * @var \Mnm\StructType\CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q7:UUID
     * @var \Mnm\StructType\UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q8:IssueDate
     * @var \Mnm\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q9:IssueTime
     * @var \Mnm\StructType\IssueTimeType
     */
    public $IssueTime;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q10:InvoiceTypeCode
     * @var \Mnm\StructType\InvoiceTypeCodeType
     */
    public $InvoiceTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q11:Note
     * @var \Mnm\StructType\NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:DocumentCurrencyCode
     * @var \Mnm\StructType\DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:TaxCurrencyCode
     * @var \Mnm\StructType\TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:PricingCurrencyCode
     * @var \Mnm\StructType\PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q15:PaymentCurrencyCode
     * @var \Mnm\StructType\PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q16:PaymentAlternativeCurrencyCode
     * @var \Mnm\StructType\PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q17:AccountingCost
     * @var \Mnm\StructType\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:LineCountNumeric
     * @var \Mnm\StructType\LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:InvoicePeriod
     * @var \Mnm\StructType\PeriodType
     */
    public $InvoicePeriod;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:OrderReference
     * @var \Mnm\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q21:BillingReference
     * @var \Mnm\StructType\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q22:DespatchDocumentReference
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q23:ReceiptDocumentReference
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q24:OriginatorDocumentReference
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q25:ContractDocumentReference
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q26:AdditionalDocumentReference
     * @var \Mnm\StructType\DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q27:Signature
     * @var \Mnm\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q28:AccountingSupplierParty
     * @var \Mnm\StructType\SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q29:AccountingCustomerParty
     * @var \Mnm\StructType\CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q30:BuyerCustomerParty
     * @var \Mnm\StructType\CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q31:SellerSupplierParty
     * @var \Mnm\StructType\SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q32:TaxRepresentativeParty
     * @var \Mnm\StructType\PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q33:Delivery
     * @var \Mnm\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q34:PaymentMeans
     * @var \Mnm\StructType\PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q35:PaymentTerms
     * @var \Mnm\StructType\PaymentTermsType
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q36:AllowanceCharge
     * @var \Mnm\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q37:TaxExchangeRate
     * @var \Mnm\StructType\ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q38:PricingExchangeRate
     * @var \Mnm\StructType\ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q39:PaymentExchangeRate
     * @var \Mnm\StructType\ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q40:PaymentAlternativeExchangeRate
     * @var \Mnm\StructType\ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q41:TaxTotal
     * @var \Mnm\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q42:WithholdingTaxTotal
     * @var \Mnm\StructType\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q43:LegalMonetaryTotal
     * @var \Mnm\StructType\MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q44:InvoiceLine
     * @var \Mnm\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The schemaLocation
     * @var string
     */
    public $schemaLocation;
    /**
     * Constructor method for InvoiceType
     * @uses InvoiceType::setUBLExtensions()
     * @uses InvoiceType::setUBLVersionID()
     * @uses InvoiceType::setCustomizationID()
     * @uses InvoiceType::setProfileID()
     * @uses InvoiceType::setID()
     * @uses InvoiceType::setCopyIndicator()
     * @uses InvoiceType::setUUID()
     * @uses InvoiceType::setIssueDate()
     * @uses InvoiceType::setIssueTime()
     * @uses InvoiceType::setInvoiceTypeCode()
     * @uses InvoiceType::setNote()
     * @uses InvoiceType::setDocumentCurrencyCode()
     * @uses InvoiceType::setTaxCurrencyCode()
     * @uses InvoiceType::setPricingCurrencyCode()
     * @uses InvoiceType::setPaymentCurrencyCode()
     * @uses InvoiceType::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceType::setAccountingCost()
     * @uses InvoiceType::setLineCountNumeric()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setOrderReference()
     * @uses InvoiceType::setBillingReference()
     * @uses InvoiceType::setDespatchDocumentReference()
     * @uses InvoiceType::setReceiptDocumentReference()
     * @uses InvoiceType::setOriginatorDocumentReference()
     * @uses InvoiceType::setContractDocumentReference()
     * @uses InvoiceType::setAdditionalDocumentReference()
     * @uses InvoiceType::setSignature()
     * @uses InvoiceType::setAccountingSupplierParty()
     * @uses InvoiceType::setAccountingCustomerParty()
     * @uses InvoiceType::setBuyerCustomerParty()
     * @uses InvoiceType::setSellerSupplierParty()
     * @uses InvoiceType::setTaxRepresentativeParty()
     * @uses InvoiceType::setDelivery()
     * @uses InvoiceType::setPaymentMeans()
     * @uses InvoiceType::setPaymentTerms()
     * @uses InvoiceType::setAllowanceCharge()
     * @uses InvoiceType::setTaxExchangeRate()
     * @uses InvoiceType::setPricingExchangeRate()
     * @uses InvoiceType::setPaymentExchangeRate()
     * @uses InvoiceType::setPaymentAlternativeExchangeRate()
     * @uses InvoiceType::setTaxTotal()
     * @uses InvoiceType::setWithholdingTaxTotal()
     * @uses InvoiceType::setLegalMonetaryTotal()
     * @uses InvoiceType::setInvoiceLine()
     * @uses InvoiceType::setSchemaLocation()
     * @param \Mnm\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @param \Mnm\StructType\UBLVersionIDType $uBLVersionID
     * @param \Mnm\StructType\CustomizationIDType $customizationID
     * @param \Mnm\StructType\ProfileIDType $profileID
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\CopyIndicatorType $copyIndicator
     * @param \Mnm\StructType\UUIDType $uUID
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @param \Mnm\StructType\IssueTimeType $issueTime
     * @param \Mnm\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @param \Mnm\StructType\NoteType[] $note
     * @param \Mnm\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @param \Mnm\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @param \Mnm\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @param \Mnm\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @param \Mnm\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param \Mnm\StructType\AccountingCostType $accountingCost
     * @param \Mnm\StructType\LineCountNumericType $lineCountNumeric
     * @param \Mnm\StructType\PeriodType $invoicePeriod
     * @param \Mnm\StructType\OrderReferenceType $orderReference
     * @param \Mnm\StructType\BillingReferenceType[] $billingReference
     * @param \Mnm\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType[] $contractDocumentReference
     * @param \Mnm\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @param \Mnm\StructType\SignatureType[] $signature
     * @param \Mnm\StructType\SupplierPartyType $accountingSupplierParty
     * @param \Mnm\StructType\CustomerPartyType $accountingCustomerParty
     * @param \Mnm\StructType\CustomerPartyType $buyerCustomerParty
     * @param \Mnm\StructType\SupplierPartyType $sellerSupplierParty
     * @param \Mnm\StructType\PartyType $taxRepresentativeParty
     * @param \Mnm\StructType\DeliveryType[] $delivery
     * @param \Mnm\StructType\PaymentMeansType[] $paymentMeans
     * @param \Mnm\StructType\PaymentTermsType $paymentTerms
     * @param \Mnm\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \Mnm\StructType\ExchangeRateType $taxExchangeRate
     * @param \Mnm\StructType\ExchangeRateType $pricingExchangeRate
     * @param \Mnm\StructType\ExchangeRateType $paymentExchangeRate
     * @param \Mnm\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @param \Mnm\StructType\TaxTotalType[] $taxTotal
     * @param \Mnm\StructType\TaxTotalType[] $withholdingTaxTotal
     * @param \Mnm\StructType\MonetaryTotalType $legalMonetaryTotal
     * @param \Mnm\StructType\InvoiceLineType[] $invoiceLine
     * @param string $schemaLocation
     */
    public function __construct(\Mnm\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null, \Mnm\StructType\UBLVersionIDType $uBLVersionID = null, \Mnm\StructType\CustomizationIDType $customizationID = null, \Mnm\StructType\ProfileIDType $profileID = null, \Mnm\StructType\IDType $iD = null, \Mnm\StructType\CopyIndicatorType $copyIndicator = null, \Mnm\StructType\UUIDType $uUID = null, \Mnm\StructType\IssueDateType $issueDate = null, \Mnm\StructType\IssueTimeType $issueTime = null, \Mnm\StructType\InvoiceTypeCodeType $invoiceTypeCode = null, array $note = array(), \Mnm\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null, \Mnm\StructType\TaxCurrencyCodeType $taxCurrencyCode = null, \Mnm\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null, \Mnm\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null, \Mnm\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, \Mnm\StructType\AccountingCostType $accountingCost = null, \Mnm\StructType\LineCountNumericType $lineCountNumeric = null, \Mnm\StructType\PeriodType $invoicePeriod = null, \Mnm\StructType\OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $originatorDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $signature = array(), \Mnm\StructType\SupplierPartyType $accountingSupplierParty = null, \Mnm\StructType\CustomerPartyType $accountingCustomerParty = null, \Mnm\StructType\CustomerPartyType $buyerCustomerParty = null, \Mnm\StructType\SupplierPartyType $sellerSupplierParty = null, \Mnm\StructType\PartyType $taxRepresentativeParty = null, array $delivery = array(), array $paymentMeans = array(), \Mnm\StructType\PaymentTermsType $paymentTerms = null, array $allowanceCharge = array(), \Mnm\StructType\ExchangeRateType $taxExchangeRate = null, \Mnm\StructType\ExchangeRateType $pricingExchangeRate = null, \Mnm\StructType\ExchangeRateType $paymentExchangeRate = null, \Mnm\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null, array $taxTotal = array(), array $withholdingTaxTotal = array(), \Mnm\StructType\MonetaryTotalType $legalMonetaryTotal = null, array $invoiceLine = array(), $schemaLocation = null)
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceLine($invoiceLine)
            ->setSchemaLocation($schemaLocation);
    }
    /**
     * Get UBLExtensions value
     * @return \Mnm\ArrayType\ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }
    /**
     * Set UBLExtensions value
     * @param \Mnm\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @return \Mnm\StructType\InvoiceType
     */
    public function setUBLExtensions(\Mnm\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return \Mnm\StructType\UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param \Mnm\StructType\UBLVersionIDType $uBLVersionID
     * @return \Mnm\StructType\InvoiceType
     */
    public function setUBLVersionID(\Mnm\StructType\UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return \Mnm\StructType\CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param \Mnm\StructType\CustomizationIDType $customizationID
     * @return \Mnm\StructType\InvoiceType
     */
    public function setCustomizationID(\Mnm\StructType\CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return \Mnm\StructType\ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param \Mnm\StructType\ProfileIDType $profileID
     * @return \Mnm\StructType\InvoiceType
     */
    public function setProfileID(\Mnm\StructType\ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\InvoiceType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return \Mnm\StructType\CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param \Mnm\StructType\CopyIndicatorType $copyIndicator
     * @return \Mnm\StructType\InvoiceType
     */
    public function setCopyIndicator(\Mnm\StructType\CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Mnm\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Mnm\StructType\UUIDType $uUID
     * @return \Mnm\StructType\InvoiceType
     */
    public function setUUID(\Mnm\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\StructType\IssueDateType $issueDate
     * @return \Mnm\StructType\InvoiceType
     */
    public function setIssueDate(\Mnm\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return \Mnm\StructType\IssueTimeType|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param \Mnm\StructType\IssueTimeType $issueTime
     * @return \Mnm\StructType\InvoiceType
     */
    public function setIssueTime(\Mnm\StructType\IssueTimeType $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return \Mnm\StructType\InvoiceTypeCodeType|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param \Mnm\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setInvoiceTypeCode(\Mnm\StructType\InvoiceTypeCodeType $invoiceTypeCode = null)
    {
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get Note value
     * @return \Mnm\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\StructType\NoteType[] $note
     * @return \Mnm\StructType\InvoiceType
     */
    public function setNote(array $note = array())
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\NoteType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToNote(\Mnm\StructType\NoteType $item)
    {
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return \Mnm\StructType\DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param \Mnm\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setDocumentCurrencyCode(\Mnm\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * @return \Mnm\StructType\TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }
    /**
     * Set TaxCurrencyCode value
     * @param \Mnm\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setTaxCurrencyCode(\Mnm\StructType\TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * @return \Mnm\StructType\PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }
    /**
     * Set PricingCurrencyCode value
     * @param \Mnm\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPricingCurrencyCode(\Mnm\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return \Mnm\StructType\PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param \Mnm\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentCurrencyCode(\Mnm\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return \Mnm\StructType\PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param \Mnm\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentAlternativeCurrencyCode(\Mnm\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \Mnm\StructType\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \Mnm\StructType\AccountingCostType $accountingCost
     * @return \Mnm\StructType\InvoiceType
     */
    public function setAccountingCost(\Mnm\StructType\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get LineCountNumeric value
     * @return \Mnm\StructType\LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }
    /**
     * Set LineCountNumeric value
     * @param \Mnm\StructType\LineCountNumericType $lineCountNumeric
     * @return \Mnm\StructType\InvoiceType
     */
    public function setLineCountNumeric(\Mnm\StructType\LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * Set InvoicePeriod value
     * @param \Mnm\StructType\PeriodType $invoicePeriod
     * @return \Mnm\StructType\InvoiceType
     */
    public function setInvoicePeriod(\Mnm\StructType\PeriodType $invoicePeriod = null)
    {
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Mnm\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Mnm\StructType\OrderReferenceType $orderReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setOrderReference(\Mnm\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \Mnm\StructType\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * Set BillingReference value
     * @param \Mnm\StructType\BillingReferenceType[] $billingReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setBillingReference(array $billingReference = array())
    {
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\BillingReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToBillingReference(\Mnm\StructType\BillingReferenceType $item)
    {
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }
    /**
     * Set DespatchDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }
    /**
     * Add item to DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToDespatchDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }
    /**
     * Set ReceiptDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }
    /**
     * Add item to ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToReceiptDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }
    /**
     * Set OriginatorDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }
    /**
     * Add item to OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToOriginatorDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }
    /**
     * Set ContractDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $contractDocumentReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }
    /**
     * Add item to ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToContractDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->ContractDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Mnm\StructType\DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * Set AdditionalDocumentReference value
     * @param \Mnm\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @return \Mnm\StructType\InvoiceType
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Add item to AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DocumentReferenceType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToAdditionalDocumentReference(\Mnm\StructType\DocumentReferenceType $item)
    {
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \Mnm\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \Mnm\StructType\SignatureType[] $signature
     * @return \Mnm\StructType\InvoiceType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\SignatureType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToSignature(\Mnm\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * @return \Mnm\StructType\SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }
    /**
     * Set AccountingSupplierParty value
     * @param \Mnm\StructType\SupplierPartyType $accountingSupplierParty
     * @return \Mnm\StructType\InvoiceType
     */
    public function setAccountingSupplierParty(\Mnm\StructType\SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * @return \Mnm\StructType\CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }
    /**
     * Set AccountingCustomerParty value
     * @param \Mnm\StructType\CustomerPartyType $accountingCustomerParty
     * @return \Mnm\StructType\InvoiceType
     */
    public function setAccountingCustomerParty(\Mnm\StructType\CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \Mnm\StructType\CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \Mnm\StructType\CustomerPartyType $buyerCustomerParty
     * @return \Mnm\StructType\InvoiceType
     */
    public function setBuyerCustomerParty(\Mnm\StructType\CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \Mnm\StructType\SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \Mnm\StructType\SupplierPartyType $sellerSupplierParty
     * @return \Mnm\StructType\InvoiceType
     */
    public function setSellerSupplierParty(\Mnm\StructType\SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }
    /**
     * Set TaxRepresentativeParty value
     * @param \Mnm\StructType\PartyType $taxRepresentativeParty
     * @return \Mnm\StructType\InvoiceType
     */
    public function setTaxRepresentativeParty(\Mnm\StructType\PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\StructType\DeliveryType[] $delivery
     * @return \Mnm\StructType\InvoiceType
     */
    public function setDelivery(array $delivery = array())
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DeliveryType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToDelivery(\Mnm\StructType\DeliveryType $item)
    {
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \Mnm\StructType\PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param \Mnm\StructType\PaymentMeansType[] $paymentMeans
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Add item to PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PaymentMeansType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToPaymentMeans(\Mnm\StructType\PaymentMeansType $item)
    {
        $this->PaymentMeans[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \Mnm\StructType\PaymentTermsType|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \Mnm\StructType\PaymentTermsType $paymentTerms
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentTerms(\Mnm\StructType\PaymentTermsType $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Mnm\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * Set AllowanceCharge value
     * @param \Mnm\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \Mnm\StructType\InvoiceType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\AllowanceChargeType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToAllowanceCharge(\Mnm\StructType\AllowanceChargeType $item)
    {
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * @return \Mnm\StructType\ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }
    /**
     * Set TaxExchangeRate value
     * @param \Mnm\StructType\ExchangeRateType $taxExchangeRate
     * @return \Mnm\StructType\InvoiceType
     */
    public function setTaxExchangeRate(\Mnm\StructType\ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return \Mnm\StructType\ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param \Mnm\StructType\ExchangeRateType $pricingExchangeRate
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPricingExchangeRate(\Mnm\StructType\ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * @return \Mnm\StructType\ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }
    /**
     * Set PaymentExchangeRate value
     * @param \Mnm\StructType\ExchangeRateType $paymentExchangeRate
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentExchangeRate(\Mnm\StructType\ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * @return \Mnm\StructType\ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * @param \Mnm\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @return \Mnm\StructType\InvoiceType
     */
    public function setPaymentAlternativeExchangeRate(\Mnm\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Mnm\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \Mnm\StructType\TaxTotalType[] $taxTotal
     * @return \Mnm\StructType\InvoiceType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TaxTotalType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToTaxTotal(\Mnm\StructType\TaxTotalType $item)
    {
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Mnm\StructType\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * Set WithholdingTaxTotal value
     * @param \Mnm\StructType\TaxTotalType[] $withholdingTaxTotal
     * @return \Mnm\StructType\InvoiceType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TaxTotalType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToWithholdingTaxTotal(\Mnm\StructType\TaxTotalType $item)
    {
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * @return \Mnm\StructType\MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }
    /**
     * Set LegalMonetaryTotal value
     * @param \Mnm\StructType\MonetaryTotalType $legalMonetaryTotal
     * @return \Mnm\StructType\InvoiceType
     */
    public function setLegalMonetaryTotal(\Mnm\StructType\MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Mnm\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * Set InvoiceLine value
     * @param \Mnm\StructType\InvoiceLineType[] $invoiceLine
     * @return \Mnm\StructType\InvoiceType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\InvoiceLineType $item
     * @return \Mnm\StructType\InvoiceType
     */
    public function addToInvoiceLine(\Mnm\StructType\InvoiceLineType $item)
    {
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get schemaLocation value
     * @return string|null
     */
    public function getSchemaLocation()
    {
        return $this->schemaLocation;
    }
    /**
     * Set schemaLocation value
     * @param string $schemaLocation
     * @return \Mnm\StructType\InvoiceType
     */
    public function setSchemaLocation($schemaLocation = null)
    {
        $this->schemaLocation = $schemaLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
