<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceQueryModel StructType
 * @subpackage Structs
 */
class InvoiceQueryModel extends PagedQueryContext
{
    /**
     * The ExecutionStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionStartDate;
    /**
     * The ExecutionEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionEndDate;
    /**
     * The InvoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceIds;
    /**
     * The InvoiceNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $InvoiceNumbers;
    /**
     * Constructor method for InvoiceQueryModel
     * @uses InvoiceQueryModel::setExecutionStartDate()
     * @uses InvoiceQueryModel::setExecutionEndDate()
     * @uses InvoiceQueryModel::setInvoiceIds()
     * @uses InvoiceQueryModel::setInvoiceNumbers()
     * @param string $executionStartDate
     * @param string $executionEndDate
     * @param string[] $invoiceIds
     * @param string[] $invoiceNumbers
     */
    public function __construct($executionStartDate = null, $executionEndDate = null, array $invoiceIds = array(), array $invoiceNumbers = array())
    {
        $this
            ->setExecutionStartDate($executionStartDate)
            ->setExecutionEndDate($executionEndDate)
            ->setInvoiceIds($invoiceIds)
            ->setInvoiceNumbers($invoiceNumbers);
    }
    /**
     * Get ExecutionStartDate value
     * @return string
     */
    public function getExecutionStartDate()
    {
        return $this->ExecutionStartDate;
    }
    /**
     * Set ExecutionStartDate value
     * @param string $executionStartDate
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function setExecutionStartDate($executionStartDate = null)
    {
        $this->ExecutionStartDate = $executionStartDate;
        return $this;
    }
    /**
     * Get ExecutionEndDate value
     * @return string
     */
    public function getExecutionEndDate()
    {
        return $this->ExecutionEndDate;
    }
    /**
     * Set ExecutionEndDate value
     * @param string $executionEndDate
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function setExecutionEndDate($executionEndDate = null)
    {
        $this->ExecutionEndDate = $executionEndDate;
        return $this;
    }
    /**
     * Get InvoiceIds value
     * @return string[]|null
     */
    public function getInvoiceIds()
    {
        return $this->InvoiceIds;
    }
    /**
     * Set InvoiceIds value
     * @param string[] $invoiceIds
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function setInvoiceIds(array $invoiceIds = array())
    {
        $this->InvoiceIds = $invoiceIds;
        return $this;
    }
    /**
     * Add item to InvoiceIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function addToInvoiceIds($item)
    {
        $this->InvoiceIds[] = $item;
        return $this;
    }
    /**
     * Get InvoiceNumbers value
     * @return string[]|null
     */
    public function getInvoiceNumbers()
    {
        return $this->InvoiceNumbers;
    }
    /**
     * Set InvoiceNumbers value
     * @param string[] $invoiceNumbers
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function setInvoiceNumbers(array $invoiceNumbers = array())
    {
        $this->InvoiceNumbers = $invoiceNumbers;
        return $this;
    }
    /**
     * Add item to InvoiceNumbers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public function addToInvoiceNumbers($item)
    {
        $this->InvoiceNumbers[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceQueryModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
