<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLineType StructType
 * @subpackage Structs
 */
class InvoiceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q167:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q168:Note
     * @var \Mnm\StructType\NoteType[]
     */
    public $Note;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q169:InvoicedQuantity
     * @var \Mnm\StructType\InvoicedQuantityType
     */
    public $InvoicedQuantity;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q170:LineExtensionAmount
     * @var \Mnm\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The OrderLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\OrderLineReferenceType[]
     */
    public $OrderLineReference;
    /**
     * The DespatchLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\LineReferenceType[]
     */
    public $DespatchLineReference;
    /**
     * The ReceiptLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\LineReferenceType[]
     */
    public $ReceiptLineReference;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TaxTotalType
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ItemType
     */
    public $Item;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PriceType
     */
    public $Price;
    /**
     * The SubInvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\InvoiceLineType[]
     */
    public $SubInvoiceLine;
    /**
     * Constructor method for InvoiceLineType
     * @uses InvoiceLineType::setID()
     * @uses InvoiceLineType::setNote()
     * @uses InvoiceLineType::setInvoicedQuantity()
     * @uses InvoiceLineType::setLineExtensionAmount()
     * @uses InvoiceLineType::setOrderLineReference()
     * @uses InvoiceLineType::setDespatchLineReference()
     * @uses InvoiceLineType::setReceiptLineReference()
     * @uses InvoiceLineType::setDelivery()
     * @uses InvoiceLineType::setAllowanceCharge()
     * @uses InvoiceLineType::setTaxTotal()
     * @uses InvoiceLineType::setWithholdingTaxTotal()
     * @uses InvoiceLineType::setItem()
     * @uses InvoiceLineType::setPrice()
     * @uses InvoiceLineType::setSubInvoiceLine()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\NoteType[] $note
     * @param \Mnm\StructType\InvoicedQuantityType $invoicedQuantity
     * @param \Mnm\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \Mnm\StructType\OrderLineReferenceType[] $orderLineReference
     * @param \Mnm\StructType\LineReferenceType[] $despatchLineReference
     * @param \Mnm\StructType\LineReferenceType[] $receiptLineReference
     * @param \Mnm\StructType\DeliveryType[] $delivery
     * @param \Mnm\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \Mnm\StructType\TaxTotalType $taxTotal
     * @param \Mnm\StructType\TaxTotalType[] $withholdingTaxTotal
     * @param \Mnm\StructType\ItemType $item
     * @param \Mnm\StructType\PriceType $price
     * @param \Mnm\StructType\InvoiceLineType[] $subInvoiceLine
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, array $note = array(), \Mnm\StructType\InvoicedQuantityType $invoicedQuantity = null, \Mnm\StructType\LineExtensionAmountType $lineExtensionAmount = null, array $orderLineReference = array(), array $despatchLineReference = array(), array $receiptLineReference = array(), array $delivery = array(), array $allowanceCharge = array(), \Mnm\StructType\TaxTotalType $taxTotal = null, array $withholdingTaxTotal = array(), \Mnm\StructType\ItemType $item = null, \Mnm\StructType\PriceType $price = null, array $subInvoiceLine = array())
    {
        $this
            ->setID($iD)
            ->setNote($note)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setOrderLineReference($orderLineReference)
            ->setDespatchLineReference($despatchLineReference)
            ->setReceiptLineReference($receiptLineReference)
            ->setDelivery($delivery)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setItem($item)
            ->setPrice($price)
            ->setSubInvoiceLine($subInvoiceLine);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Note value
     * @return \Mnm\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\StructType\NoteType[] $note
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setNote(array $note = array())
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\NoteType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToNote(\Mnm\StructType\NoteType $item)
    {
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return \Mnm\StructType\InvoicedQuantityType|null
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param \Mnm\StructType\InvoicedQuantityType $invoicedQuantity
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setInvoicedQuantity(\Mnm\StructType\InvoicedQuantityType $invoicedQuantity = null)
    {
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return \Mnm\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Mnm\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setLineExtensionAmount(\Mnm\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get OrderLineReference value
     * @return \Mnm\StructType\OrderLineReferenceType[]|null
     */
    public function getOrderLineReference()
    {
        return $this->OrderLineReference;
    }
    /**
     * Set OrderLineReference value
     * @param \Mnm\StructType\OrderLineReferenceType[] $orderLineReference
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setOrderLineReference(array $orderLineReference = array())
    {
        $this->OrderLineReference = $orderLineReference;
        return $this;
    }
    /**
     * Add item to OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\OrderLineReferenceType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToOrderLineReference(\Mnm\StructType\OrderLineReferenceType $item)
    {
        $this->OrderLineReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchLineReference value
     * @return \Mnm\StructType\LineReferenceType[]|null
     */
    public function getDespatchLineReference()
    {
        return $this->DespatchLineReference;
    }
    /**
     * Set DespatchLineReference value
     * @param \Mnm\StructType\LineReferenceType[] $despatchLineReference
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setDespatchLineReference(array $despatchLineReference = array())
    {
        $this->DespatchLineReference = $despatchLineReference;
        return $this;
    }
    /**
     * Add item to DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\LineReferenceType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToDespatchLineReference(\Mnm\StructType\LineReferenceType $item)
    {
        $this->DespatchLineReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptLineReference value
     * @return \Mnm\StructType\LineReferenceType[]|null
     */
    public function getReceiptLineReference()
    {
        return $this->ReceiptLineReference;
    }
    /**
     * Set ReceiptLineReference value
     * @param \Mnm\StructType\LineReferenceType[] $receiptLineReference
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setReceiptLineReference(array $receiptLineReference = array())
    {
        $this->ReceiptLineReference = $receiptLineReference;
        return $this;
    }
    /**
     * Add item to ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\LineReferenceType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToReceiptLineReference(\Mnm\StructType\LineReferenceType $item)
    {
        $this->ReceiptLineReference[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\StructType\DeliveryType[] $delivery
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setDelivery(array $delivery = array())
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DeliveryType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToDelivery(\Mnm\StructType\DeliveryType $item)
    {
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Mnm\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * Set AllowanceCharge value
     * @param \Mnm\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\AllowanceChargeType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToAllowanceCharge(\Mnm\StructType\AllowanceChargeType $item)
    {
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Mnm\StructType\TaxTotalType|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \Mnm\StructType\TaxTotalType $taxTotal
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setTaxTotal(\Mnm\StructType\TaxTotalType $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Mnm\StructType\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * Set WithholdingTaxTotal value
     * @param \Mnm\StructType\TaxTotalType[] $withholdingTaxTotal
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\TaxTotalType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToWithholdingTaxTotal(\Mnm\StructType\TaxTotalType $item)
    {
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get Item value
     * @return \Mnm\StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Mnm\StructType\ItemType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setItem(\Mnm\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \Mnm\StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Mnm\StructType\PriceType $price
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setPrice(\Mnm\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SubInvoiceLine value
     * @return \Mnm\StructType\InvoiceLineType[]|null
     */
    public function getSubInvoiceLine()
    {
        return $this->SubInvoiceLine;
    }
    /**
     * Set SubInvoiceLine value
     * @param \Mnm\StructType\InvoiceLineType[] $subInvoiceLine
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function setSubInvoiceLine(array $subInvoiceLine = array())
    {
        $this->SubInvoiceLine = $subInvoiceLine;
        return $this;
    }
    /**
     * Add item to SubInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\InvoiceLineType $item
     * @return \Mnm\StructType\InvoiceLineType
     */
    public function addToSubInvoiceLine(\Mnm\StructType\InvoiceLineType $item)
    {
        $this->SubInvoiceLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\InvoiceLineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
