<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSummaryUsageReport StructType
 * @subpackage Structs
 */
class CustomerSummaryUsageReport extends AbstractStructBase
{
    /**
     * The Last10Days
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\Last10DaysReport
     */
    public $Last10Days;
    /**
     * The MonthlyReports
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\MonthlyReportItem[]
     */
    public $MonthlyReports;
    /**
     * Constructor method for CustomerSummaryUsageReport
     * @uses CustomerSummaryUsageReport::setLast10Days()
     * @uses CustomerSummaryUsageReport::setMonthlyReports()
     * @param \Mnm\StructType\Last10DaysReport $last10Days
     * @param \Mnm\StructType\MonthlyReportItem[] $monthlyReports
     */
    public function __construct(\Mnm\StructType\Last10DaysReport $last10Days = null, array $monthlyReports = array())
    {
        $this
            ->setLast10Days($last10Days)
            ->setMonthlyReports($monthlyReports);
    }
    /**
     * Get Last10Days value
     * @return \Mnm\StructType\Last10DaysReport|null
     */
    public function getLast10Days()
    {
        return $this->Last10Days;
    }
    /**
     * Set Last10Days value
     * @param \Mnm\StructType\Last10DaysReport $last10Days
     * @return \Mnm\StructType\CustomerSummaryUsageReport
     */
    public function setLast10Days(\Mnm\StructType\Last10DaysReport $last10Days = null)
    {
        $this->Last10Days = $last10Days;
        return $this;
    }
    /**
     * Get MonthlyReports value
     * @return \Mnm\StructType\MonthlyReportItem[]|null
     */
    public function getMonthlyReports()
    {
        return $this->MonthlyReports;
    }
    /**
     * Set MonthlyReports value
     * @param \Mnm\StructType\MonthlyReportItem[] $monthlyReports
     * @return \Mnm\StructType\CustomerSummaryUsageReport
     */
    public function setMonthlyReports(array $monthlyReports = array())
    {
        $this->MonthlyReports = $monthlyReports;
        return $this;
    }
    /**
     * Add item to MonthlyReports value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\MonthlyReportItem $item
     * @return \Mnm\StructType\CustomerSummaryUsageReport
     */
    public function addToMonthlyReports(\Mnm\StructType\MonthlyReportItem $item)
    {
        $this->MonthlyReports[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\CustomerSummaryUsageReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
