<?php

namespace Mnm;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'SignatureType' => '\\Mnm\\StructType\\SignatureType',
            'SignedInfoType' => '\\Mnm\\StructType\\SignedInfoType',
            'CanonicalizationMethodType' => '\\Mnm\\StructType\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\Mnm\\StructType\\SignatureMethodType',
            'ReferenceType' => '\\Mnm\\StructType\\ReferenceType',
            'ArrayOfTransformType' => '\\Mnm\\ArrayType\\ArrayOfTransformType',
            'TransformType' => '\\Mnm\\StructType\\TransformType',
            'DigestMethodType' => '\\Mnm\\StructType\\DigestMethodType',
            'SignatureValueType' => '\\Mnm\\StructType\\SignatureValueType',
            'KeyInfoType' => '\\Mnm\\StructType\\KeyInfoType',
            'X509DataType' => '\\Mnm\\StructType\\X509DataType',
            'X509IssuerSerialType' => '\\Mnm\\StructType\\X509IssuerSerialType',
            'RetrievalMethodType' => '\\Mnm\\StructType\\RetrievalMethodType',
            'PGPDataType' => '\\Mnm\\StructType\\PGPDataType',
            'KeyValueType' => '\\Mnm\\StructType\\KeyValueType',
            'DSAKeyValueType' => '\\Mnm\\StructType\\DSAKeyValueType',
            'RSAKeyValueType' => '\\Mnm\\StructType\\RSAKeyValueType',
            'SPKIDataType' => '\\Mnm\\StructType\\SPKIDataType',
            'ObjectType' => '\\Mnm\\StructType\\ObjectType',
            'IdentifierType' => '\\Mnm\\StructType\\IdentifierType',
            'CodeType' => '\\Mnm\\StructType\\CodeType',
            'TextType' => '\\Mnm\\StructType\\TextType',
            'NumericType' => '\\Mnm\\StructType\\NumericType',
            'MeasureType' => '\\Mnm\\StructType\\MeasureType',
            'BinaryObjectType' => '\\Mnm\\StructType\\BinaryObjectType',
            'AmountType' => '\\Mnm\\StructType\\AmountType',
            'QuantityType' => '\\Mnm\\StructType\\QuantityType',
            'IndicatorType' => '\\Mnm\\StructType\\IndicatorType',
            'DateType' => '\\Mnm\\StructType\\DateType',
            'TimeType' => '\\Mnm\\StructType\\TimeType',
            'NameType' => '\\Mnm\\StructType\\NameType',
            'ValueType' => '\\Mnm\\StructType\\ValueType',
            'RateType' => '\\Mnm\\StructType\\RateType',
            'PercentType' => '\\Mnm\\StructType\\PercentType',
            'GraphicType' => '\\Mnm\\StructType\\GraphicType',
            'PictureType' => '\\Mnm\\StructType\\PictureType',
            'SoundType' => '\\Mnm\\StructType\\SoundType',
            'VideoType' => '\\Mnm\\StructType\\VideoType',
            'ArrayOfUBLExtensionType' => '\\Mnm\\ArrayType\\ArrayOfUBLExtensionType',
            'UBLExtensionType' => '\\Mnm\\StructType\\UBLExtensionType',
            'ExtensionContentType' => '\\Mnm\\StructType\\ExtensionContentType',
            'ExtensionVersionIDType' => '\\Mnm\\StructType\\ExtensionVersionIDType',
            'ExtensionURIType' => '\\Mnm\\StructType\\ExtensionURIType',
            'ExtensionAgencyIDType' => '\\Mnm\\StructType\\ExtensionAgencyIDType',
            'ExtensionAgencyURIType' => '\\Mnm\\StructType\\ExtensionAgencyURIType',
            'ExtensionReasonCodeType' => '\\Mnm\\StructType\\ExtensionReasonCodeType',
            'ExtensionReasonType' => '\\Mnm\\StructType\\ExtensionReasonType',
            'ExtensionAgencyNameType' => '\\Mnm\\StructType\\ExtensionAgencyNameType',
            'UBLVersionIDType' => '\\Mnm\\StructType\\UBLVersionIDType',
            'SchemeURIType' => '\\Mnm\\StructType\\SchemeURIType',
            'SecurityIDType' => '\\Mnm\\StructType\\SecurityIDType',
            'SalesOrderLineIDType' => '\\Mnm\\StructType\\SalesOrderLineIDType',
            'SerialIDType' => '\\Mnm\\StructType\\SerialIDType',
            'ShippingOrderIDType' => '\\Mnm\\StructType\\ShippingOrderIDType',
            'SpecificationIDType' => '\\Mnm\\StructType\\SpecificationIDType',
            'SequenceNumberIDType' => '\\Mnm\\StructType\\SequenceNumberIDType',
            'SignatureIDType' => '\\Mnm\\StructType\\SignatureIDType',
            'SellerEventIDType' => '\\Mnm\\StructType\\SellerEventIDType',
            'SequenceIDType' => '\\Mnm\\StructType\\SequenceIDType',
            'RegistrationIDType' => '\\Mnm\\StructType\\RegistrationIDType',
            'RegistrationNationalityIDType' => '\\Mnm\\StructType\\RegistrationNationalityIDType',
            'ReferencedConsignmentIDType' => '\\Mnm\\StructType\\ReferencedConsignmentIDType',
            'RailCarIDType' => '\\Mnm\\StructType\\RailCarIDType',
            'ReferenceIDType' => '\\Mnm\\StructType\\ReferenceIDType',
            'RevisedForecastLineIDType' => '\\Mnm\\StructType\\RevisedForecastLineIDType',
            'SalesOrderIDType' => '\\Mnm\\StructType\\SalesOrderIDType',
            'RequiredCustomsIDType' => '\\Mnm\\StructType\\RequiredCustomsIDType',
            'ReleaseIDType' => '\\Mnm\\StructType\\ReleaseIDType',
            'RequestForQuotationLineIDType' => '\\Mnm\\StructType\\RequestForQuotationLineIDType',
            'VersionIDType' => '\\Mnm\\StructType\\VersionIDType',
            'VesselIDType' => '\\Mnm\\StructType\\VesselIDType',
            'VariantIDType' => '\\Mnm\\StructType\\VariantIDType',
            'UpperOrangeHazardPlacardIDType' => '\\Mnm\\StructType\\UpperOrangeHazardPlacardIDType',
            'ValidatorIDType' => '\\Mnm\\StructType\\ValidatorIDType',
            'WebsiteURIType' => '\\Mnm\\StructType\\WebsiteURIType',
            'UUIDType' => '\\Mnm\\StructType\\UUIDType',
            'TenderEnvelopeIDType' => '\\Mnm\\StructType\\TenderEnvelopeIDType',
            'TraceIDType' => '\\Mnm\\StructType\\TraceIDType',
            'SupplierAssignedAccountIDType' => '\\Mnm\\StructType\\SupplierAssignedAccountIDType',
            'SubscriberIDType' => '\\Mnm\\StructType\\SubscriberIDType',
            'SuccessiveSequenceIDType' => '\\Mnm\\StructType\\SuccessiveSequenceIDType',
            'TrackingIDType' => '\\Mnm\\StructType\\TrackingIDType',
            'URIType' => '\\Mnm\\StructType\\URIType',
            'TransportationServiceDetailsURIType' => '\\Mnm\\StructType\\TransportationServiceDetailsURIType',
            'TrainIDType' => '\\Mnm\\StructType\\TrainIDType',
            'TransportExecutionPlanReferenceIDType' => '\\Mnm\\StructType\\TransportExecutionPlanReferenceIDType',
            'RadioCallSignIDType' => '\\Mnm\\StructType\\RadioCallSignIDType',
            'ConsumptionReportIDType' => '\\Mnm\\StructType\\ConsumptionReportIDType',
            'ConsumptionIDType' => '\\Mnm\\StructType\\ConsumptionIDType',
            'ContractedCarrierAssignedIDType' => '\\Mnm\\StructType\\ContractedCarrierAssignedIDType',
            'ContractFolderIDType' => '\\Mnm\\StructType\\ContractFolderIDType',
            'ConsignorAssignedIDType' => '\\Mnm\\StructType\\ConsignorAssignedIDType',
            'ChipApplicationIDType' => '\\Mnm\\StructType\\ChipApplicationIDType',
            'CarrierAssignedIDType' => '\\Mnm\\StructType\\CarrierAssignedIDType',
            'ConsigneeAssignedIDType' => '\\Mnm\\StructType\\ConsigneeAssignedIDType',
            'CompanyIDType' => '\\Mnm\\StructType\\CompanyIDType',
            'ExtendedIDType' => '\\Mnm\\StructType\\ExtendedIDType',
            'ExchangeMarketIDType' => '\\Mnm\\StructType\\ExchangeMarketIDType',
            'HazardClassIDType' => '\\Mnm\\StructType\\HazardClassIDType',
            'FreightForwarderAssignedIDType' => '\\Mnm\\StructType\\FreightForwarderAssignedIDType',
            'EndpointIDType' => '\\Mnm\\StructType\\EndpointIDType',
            'CustomizationIDType' => '\\Mnm\\StructType\\CustomizationIDType',
            'CustomerAssignedAccountIDType' => '\\Mnm\\StructType\\CustomerAssignedAccountIDType',
            'EconomicOperatorRegistryURIType' => '\\Mnm\\StructType\\EconomicOperatorRegistryURIType',
            'DocumentIDType' => '\\Mnm\\StructType\\DocumentIDType',
            'CV2IDType' => '\\Mnm\\StructType\\CV2IDType',
            'AdditionalAccountIDType' => '\\Mnm\\StructType\\AdditionalAccountIDType',
            'AccountIDType' => '\\Mnm\\StructType\\AccountIDType',
            'AircraftIDType' => '\\Mnm\\StructType\\AircraftIDType',
            'AgencyIDType' => '\\Mnm\\StructType\\AgencyIDType',
            'BusinessIdentityEvidenceIDType' => '\\Mnm\\StructType\\BusinessIdentityEvidenceIDType',
            'BusinessClassificationEvidenceIDType' => '\\Mnm\\StructType\\BusinessClassificationEvidenceIDType',
            'BuyerProfileURIType' => '\\Mnm\\StructType\\BuyerProfileURIType',
            'BuyerEventIDType' => '\\Mnm\\StructType\\BuyerEventIDType',
            'BrokerAssignedIDType' => '\\Mnm\\StructType\\BrokerAssignedIDType',
            'AuctionURIType' => '\\Mnm\\StructType\\AuctionURIType',
            'AttributeIDType' => '\\Mnm\\StructType\\AttributeIDType',
            'BarcodeSymbologyIDType' => '\\Mnm\\StructType\\BarcodeSymbologyIDType',
            'AwardingCriterionIDType' => '\\Mnm\\StructType\\AwardingCriterionIDType',
            'IDType' => '\\Mnm\\StructType\\IDType',
            'ProfileExecutionIDType' => '\\Mnm\\StructType\\ProfileExecutionIDType',
            'ParentDocumentIDType' => '\\Mnm\\StructType\\ParentDocumentIDType',
            'PrimaryAccountNumberIDType' => '\\Mnm\\StructType\\PrimaryAccountNumberIDType',
            'ProductTraceIDType' => '\\Mnm\\StructType\\ProductTraceIDType',
            'OriginalJobIDType' => '\\Mnm\\StructType\\OriginalJobIDType',
            'OntologyURIType' => '\\Mnm\\StructType\\OntologyURIType',
            'NetworkIDType' => '\\Mnm\\StructType\\NetworkIDType',
            'OriginalContractingSystemIDType' => '\\Mnm\\StructType\\OriginalContractingSystemIDType',
            'OpenTenderIDType' => '\\Mnm\\StructType\\OpenTenderIDType',
            'ParentDocumentVersionIDType' => '\\Mnm\\StructType\\ParentDocumentVersionIDType',
            'ParentDocumentLineReferenceIDType' => '\\Mnm\\StructType\\ParentDocumentLineReferenceIDType',
            'PaymentMeansIDType' => '\\Mnm\\StructType\\PaymentMeansIDType',
            'PaymentIDType' => '\\Mnm\\StructType\\PaymentIDType',
            'PaymentTermsDetailsURIType' => '\\Mnm\\StructType\\PaymentTermsDetailsURIType',
            'PreviousJobIDType' => '\\Mnm\\StructType\\PreviousJobIDType',
            'PreviousVersionIDType' => '\\Mnm\\StructType\\PreviousVersionIDType',
            'PerformingCarrierAssignedIDType' => '\\Mnm\\StructType\\PerformingCarrierAssignedIDType',
            'PrepaidPaymentReferenceIDType' => '\\Mnm\\StructType\\PrepaidPaymentReferenceIDType',
            'NationalityIDType' => '\\Mnm\\StructType\\NationalityIDType',
            'JourneyIDType' => '\\Mnm\\StructType\\JourneyIDType',
            'IssuerIDType' => '\\Mnm\\StructType\\IssuerIDType',
            'LicensePlateIDType' => '\\Mnm\\StructType\\LicensePlateIDType',
            'LanguageIDType' => '\\Mnm\\StructType\\LanguageIDType',
            'IssueNumberIDType' => '\\Mnm\\StructType\\IssueNumberIDType',
            'ImmobilizationCertificateIDType' => '\\Mnm\\StructType\\ImmobilizationCertificateIDType',
            'IdentificationIDType' => '\\Mnm\\StructType\\IdentificationIDType',
            'InstructionIDType' => '\\Mnm\\StructType\\InstructionIDType',
            'InformationURIType' => '\\Mnm\\StructType\\InformationURIType',
            'LowerOrangeHazardPlacardIDType' => '\\Mnm\\StructType\\LowerOrangeHazardPlacardIDType',
            'LotNumberIDType' => '\\Mnm\\StructType\\LotNumberIDType',
            'MarkingIDType' => '\\Mnm\\StructType\\MarkingIDType',
            'ProfileIDType' => '\\Mnm\\StructType\\ProfileIDType',
            'LocationIDType' => '\\Mnm\\StructType\\LocationIDType',
            'LoadingSequenceIDType' => '\\Mnm\\StructType\\LoadingSequenceIDType',
            'LineIDType' => '\\Mnm\\StructType\\LineIDType',
            'LogoReferenceIDType' => '\\Mnm\\StructType\\LogoReferenceIDType',
            'CopyIndicatorType' => '\\Mnm\\StructType\\CopyIndicatorType',
            'FullyPaidSharesIndicatorType' => '\\Mnm\\StructType\\FullyPaidSharesIndicatorType',
            'FrozenDocumentIndicatorType' => '\\Mnm\\StructType\\FrozenDocumentIndicatorType',
            'GovernmentAgreementConstraintIndicatorType' => '\\Mnm\\StructType\\GovernmentAgreementConstraintIndicatorType',
            'GeneralCargoIndicatorType' => '\\Mnm\\StructType\\GeneralCargoIndicatorType',
            'FreeOfChargeIndicatorType' => '\\Mnm\\StructType\\FreeOfChargeIndicatorType',
            'CustomsImportClassifiedIndicatorType' => '\\Mnm\\StructType\\CustomsImportClassifiedIndicatorType',
            'FollowupContractIndicatorType' => '\\Mnm\\StructType\\FollowupContractIndicatorType',
            'DangerousGoodsApprovedIndicatorType' => '\\Mnm\\StructType\\DangerousGoodsApprovedIndicatorType',
            'HazardousRiskIndicatorType' => '\\Mnm\\StructType\\HazardousRiskIndicatorType',
            'MarkCareIndicatorType' => '\\Mnm\\StructType\\MarkCareIndicatorType',
            'MarkAttentionIndicatorType' => '\\Mnm\\StructType\\MarkAttentionIndicatorType',
            'OptionalLineItemIndicatorType' => '\\Mnm\\StructType\\OptionalLineItemIndicatorType',
            'OnCarriageIndicatorType' => '\\Mnm\\StructType\\OnCarriageIndicatorType',
            'LivestockIndicatorType' => '\\Mnm\\StructType\\LivestockIndicatorType',
            'HumanFoodIndicatorType' => '\\Mnm\\StructType\\HumanFoodIndicatorType',
            'HumanFoodApprovedIndicatorType' => '\\Mnm\\StructType\\HumanFoodApprovedIndicatorType',
            'LegalStatusIndicatorType' => '\\Mnm\\StructType\\LegalStatusIndicatorType',
            'IndicationIndicatorType' => '\\Mnm\\StructType\\IndicationIndicatorType',
            'ContainerizedIndicatorType' => '\\Mnm\\StructType\\ContainerizedIndicatorType',
            'AnimalFoodApprovedIndicatorType' => '\\Mnm\\StructType\\AnimalFoodApprovedIndicatorType',
            'AdValoremIndicatorType' => '\\Mnm\\StructType\\AdValoremIndicatorType',
            'AuctionConstraintIndicatorType' => '\\Mnm\\StructType\\AuctionConstraintIndicatorType',
            'AnimalFoodIndicatorType' => '\\Mnm\\StructType\\AnimalFoodIndicatorType',
            'AcceptedIndicatorType' => '\\Mnm\\StructType\\AcceptedIndicatorType',
            'BackOrderAllowedIndicatorType' => '\\Mnm\\StructType\\BackOrderAllowedIndicatorType',
            'ChargeIndicatorType' => '\\Mnm\\StructType\\ChargeIndicatorType',
            'CatalogueIndicatorType' => '\\Mnm\\StructType\\CatalogueIndicatorType',
            'ConsolidatableIndicatorType' => '\\Mnm\\StructType\\ConsolidatableIndicatorType',
            'CompletionIndicatorType' => '\\Mnm\\StructType\\CompletionIndicatorType',
            'CandidateReductionConstraintIndicatorType' => '\\Mnm\\StructType\\CandidateReductionConstraintIndicatorType',
            'BasedOnConsensusIndicatorType' => '\\Mnm\\StructType\\BasedOnConsensusIndicatorType',
            'BalanceBroughtForwardIndicatorType' => '\\Mnm\\StructType\\BalanceBroughtForwardIndicatorType',
            'BulkCargoIndicatorType' => '\\Mnm\\StructType\\BulkCargoIndicatorType',
            'BindingOnBuyerIndicatorType' => '\\Mnm\\StructType\\BindingOnBuyerIndicatorType',
            'OrderableIndicatorType' => '\\Mnm\\StructType\\OrderableIndicatorType',
            'ReturnableMaterialIndicatorType' => '\\Mnm\\StructType\\ReturnableMaterialIndicatorType',
            'SoleProprietorshipIndicatorType' => '\\Mnm\\StructType\\SoleProprietorshipIndicatorType',
            'SpecialSecurityIndicatorType' => '\\Mnm\\StructType\\SpecialSecurityIndicatorType',
            'ReturnabilityIndicatorType' => '\\Mnm\\StructType\\ReturnabilityIndicatorType',
            'RefrigeratedIndicatorType' => '\\Mnm\\StructType\\RefrigeratedIndicatorType',
            'RefrigerationOnIndicatorType' => '\\Mnm\\StructType\\RefrigerationOnIndicatorType',
            'RequiredCurriculaIndicatorType' => '\\Mnm\\StructType\\RequiredCurriculaIndicatorType',
            'SplitConsignmentIndicatorType' => '\\Mnm\\StructType\\SplitConsignmentIndicatorType',
            'ToOrderIndicatorType' => '\\Mnm\\StructType\\ToOrderIndicatorType',
            'UnknownPriceIndicatorType' => '\\Mnm\\StructType\\UnknownPriceIndicatorType',
            'VariantConstraintIndicatorType' => '\\Mnm\\StructType\\VariantConstraintIndicatorType',
            'ThirdPartyPayerIndicatorType' => '\\Mnm\\StructType\\ThirdPartyPayerIndicatorType',
            'StatusAvailableIndicatorType' => '\\Mnm\\StructType\\StatusAvailableIndicatorType',
            'TaxEvidenceIndicatorType' => '\\Mnm\\StructType\\TaxEvidenceIndicatorType',
            'TaxIncludedIndicatorType' => '\\Mnm\\StructType\\TaxIncludedIndicatorType',
            'PublishAwardIndicatorType' => '\\Mnm\\StructType\\PublishAwardIndicatorType',
            'PowerIndicatorType' => '\\Mnm\\StructType\\PowerIndicatorType',
            'PreCarriageIndicatorType' => '\\Mnm\\StructType\\PreCarriageIndicatorType',
            'ItemUpdateRequestIndicatorType' => '\\Mnm\\StructType\\ItemUpdateRequestIndicatorType',
            'PartialDeliveryIndicatorType' => '\\Mnm\\StructType\\PartialDeliveryIndicatorType',
            'PricingUpdateRequestIndicatorType' => '\\Mnm\\StructType\\PricingUpdateRequestIndicatorType',
            'PrizeIndicatorType' => '\\Mnm\\StructType\\PrizeIndicatorType',
            'PrepaidIndicatorType' => '\\Mnm\\StructType\\PrepaidIndicatorType',
            'OtherConditionsIndicatorType' => '\\Mnm\\StructType\\OtherConditionsIndicatorType',
            'IssueDateType' => '\\Mnm\\StructType\\IssueDateType',
            'LastRevisionDateType' => '\\Mnm\\StructType\\LastRevisionDateType',
            'LatestDeliveryDateType' => '\\Mnm\\StructType\\LatestDeliveryDateType',
            'GuaranteedDespatchDateType' => '\\Mnm\\StructType\\GuaranteedDespatchDateType',
            'InstallmentDueDateType' => '\\Mnm\\StructType\\InstallmentDueDateType',
            'LatestProposalAcceptanceDateType' => '\\Mnm\\StructType\\LatestProposalAcceptanceDateType',
            'LatestSecurityClearanceDateType' => '\\Mnm\\StructType\\LatestSecurityClearanceDateType',
            'LatestPickupDateType' => '\\Mnm\\StructType\\LatestPickupDateType',
            'LatestMeterReadingDateType' => '\\Mnm\\StructType\\LatestMeterReadingDateType',
            'EarliestPickupDateType' => '\\Mnm\\StructType\\EarliestPickupDateType',
            'EffectiveDateType' => '\\Mnm\\StructType\\EffectiveDateType',
            'DueDateType' => '\\Mnm\\StructType\\DueDateType',
            'ComparisonForecastIssueDateType' => '\\Mnm\\StructType\\ComparisonForecastIssueDateType',
            'ExpiryDateType' => '\\Mnm\\StructType\\ExpiryDateType',
            'FirstShipmentAvailibilityDateType' => '\\Mnm\\StructType\\FirstShipmentAvailibilityDateType',
            'EstimatedDespatchDateType' => '\\Mnm\\StructType\\EstimatedDespatchDateType',
            'EndDateType' => '\\Mnm\\StructType\\EndDateType',
            'EstimatedDeliveryDateType' => '\\Mnm\\StructType\\EstimatedDeliveryDateType',
            'ManufactureDateType' => '\\Mnm\\StructType\\ManufactureDateType',
            'RegistrationExpirationDateType' => '\\Mnm\\StructType\\RegistrationExpirationDateType',
            'RequestedDeliveryDateType' => '\\Mnm\\StructType\\RequestedDeliveryDateType',
            'RegistrationDateType' => '\\Mnm\\StructType\\RegistrationDateType',
            'RegisteredDateType' => '\\Mnm\\StructType\\RegisteredDateType',
            'ResolutionDateType' => '\\Mnm\\StructType\\ResolutionDateType',
            'ResponseDateType' => '\\Mnm\\StructType\\ResponseDateType',
            'RequiredDeliveryDateType' => '\\Mnm\\StructType\\RequiredDeliveryDateType',
            'RequestedDespatchDateType' => '\\Mnm\\StructType\\RequestedDespatchDateType',
            'RequestedPublicationDateType' => '\\Mnm\\StructType\\RequestedPublicationDateType',
            'PaymentDueDateType' => '\\Mnm\\StructType\\PaymentDueDateType',
            'PlannedDateType' => '\\Mnm\\StructType\\PlannedDateType',
            'PaidDateType' => '\\Mnm\\StructType\\PaidDateType',
            'NominationDateType' => '\\Mnm\\StructType\\NominationDateType',
            'OccurrenceDateType' => '\\Mnm\\StructType\\OccurrenceDateType',
            'ReferenceDateType' => '\\Mnm\\StructType\\ReferenceDateType',
            'PreviousMeterReadingDateType' => '\\Mnm\\StructType\\PreviousMeterReadingDateType',
            'ReceivedDateType' => '\\Mnm\\StructType\\ReceivedDateType',
            'CallDateType' => '\\Mnm\\StructType\\CallDateType',
            'AvailabilityDateType' => '\\Mnm\\StructType\\AvailabilityDateType',
            'ApprovalDateType' => '\\Mnm\\StructType\\ApprovalDateType',
            'ValidityStartDateType' => '\\Mnm\\StructType\\ValidityStartDateType',
            'AwardDateType' => '\\Mnm\\StructType\\AwardDateType',
            'BestBeforeDateType' => '\\Mnm\\StructType\\BestBeforeDateType',
            'ActualDeliveryDateType' => '\\Mnm\\StructType\\ActualDeliveryDateType',
            'ActualPickupDateType' => '\\Mnm\\StructType\\ActualPickupDateType',
            'ActualDespatchDateType' => '\\Mnm\\StructType\\ActualDespatchDateType',
            'StartDateType' => '\\Mnm\\StructType\\StartDateType',
            'SubmissionDateType' => '\\Mnm\\StructType\\SubmissionDateType',
            'SubmissionDueDateType' => '\\Mnm\\StructType\\SubmissionDueDateType',
            'BirthDateType' => '\\Mnm\\StructType\\BirthDateType',
            'RevisionDateType' => '\\Mnm\\StructType\\RevisionDateType',
            'SourceForecastIssueDateType' => '\\Mnm\\StructType\\SourceForecastIssueDateType',
            'TaxPointDateType' => '\\Mnm\\StructType\\TaxPointDateType',
            'ValidationDateType' => '\\Mnm\\StructType\\ValidationDateType',
            'IssueTimeType' => '\\Mnm\\StructType\\IssueTimeType',
            'PaidTimeType' => '\\Mnm\\StructType\\PaidTimeType',
            'OccurrenceTimeType' => '\\Mnm\\StructType\\OccurrenceTimeType',
            'RegisteredTimeType' => '\\Mnm\\StructType\\RegisteredTimeType',
            'ReferenceTimeType' => '\\Mnm\\StructType\\ReferenceTimeType',
            'LatestPickupTimeType' => '\\Mnm\\StructType\\LatestPickupTimeType',
            'LatestDeliveryTimeType' => '\\Mnm\\StructType\\LatestDeliveryTimeType',
            'NominationTimeType' => '\\Mnm\\StructType\\NominationTimeType',
            'ManufactureTimeType' => '\\Mnm\\StructType\\ManufactureTimeType',
            'RequestedDespatchTimeType' => '\\Mnm\\StructType\\RequestedDespatchTimeType',
            'StartTimeType' => '\\Mnm\\StructType\\StartTimeType',
            'SourceForecastIssueTimeType' => '\\Mnm\\StructType\\SourceForecastIssueTimeType',
            'ActualDeliveryTimeType' => '\\Mnm\\StructType\\ActualDeliveryTimeType',
            'ValidationTimeType' => '\\Mnm\\StructType\\ValidationTimeType',
            'ResolutionTimeType' => '\\Mnm\\StructType\\ResolutionTimeType',
            'RequiredDeliveryTimeType' => '\\Mnm\\StructType\\RequiredDeliveryTimeType',
            'RevisionTimeType' => '\\Mnm\\StructType\\RevisionTimeType',
            'ResponseTimeType' => '\\Mnm\\StructType\\ResponseTimeType',
            'LastRevisionTimeType' => '\\Mnm\\StructType\\LastRevisionTimeType',
            'ActualDespatchTimeType' => '\\Mnm\\StructType\\ActualDespatchTimeType',
            'CallTimeType' => '\\Mnm\\StructType\\CallTimeType',
            'AwardTimeType' => '\\Mnm\\StructType\\AwardTimeType',
            'ActualPickupTimeType' => '\\Mnm\\StructType\\ActualPickupTimeType',
            'ComparisonForecastIssueTimeType' => '\\Mnm\\StructType\\ComparisonForecastIssueTimeType',
            'ExpiryTimeType' => '\\Mnm\\StructType\\ExpiryTimeType',
            'EstimatedDespatchTimeType' => '\\Mnm\\StructType\\EstimatedDespatchTimeType',
            'GuaranteedDespatchTimeType' => '\\Mnm\\StructType\\GuaranteedDespatchTimeType',
            'EffectiveTimeType' => '\\Mnm\\StructType\\EffectiveTimeType',
            'EarliestPickupTimeType' => '\\Mnm\\StructType\\EarliestPickupTimeType',
            'EstimatedDeliveryTimeType' => '\\Mnm\\StructType\\EstimatedDeliveryTimeType',
            'EndTimeType' => '\\Mnm\\StructType\\EndTimeType',
            'InvoiceTypeCodeType' => '\\Mnm\\StructType\\InvoiceTypeCodeType',
            'PositionCodeType' => '\\Mnm\\StructType\\PositionCodeType',
            'PerformanceMetricTypeCodeType' => '\\Mnm\\StructType\\PerformanceMetricTypeCodeType',
            'PaymentAlternativeCurrencyCodeType' => '\\Mnm\\StructType\\PaymentAlternativeCurrencyCodeType',
            'PaymentChannelCodeType' => '\\Mnm\\StructType\\PaymentChannelCodeType',
            'PartPresentationCodeType' => '\\Mnm\\StructType\\PartPresentationCodeType',
            'PartyTypeCodeType' => '\\Mnm\\StructType\\PartyTypeCodeType',
            'PaymentMeansCodeType' => '\\Mnm\\StructType\\PaymentMeansCodeType',
            'PaymentPurposeCodeType' => '\\Mnm\\StructType\\PaymentPurposeCodeType',
            'PaymentCurrencyCodeType' => '\\Mnm\\StructType\\PaymentCurrencyCodeType',
            'PaymentFrequencyCodeType' => '\\Mnm\\StructType\\PaymentFrequencyCodeType',
            'ContractingSystemCodeType' => '\\Mnm\\StructType\\ContractingSystemCodeType',
            'ContractTypeCodeType' => '\\Mnm\\StructType\\ContractTypeCodeType',
            'ConsumptionTypeCodeType' => '\\Mnm\\StructType\\ConsumptionTypeCodeType',
            'CoordinateSystemCodeType' => '\\Mnm\\StructType\\CoordinateSystemCodeType',
            'CountrySubentityCodeType' => '\\Mnm\\StructType\\CountrySubentityCodeType',
            'CorrectionTypeCodeType' => '\\Mnm\\StructType\\CorrectionTypeCodeType',
            'CorporateRegistrationTypeCodeType' => '\\Mnm\\StructType\\CorporateRegistrationTypeCodeType',
            'ConsumptionLevelCodeType' => '\\Mnm\\StructType\\ConsumptionLevelCodeType',
            'ComparisonDataSourceCodeType' => '\\Mnm\\StructType\\ComparisonDataSourceCodeType',
            'ComparisonDataCodeType' => '\\Mnm\\StructType\\ComparisonDataCodeType',
            'CompanyLiquidationStatusCodeType' => '\\Mnm\\StructType\\CompanyLiquidationStatusCodeType',
            'ConditionCodeType' => '\\Mnm\\StructType\\ConditionCodeType',
            'ConsumersEnergyLevelCodeType' => '\\Mnm\\StructType\\ConsumersEnergyLevelCodeType',
            'ConsumerIncentiveTacticTypeCodeType' => '\\Mnm\\StructType\\ConsumerIncentiveTacticTypeCodeType',
            'ConstitutionCodeType' => '\\Mnm\\StructType\\ConstitutionCodeType',
            'DispositionCodeType' => '\\Mnm\\StructType\\DispositionCodeType',
            'DisplayTacticTypeCodeType' => '\\Mnm\\StructType\\DisplayTacticTypeCodeType',
            'DirectionCodeType' => '\\Mnm\\StructType\\DirectionCodeType',
            'DocumentCurrencyCodeType' => '\\Mnm\\StructType\\DocumentCurrencyCodeType',
            'DocumentTypeCodeType' => '\\Mnm\\StructType\\DocumentTypeCodeType',
            'DocumentStatusReasonCodeType' => '\\Mnm\\StructType\\DocumentStatusReasonCodeType',
            'DocumentStatusCodeType' => '\\Mnm\\StructType\\DocumentStatusCodeType',
            'DespatchAdviceTypeCodeType' => '\\Mnm\\StructType\\DespatchAdviceTypeCodeType',
            'CurrentChargeTypeCodeType' => '\\Mnm\\StructType\\CurrentChargeTypeCodeType',
            'CurrencyCodeType' => '\\Mnm\\StructType\\CurrencyCodeType',
            'CreditNoteTypeCodeType' => '\\Mnm\\StructType\\CreditNoteTypeCodeType',
            'CustomsStatusCodeType' => '\\Mnm\\StructType\\CustomsStatusCodeType',
            'DescriptionCodeType' => '\\Mnm\\StructType\\DescriptionCodeType',
            'DeclarationTypeCodeType' => '\\Mnm\\StructType\\DeclarationTypeCodeType',
            'DataSourceCodeType' => '\\Mnm\\StructType\\DataSourceCodeType',
            'AddressTypeCodeType' => '\\Mnm\\StructType\\AddressTypeCodeType',
            'AddressFormatCodeType' => '\\Mnm\\StructType\\AddressFormatCodeType',
            'ActivityTypeCodeType' => '\\Mnm\\StructType\\ActivityTypeCodeType',
            'AdjustmentReasonCodeType' => '\\Mnm\\StructType\\AdjustmentReasonCodeType',
            'ApplicationStatusCodeType' => '\\Mnm\\StructType\\ApplicationStatusCodeType',
            'AllowanceChargeReasonCodeType' => '\\Mnm\\StructType\\AllowanceChargeReasonCodeType',
            'AdmissionCodeType' => '\\Mnm\\StructType\\AdmissionCodeType',
            'ActionCodeType' => '\\Mnm\\StructType\\ActionCodeType',
            'AccountingCostCodeType' => '\\Mnm\\StructType\\AccountingCostCodeType',
            'AccountTypeCodeType' => '\\Mnm\\StructType\\AccountTypeCodeType',
            'AccountFormatCodeType' => '\\Mnm\\StructType\\AccountFormatCodeType',
            'ChannelCodeType' => '\\Mnm\\StructType\\ChannelCodeType',
            'CertificateTypeCodeType' => '\\Mnm\\StructType\\CertificateTypeCodeType',
            'CargoTypeCodeType' => '\\Mnm\\StructType\\CargoTypeCodeType',
            'CharacterSetCodeType' => '\\Mnm\\StructType\\CharacterSetCodeType',
            'CompanyLegalFormCodeType' => '\\Mnm\\StructType\\CompanyLegalFormCodeType',
            'CommodityCodeType' => '\\Mnm\\StructType\\CommodityCodeType',
            'CollaborationPriorityCodeType' => '\\Mnm\\StructType\\CollaborationPriorityCodeType',
            'CardTypeCodeType' => '\\Mnm\\StructType\\CardTypeCodeType',
            'AwardingMethodTypeCodeType' => '\\Mnm\\StructType\\AwardingMethodTypeCodeType',
            'AwardingCriterionTypeCodeType' => '\\Mnm\\StructType\\AwardingCriterionTypeCodeType',
            'AvailabilityStatusCodeType' => '\\Mnm\\StructType\\AvailabilityStatusCodeType',
            'CalculationExpressionCodeType' => '\\Mnm\\StructType\\CalculationExpressionCodeType',
            'CardChipCodeType' => '\\Mnm\\StructType\\CardChipCodeType',
            'CapabilityTypeCodeType' => '\\Mnm\\StructType\\CapabilityTypeCodeType',
            'CalculationMethodCodeType' => '\\Mnm\\StructType\\CalculationMethodCodeType',
            'LossRiskResponsibilityCodeType' => '\\Mnm\\StructType\\LossRiskResponsibilityCodeType',
            'LongitudeDirectionCodeType' => '\\Mnm\\StructType\\LongitudeDirectionCodeType',
            'LocationTypeCodeType' => '\\Mnm\\StructType\\LocationTypeCodeType',
            'MandateTypeCodeType' => '\\Mnm\\StructType\\MandateTypeCodeType',
            'MeterConstantCodeType' => '\\Mnm\\StructType\\MeterConstantCodeType',
            'MedicalFirstAidGuideCodeType' => '\\Mnm\\StructType\\MedicalFirstAidGuideCodeType',
            'MathematicOperatorCodeType' => '\\Mnm\\StructType\\MathematicOperatorCodeType',
            'LocaleCodeType' => '\\Mnm\\StructType\\LocaleCodeType',
            'ItemClassificationCodeType' => '\\Mnm\\StructType\\ItemClassificationCodeType',
            'InspectionMethodCodeType' => '\\Mnm\\StructType\\InspectionMethodCodeType',
            'LatestMeterReadingMethodCodeType' => '\\Mnm\\StructType\\LatestMeterReadingMethodCodeType',
            'LineStatusCodeType' => '\\Mnm\\StructType\\LineStatusCodeType',
            'LifeCycleStatusCodeType' => '\\Mnm\\StructType\\LifeCycleStatusCodeType',
            'LatitudeDirectionCodeType' => '\\Mnm\\StructType\\LatitudeDirectionCodeType',
            'PackLevelCodeType' => '\\Mnm\\StructType\\PackLevelCodeType',
            'OwnerTypeCodeType' => '\\Mnm\\StructType\\OwnerTypeCodeType',
            'OrderTypeCodeType' => '\\Mnm\\StructType\\OrderTypeCodeType',
            'PackageLevelCodeType' => '\\Mnm\\StructType\\PackageLevelCodeType',
            'ParentDocumentTypeCodeType' => '\\Mnm\\StructType\\ParentDocumentTypeCodeType',
            'PackingCriteriaCodeType' => '\\Mnm\\StructType\\PackingCriteriaCodeType',
            'PackagingTypeCodeType' => '\\Mnm\\StructType\\PackagingTypeCodeType',
            'OrderResponseCodeType' => '\\Mnm\\StructType\\OrderResponseCodeType',
            'MiscellaneousEventTypeCodeType' => '\\Mnm\\StructType\\MiscellaneousEventTypeCodeType',
            'MimeCodeType' => '\\Mnm\\StructType\\MimeCodeType',
            'MeterReadingTypeCodeType' => '\\Mnm\\StructType\\MeterReadingTypeCodeType',
            'NameCodeType' => '\\Mnm\\StructType\\NameCodeType',
            'OneTimeChargeTypeCodeType' => '\\Mnm\\StructType\\OneTimeChargeTypeCodeType',
            'NotificationTypeCodeType' => '\\Mnm\\StructType\\NotificationTypeCodeType',
            'NatureCodeType' => '\\Mnm\\StructType\\NatureCodeType',
            'ExpenseCodeType' => '\\Mnm\\StructType\\ExpenseCodeType',
            'ExemptionReasonCodeType' => '\\Mnm\\StructType\\ExemptionReasonCodeType',
            'ExecutionRequirementCodeType' => '\\Mnm\\StructType\\ExecutionRequirementCodeType',
            'ExpressionCodeType' => '\\Mnm\\StructType\\ExpressionCodeType',
            'ForecastPurposeCodeType' => '\\Mnm\\StructType\\ForecastPurposeCodeType',
            'FinancingInstrumentCodeType' => '\\Mnm\\StructType\\FinancingInstrumentCodeType',
            'FeatureTacticTypeCodeType' => '\\Mnm\\StructType\\FeatureTacticTypeCodeType',
            'ExceptionStatusCodeType' => '\\Mnm\\StructType\\ExceptionStatusCodeType',
            'EncodingCodeType' => '\\Mnm\\StructType\\EncodingCodeType',
            'EmergencyProceduresCodeType' => '\\Mnm\\StructType\\EmergencyProceduresCodeType',
            'DutyCodeType' => '\\Mnm\\StructType\\DutyCodeType',
            'EnvironmentalEmissionTypeCodeType' => '\\Mnm\\StructType\\EnvironmentalEmissionTypeCodeType',
            'ExceptionResolutionCodeType' => '\\Mnm\\StructType\\ExceptionResolutionCodeType',
            'EvidenceTypeCodeType' => '\\Mnm\\StructType\\EvidenceTypeCodeType',
            'EvaluationCriterionTypeCodeType' => '\\Mnm\\StructType\\EvaluationCriterionTypeCodeType',
            'HeatingTypeCodeType' => '\\Mnm\\StructType\\HeatingTypeCodeType',
            'HazardousRegulationCodeType' => '\\Mnm\\StructType\\HazardousRegulationCodeType',
            'HazardousCategoryCodeType' => '\\Mnm\\StructType\\HazardousCategoryCodeType',
            'IdentificationCodeType' => '\\Mnm\\StructType\\IdentificationCodeType',
            'InhalationToxicityZoneCodeType' => '\\Mnm\\StructType\\InhalationToxicityZoneCodeType',
            'IndustryClassificationCodeType' => '\\Mnm\\StructType\\IndustryClassificationCodeType',
            'ImportanceCodeType' => '\\Mnm\\StructType\\ImportanceCodeType',
            'HandlingCodeType' => '\\Mnm\\StructType\\HandlingCodeType',
            'FreightRateClassCodeType' => '\\Mnm\\StructType\\FreightRateClassCodeType',
            'FormatCodeType' => '\\Mnm\\StructType\\FormatCodeType',
            'ForecastTypeCodeType' => '\\Mnm\\StructType\\ForecastTypeCodeType',
            'FullnessIndicationCodeType' => '\\Mnm\\StructType\\FullnessIndicationCodeType',
            'GuaranteeTypeCodeType' => '\\Mnm\\StructType\\GuaranteeTypeCodeType',
            'GenderCodeType' => '\\Mnm\\StructType\\GenderCodeType',
            'FundingProgramCodeType' => '\\Mnm\\StructType\\FundingProgramCodeType',
            'ValidationResultCodeType' => '\\Mnm\\StructType\\ValidationResultCodeType',
            'TaxTypeCodeType' => '\\Mnm\\StructType\\TaxTypeCodeType',
            'WeekDayCodeType' => '\\Mnm\\StructType\\WeekDayCodeType',
            'WorkPhaseCodeType' => '\\Mnm\\StructType\\WorkPhaseCodeType',
            'WeightingAlgorithmCodeType' => '\\Mnm\\StructType\\WeightingAlgorithmCodeType',
            'TelecommunicationsServiceCallCodeType' => '\\Mnm\\StructType\\TelecommunicationsServiceCallCodeType',
            'TenderEnvelopeTypeCodeType' => '\\Mnm\\StructType\\TenderEnvelopeTypeCodeType',
            'TenderResultCodeType' => '\\Mnm\\StructType\\TenderResultCodeType',
            'TelecommunicationsSupplyTypeCodeType' => '\\Mnm\\StructType\\TelecommunicationsSupplyTypeCodeType',
            'UtilityStatementTypeCodeType' => '\\Mnm\\StructType\\UtilityStatementTypeCodeType',
            'TelecommunicationsServiceCategoryCodeType' => '\\Mnm\\StructType\\TelecommunicationsServiceCategoryCodeType',
            'TargetCurrencyCodeType' => '\\Mnm\\StructType\\TargetCurrencyCodeType',
            'TariffClassCodeType' => '\\Mnm\\StructType\\TariffClassCodeType',
            'SupplyChainActivityTypeCodeType' => '\\Mnm\\StructType\\SupplyChainActivityTypeCodeType',
            'SubscriberTypeCodeType' => '\\Mnm\\StructType\\SubscriberTypeCodeType',
            'SubstitutionStatusCodeType' => '\\Mnm\\StructType\\SubstitutionStatusCodeType',
            'TariffCodeType' => '\\Mnm\\StructType\\TariffCodeType',
            'TaxLevelCodeType' => '\\Mnm\\StructType\\TaxLevelCodeType',
            'TaxCurrencyCodeType' => '\\Mnm\\StructType\\TaxCurrencyCodeType',
            'TaxExemptionReasonCodeType' => '\\Mnm\\StructType\\TaxExemptionReasonCodeType',
            'TransportEventTypeCodeType' => '\\Mnm\\StructType\\TransportEventTypeCodeType',
            'TransportExecutionStatusCodeType' => '\\Mnm\\StructType\\TransportExecutionStatusCodeType',
            'TransportEquipmentTypeCodeType' => '\\Mnm\\StructType\\TransportEquipmentTypeCodeType',
            'TransportAuthorizationCodeType' => '\\Mnm\\StructType\\TransportAuthorizationCodeType',
            'TransportEmergencyCardCodeType' => '\\Mnm\\StructType\\TransportEmergencyCardCodeType',
            'TransportHandlingUnitTypeCodeType' => '\\Mnm\\StructType\\TransportHandlingUnitTypeCodeType',
            'TransportationStatusTypeCodeType' => '\\Mnm\\StructType\\TransportationStatusTypeCodeType',
            'TypeCodeType' => '\\Mnm\\StructType\\TypeCodeType',
            'TransportServiceCodeType' => '\\Mnm\\StructType\\TransportServiceCodeType',
            'TransportMeansTypeCodeType' => '\\Mnm\\StructType\\TransportMeansTypeCodeType',
            'TransportModeCodeType' => '\\Mnm\\StructType\\TransportModeCodeType',
            'TendererRoleCodeType' => '\\Mnm\\StructType\\TendererRoleCodeType',
            'ThresholdValueComparisonCodeType' => '\\Mnm\\StructType\\ThresholdValueComparisonCodeType',
            'UrgencyCodeType' => '\\Mnm\\StructType\\UrgencyCodeType',
            'TenderTypeCodeType' => '\\Mnm\\StructType\\TenderTypeCodeType',
            'TendererRequirementTypeCodeType' => '\\Mnm\\StructType\\TendererRequirementTypeCodeType',
            'UNDGCodeType' => '\\Mnm\\StructType\\UNDGCodeType',
            'TradeServiceCodeType' => '\\Mnm\\StructType\\TradeServiceCodeType',
            'TransitDirectionCodeType' => '\\Mnm\\StructType\\TransitDirectionCodeType',
            'TradeItemPackingLabelingTypeCodeType' => '\\Mnm\\StructType\\TradeItemPackingLabelingTypeCodeType',
            'TimingComplaintCodeType' => '\\Mnm\\StructType\\TimingComplaintCodeType',
            'TrackingDeviceCodeType' => '\\Mnm\\StructType\\TrackingDeviceCodeType',
            'SubmissionMethodCodeType' => '\\Mnm\\StructType\\SubmissionMethodCodeType',
            'ProviderTypeCodeType' => '\\Mnm\\StructType\\ProviderTypeCodeType',
            'PurposeCodeType' => '\\Mnm\\StructType\\PurposeCodeType',
            'PromotionalEventTypeCodeType' => '\\Mnm\\StructType\\PromotionalEventTypeCodeType',
            'ProcurementTypeCodeType' => '\\Mnm\\StructType\\ProcurementTypeCodeType',
            'ProfileStatusCodeType' => '\\Mnm\\StructType\\ProfileStatusCodeType',
            'QualityControlCodeType' => '\\Mnm\\StructType\\QualityControlCodeType',
            'RejectActionCodeType' => '\\Mnm\\StructType\\RejectActionCodeType',
            'RejectReasonCodeType' => '\\Mnm\\StructType\\RejectReasonCodeType',
            'ReferenceEventCodeType' => '\\Mnm\\StructType\\ReferenceEventCodeType',
            'QuantityDiscrepancyCodeType' => '\\Mnm\\StructType\\QuantityDiscrepancyCodeType',
            'ReceiptAdviceTypeCodeType' => '\\Mnm\\StructType\\ReceiptAdviceTypeCodeType',
            'PreviousMeterReadingMethodCodeType' => '\\Mnm\\StructType\\PreviousMeterReadingMethodCodeType',
            'PriceEvaluationCodeType' => '\\Mnm\\StructType\\PriceEvaluationCodeType',
            'PreviousCancellationReasonCodeType' => '\\Mnm\\StructType\\PreviousCancellationReasonCodeType',
            'TimeFrequencyCodeType' => '\\Mnm\\StructType\\TimeFrequencyCodeType',
            'PreferenceCriterionCodeType' => '\\Mnm\\StructType\\PreferenceCriterionCodeType',
            'PriceTypeCodeType' => '\\Mnm\\StructType\\PriceTypeCodeType',
            'ProcessReasonCodeType' => '\\Mnm\\StructType\\ProcessReasonCodeType',
            'ProcurementSubTypeCodeType' => '\\Mnm\\StructType\\ProcurementSubTypeCodeType',
            'ProcedureCodeType' => '\\Mnm\\StructType\\ProcedureCodeType',
            'PricingCurrencyCodeType' => '\\Mnm\\StructType\\PricingCurrencyCodeType',
            'PrivacyCodeType' => '\\Mnm\\StructType\\PrivacyCodeType',
            'ShortageActionCodeType' => '\\Mnm\\StructType\\ShortageActionCodeType',
            'SizeTypeCodeType' => '\\Mnm\\StructType\\SizeTypeCodeType',
            'ShippingPriorityLevelCodeType' => '\\Mnm\\StructType\\ShippingPriorityLevelCodeType',
            'ServiceInformationPreferenceCodeType' => '\\Mnm\\StructType\\ServiceInformationPreferenceCodeType',
            'ServiceTypeCodeType' => '\\Mnm\\StructType\\ServiceTypeCodeType',
            'SourceCurrencyCodeType' => '\\Mnm\\StructType\\SourceCurrencyCodeType',
            'StatusReasonCodeType' => '\\Mnm\\StructType\\StatusReasonCodeType',
            'SubcontractingConditionsCodeType' => '\\Mnm\\StructType\\SubcontractingConditionsCodeType',
            'StatusCodeType' => '\\Mnm\\StructType\\StatusCodeType',
            'SpecificationTypeCodeType' => '\\Mnm\\StructType\\SpecificationTypeCodeType',
            'StatementTypeCodeType' => '\\Mnm\\StructType\\StatementTypeCodeType',
            'ResolutionCodeType' => '\\Mnm\\StructType\\ResolutionCodeType',
            'ResponseCodeType' => '\\Mnm\\StructType\\ResponseCodeType',
            'ResidenceTypeCodeType' => '\\Mnm\\StructType\\ResidenceTypeCodeType',
            'ReminderTypeCodeType' => '\\Mnm\\StructType\\ReminderTypeCodeType',
            'RequestedInvoiceCurrencyCodeType' => '\\Mnm\\StructType\\RequestedInvoiceCurrencyCodeType',
            'RetailEventStatusCodeType' => '\\Mnm\\StructType\\RetailEventStatusCodeType',
            'SealStatusCodeType' => '\\Mnm\\StructType\\SealStatusCodeType',
            'SecurityClassificationCodeType' => '\\Mnm\\StructType\\SecurityClassificationCodeType',
            'SealIssuerTypeCodeType' => '\\Mnm\\StructType\\SealIssuerTypeCodeType',
            'RevisionStatusCodeType' => '\\Mnm\\StructType\\RevisionStatusCodeType',
            'RoleCodeType' => '\\Mnm\\StructType\\RoleCodeType',
            'NoteType' => '\\Mnm\\StructType\\NoteType',
            'OtherNameType' => '\\Mnm\\StructType\\OtherNameType',
            'RegistrationNameType' => '\\Mnm\\StructType\\RegistrationNameType',
            'HolderNameType' => '\\Mnm\\StructType\\HolderNameType',
            'MiddleNameType' => '\\Mnm\\StructType\\MiddleNameType',
            'ModelNameType' => '\\Mnm\\StructType\\ModelNameType',
            'StreetNameType' => '\\Mnm\\StructType\\StreetNameType',
            'TechnicalNameType' => '\\Mnm\\StructType\\TechnicalNameType',
            'VesselNameType' => '\\Mnm\\StructType\\VesselNameType',
            'RetailEventNameType' => '\\Mnm\\StructType\\RetailEventNameType',
            'RoamingPartnerNameType' => '\\Mnm\\StructType\\RoamingPartnerNameType',
            'ServiceNameType' => '\\Mnm\\StructType\\ServiceNameType',
            'AdditionalStreetNameType' => '\\Mnm\\StructType\\AdditionalStreetNameType',
            'AliasNameType' => '\\Mnm\\StructType\\AliasNameType',
            'BlockNameType' => '\\Mnm\\StructType\\BlockNameType',
            'BrandNameType' => '\\Mnm\\StructType\\BrandNameType',
            'FamilyNameType' => '\\Mnm\\StructType\\FamilyNameType',
            'FileNameType' => '\\Mnm\\StructType\\FileNameType',
            'FirstNameType' => '\\Mnm\\StructType\\FirstNameType',
            'CitySubdivisionNameType' => '\\Mnm\\StructType\\CitySubdivisionNameType',
            'CategoryNameType' => '\\Mnm\\StructType\\CategoryNameType',
            'BuildingNameType' => '\\Mnm\\StructType\\BuildingNameType',
            'CityNameType' => '\\Mnm\\StructType\\CityNameType',
            'RoomType' => '\\Mnm\\StructType\\RoomType',
            'RoleDescriptionType' => '\\Mnm\\StructType\\RoleDescriptionType',
            'ResolutionType' => '\\Mnm\\StructType\\ResolutionType',
            'ServiceTypeType' => '\\Mnm\\StructType\\ServiceTypeType',
            'ServiceNumberCalledType' => '\\Mnm\\StructType\\ServiceNumberCalledType',
            'SealingPartyTypeType' => '\\Mnm\\StructType\\SealingPartyTypeType',
            'ResidenceTypeType' => '\\Mnm\\StructType\\ResidenceTypeType',
            'RejectReasonType' => '\\Mnm\\StructType\\RejectReasonType',
            'RegulatoryDomainType' => '\\Mnm\\StructType\\RegulatoryDomainType',
            'RegistrationNationalityType' => '\\Mnm\\StructType\\RegistrationNationalityType',
            'ReplenishmentOwnerDescriptionType' => '\\Mnm\\StructType\\ReplenishmentOwnerDescriptionType',
            'RemarksType' => '\\Mnm\\StructType\\RemarksType',
            'RejectionNoteType' => '\\Mnm\\StructType\\RejectionNoteType',
            'SummaryDescriptionType' => '\\Mnm\\StructType\\SummaryDescriptionType',
            'SubscriberTypeType' => '\\Mnm\\StructType\\SubscriberTypeType',
            'StatusReasonType' => '\\Mnm\\StructType\\StatusReasonType',
            'TechnicalCommitteeDescriptionType' => '\\Mnm\\StructType\\TechnicalCommitteeDescriptionType',
            'TaxExemptionReasonType' => '\\Mnm\\StructType\\TaxExemptionReasonType',
            'TariffDescriptionType' => '\\Mnm\\StructType\\TariffDescriptionType',
            'SpecialTransportRequirementsType' => '\\Mnm\\StructType\\SpecialTransportRequirementsType',
            'ShipsRequirementsType' => '\\Mnm\\StructType\\ShipsRequirementsType',
            'ShippingMarksType' => '\\Mnm\\StructType\\ShippingMarksType',
            'SpecialTermsType' => '\\Mnm\\StructType\\SpecialTermsType',
            'SpecialServiceInstructionsType' => '\\Mnm\\StructType\\SpecialServiceInstructionsType',
            'SpecialInstructionsType' => '\\Mnm\\StructType\\SpecialInstructionsType',
            'RegionType' => '\\Mnm\\StructType\\RegionType',
            'PlacardEndorsementType' => '\\Mnm\\StructType\\PlacardEndorsementType',
            'PhoneNumberType' => '\\Mnm\\StructType\\PhoneNumberType',
            'PersonalSituationType' => '\\Mnm\\StructType\\PersonalSituationType',
            'PostalZoneType' => '\\Mnm\\StructType\\PostalZoneType',
            'PlotIdentificationType' => '\\Mnm\\StructType\\PlotIdentificationType',
            'PlacardNotationType' => '\\Mnm\\StructType\\PlacardNotationType',
            'PaymentOrderReferenceType' => '\\Mnm\\StructType\\PaymentOrderReferenceType',
            'PayPerViewType' => '\\Mnm\\StructType\\PayPerViewType',
            'PasswordType' => '\\Mnm\\StructType\\PasswordType',
            'PartyTypeType' => '\\Mnm\\StructType\\PartyTypeType',
            'PaymentNoteType' => '\\Mnm\\StructType\\PaymentNoteType',
            'PaymentDescriptionType' => '\\Mnm\\StructType\\PaymentDescriptionType',
            'PayerReferenceType' => '\\Mnm\\StructType\\PayerReferenceType',
            'ProcessReasonType' => '\\Mnm\\StructType\\ProcessReasonType',
            'ProcessDescriptionType' => '\\Mnm\\StructType\\ProcessDescriptionType',
            'PrizeDescriptionType' => '\\Mnm\\StructType\\PrizeDescriptionType',
            'RankType' => '\\Mnm\\StructType\\RankType',
            'PurposeType' => '\\Mnm\\StructType\\PurposeType',
            'PriorityType' => '\\Mnm\\StructType\\PriorityType',
            'PriceChangeReasonType' => '\\Mnm\\StructType\\PriceChangeReasonType',
            'PreviousMeterReadingMethodType' => '\\Mnm\\StructType\\PreviousMeterReadingMethodType',
            'PostboxType' => '\\Mnm\\StructType\\PostboxType',
            'PrintQualifierType' => '\\Mnm\\StructType\\PrintQualifierType',
            'PriceTypeType' => '\\Mnm\\StructType\\PriceTypeType',
            'PriceRevisionFormulaDescriptionType' => '\\Mnm\\StructType\\PriceRevisionFormulaDescriptionType',
            'TelecommunicationsServiceCallType' => '\\Mnm\\StructType\\TelecommunicationsServiceCallType',
            'TimingComplaintType' => '\\Mnm\\StructType\\TimingComplaintType',
            'TimezoneOffsetType' => '\\Mnm\\StructType\\TimezoneOffsetType',
            'TimeAmountType' => '\\Mnm\\StructType\\TimeAmountType',
            'TransportServiceProviderRemarksType' => '\\Mnm\\StructType\\TransportServiceProviderRemarksType',
            'TradingRestrictionsType' => '\\Mnm\\StructType\\TradingRestrictionsType',
            'TitleType' => '\\Mnm\\StructType\\TitleType',
            'TierRangeType' => '\\Mnm\\StructType\\TierRangeType',
            'TelefaxType' => '\\Mnm\\StructType\\TelefaxType',
            'TelecommunicationsSupplyTypeType' => '\\Mnm\\StructType\\TelecommunicationsSupplyTypeType',
            'TelecommunicationsServiceCategoryType' => '\\Mnm\\StructType\\TelecommunicationsServiceCategoryType',
            'TestMethodType' => '\\Mnm\\StructType\\TestMethodType',
            'TelephoneType' => '\\Mnm\\StructType\\TelephoneType',
            'WarrantyInformationType' => '\\Mnm\\StructType\\WarrantyInformationType',
            'ValueQualifierType' => '\\Mnm\\StructType\\ValueQualifierType',
            'XPathType' => '\\Mnm\\StructType\\XPathType',
            'WorkPhaseType' => '\\Mnm\\StructType\\WorkPhaseType',
            'WeightType' => '\\Mnm\\StructType\\WeightType',
            'ValidateToolVersionType' => '\\Mnm\\StructType\\ValidateToolVersionType',
            'TransportUserSpecialTermsType' => '\\Mnm\\StructType\\TransportUserSpecialTermsType',
            'TransportUserRemarksType' => '\\Mnm\\StructType\\TransportUserRemarksType',
            'TransportServiceProviderSpecialTermsType' => '\\Mnm\\StructType\\TransportServiceProviderSpecialTermsType',
            'ValidateToolType' => '\\Mnm\\StructType\\ValidateToolType',
            'ValidateProcessType' => '\\Mnm\\StructType\\ValidateProcessType',
            'TransportationServiceDescriptionType' => '\\Mnm\\StructType\\TransportationServiceDescriptionType',
            'ContractSubdivisionType' => '\\Mnm\\StructType\\ContractSubdivisionType',
            'ContractNameType' => '\\Mnm\\StructType\\ContractNameType',
            'ContentType' => '\\Mnm\\StructType\\ContentType',
            'CountrySubentityType' => '\\Mnm\\StructType\\CountrySubentityType',
            'CorrectionTypeType' => '\\Mnm\\StructType\\CorrectionTypeType',
            'ContractTypeType' => '\\Mnm\\StructType\\ContractTypeType',
            'ConsumptionTypeType' => '\\Mnm\\StructType\\ConsumptionTypeType',
            'ConditionsDescriptionType' => '\\Mnm\\StructType\\ConditionsDescriptionType',
            'ConditionType' => '\\Mnm\\StructType\\ConditionType',
            'CompanyLegalFormType' => '\\Mnm\\StructType\\CompanyLegalFormType',
            'ConsumptionLevelType' => '\\Mnm\\StructType\\ConsumptionLevelType',
            'ConsumersEnergyLevelType' => '\\Mnm\\StructType\\ConsumersEnergyLevelType',
            'ConditionsType' => '\\Mnm\\StructType\\ConditionsType',
            'CurrentChargeTypeType' => '\\Mnm\\StructType\\CurrentChargeTypeType',
            'DocumentDescriptionType' => '\\Mnm\\StructType\\DocumentDescriptionType',
            'DistrictType' => '\\Mnm\\StructType\\DistrictType',
            'DescriptionType' => '\\Mnm\\StructType\\DescriptionType',
            'DocumentTypeType' => '\\Mnm\\StructType\\DocumentTypeType',
            'DocumentStatusReasonDescriptionType' => '\\Mnm\\StructType\\DocumentStatusReasonDescriptionType',
            'DocumentHashType' => '\\Mnm\\StructType\\DocumentHashType',
            'DepartmentType' => '\\Mnm\\StructType\\DepartmentType',
            'DamageRemarksType' => '\\Mnm\\StructType\\DamageRemarksType',
            'CustomsClearanceServiceInstructionsType' => '\\Mnm\\StructType\\CustomsClearanceServiceInstructionsType',
            'CustomerReferenceType' => '\\Mnm\\StructType\\CustomerReferenceType',
            'DemurrageInstructionsType' => '\\Mnm\\StructType\\DemurrageInstructionsType',
            'DeliveryInstructionsType' => '\\Mnm\\StructType\\DeliveryInstructionsType',
            'DataSendingCapabilityType' => '\\Mnm\\StructType\\DataSendingCapabilityType',
            'CommentType' => '\\Mnm\\StructType\\CommentType',
            'AgencyNameType' => '\\Mnm\\StructType\\AgencyNameType',
            'AdditionalInformationType' => '\\Mnm\\StructType\\AdditionalInformationType',
            'AdditionalConditionsType' => '\\Mnm\\StructType\\AdditionalConditionsType',
            'AwardingCriterionDescriptionType' => '\\Mnm\\StructType\\AwardingCriterionDescriptionType',
            'ApprovalStatusType' => '\\Mnm\\StructType\\ApprovalStatusType',
            'AllowanceChargeReasonType' => '\\Mnm\\StructType\\AllowanceChargeReasonType',
            'ActivityTypeType' => '\\Mnm\\StructType\\ActivityTypeType',
            'AccountingCostType' => '\\Mnm\\StructType\\AccountingCostType',
            'AcceptedVariantsDescriptionType' => '\\Mnm\\StructType\\AcceptedVariantsDescriptionType',
            'BackorderReasonType' => '\\Mnm\\StructType\\BackorderReasonType',
            'ChangeConditionsType' => '\\Mnm\\StructType\\ChangeConditionsType',
            'CertificateTypeType' => '\\Mnm\\StructType\\CertificateTypeType',
            'CarrierServiceInstructionsType' => '\\Mnm\\StructType\\CarrierServiceInstructionsType',
            'CodeValueType' => '\\Mnm\\StructType\\CodeValueType',
            'CharacteristicsType' => '\\Mnm\\StructType\\CharacteristicsType',
            'ChannelType' => '\\Mnm\\StructType\\ChannelType',
            'BuyerReferenceType' => '\\Mnm\\StructType\\BuyerReferenceType',
            'BuildingNumberType' => '\\Mnm\\StructType\\BuildingNumberType',
            'BirthplaceNameType' => '\\Mnm\\StructType\\BirthplaceNameType',
            'CandidateStatementType' => '\\Mnm\\StructType\\CandidateStatementType',
            'CancellationNoteType' => '\\Mnm\\StructType\\CancellationNoteType',
            'CalculationExpressionType' => '\\Mnm\\StructType\\CalculationExpressionType',
            'DutyType' => '\\Mnm\\StructType\\DutyType',
            'MeterNameType' => '\\Mnm\\StructType\\MeterNameType',
            'MeterConstantType' => '\\Mnm\\StructType\\MeterConstantType',
            'MaximumValueType' => '\\Mnm\\StructType\\MaximumValueType',
            'MeterReadingTypeType' => '\\Mnm\\StructType\\MeterReadingTypeType',
            'MeterReadingCommentsType' => '\\Mnm\\StructType\\MeterReadingCommentsType',
            'MeterNumberType' => '\\Mnm\\StructType\\MeterNumberType',
            'MarkCareType' => '\\Mnm\\StructType\\MarkCareType',
            'LoginType' => '\\Mnm\\StructType\\LoginType',
            'LocationType' => '\\Mnm\\StructType\\LocationType',
            'ListValueType' => '\\Mnm\\StructType\\ListValueType',
            'MarkAttentionType' => '\\Mnm\\StructType\\MarkAttentionType',
            'LowTendersDescriptionType' => '\\Mnm\\StructType\\LowTendersDescriptionType',
            'LossRiskType' => '\\Mnm\\StructType\\LossRiskType',
            'MinimumImprovementBidType' => '\\Mnm\\StructType\\MinimumImprovementBidType',
            'OrganizationDepartmentType' => '\\Mnm\\StructType\\OrganizationDepartmentType',
            'OrderableUnitType' => '\\Mnm\\StructType\\OrderableUnitType',
            'OptionsDescriptionType' => '\\Mnm\\StructType\\OptionsDescriptionType',
            'OtherInstructionType' => '\\Mnm\\StructType\\OtherInstructionType',
            'OutstandingReasonType' => '\\Mnm\\StructType\\OutstandingReasonType',
            'PackingMaterialType' => '\\Mnm\\StructType\\PackingMaterialType',
            'OneTimeChargeTypeType' => '\\Mnm\\StructType\\OneTimeChargeTypeType',
            'MovieTitleType' => '\\Mnm\\StructType\\MovieTitleType',
            'MonetaryScopeType' => '\\Mnm\\StructType\\MonetaryScopeType',
            'MinimumValueType' => '\\Mnm\\StructType\\MinimumValueType',
            'NegotiationDescriptionType' => '\\Mnm\\StructType\\NegotiationDescriptionType',
            'NameSuffixType' => '\\Mnm\\StructType\\NameSuffixType',
            'LineType' => '\\Mnm\\StructType\\LineType',
            'FrequencyType' => '\\Mnm\\StructType\\FrequencyType',
            'ForwarderServiceInstructionsType' => '\\Mnm\\StructType\\ForwarderServiceInstructionsType',
            'FloorType' => '\\Mnm\\StructType\\FloorType',
            'HashAlgorithmMethodType' => '\\Mnm\\StructType\\HashAlgorithmMethodType',
            'HandlingInstructionsType' => '\\Mnm\\StructType\\HandlingInstructionsType',
            'FundingProgramType' => '\\Mnm\\StructType\\FundingProgramType',
            'FeeDescriptionType' => '\\Mnm\\StructType\\FeeDescriptionType',
            'ExclusionReasonType' => '\\Mnm\\StructType\\ExclusionReasonType',
            'ElectronicMailType' => '\\Mnm\\StructType\\ElectronicMailType',
            'ElectronicDeviceDescriptionType' => '\\Mnm\\StructType\\ElectronicDeviceDescriptionType',
            'ExtensionType' => '\\Mnm\\StructType\\ExtensionType',
            'ExpressionType' => '\\Mnm\\StructType\\ExpressionType',
            'ExemptionReasonType' => '\\Mnm\\StructType\\ExemptionReasonType',
            'HaulageInstructionsType' => '\\Mnm\\StructType\\HaulageInstructionsType',
            'LimitationDescriptionType' => '\\Mnm\\StructType\\LimitationDescriptionType',
            'JustificationType' => '\\Mnm\\StructType\\JustificationType',
            'JustificationDescriptionType' => '\\Mnm\\StructType\\JustificationDescriptionType',
            'KeywordType' => '\\Mnm\\StructType\\KeywordType',
            'LatestMeterReadingMethodType' => '\\Mnm\\StructType\\LatestMeterReadingMethodType',
            'LegalReferenceType' => '\\Mnm\\StructType\\LegalReferenceType',
            'JobTitleType' => '\\Mnm\\StructType\\JobTitleType',
            'InhouseMailType' => '\\Mnm\\StructType\\InhouseMailType',
            'InformationType' => '\\Mnm\\StructType\\InformationType',
            'HeatingTypeType' => '\\Mnm\\StructType\\HeatingTypeType',
            'InvoicingPartyReferenceType' => '\\Mnm\\StructType\\InvoicingPartyReferenceType',
            'InstructionsType' => '\\Mnm\\StructType\\InstructionsType',
            'InstructionNoteType' => '\\Mnm\\StructType\\InstructionNoteType',
            'LineCountNumericType' => '\\Mnm\\StructType\\LineCountNumericType',
            'SourceCurrencyBaseRateType' => '\\Mnm\\StructType\\SourceCurrencyBaseRateType',
            'CalculationRateType' => '\\Mnm\\StructType\\CalculationRateType',
            'AmountRateType' => '\\Mnm\\StructType\\AmountRateType',
            'OrderableUnitFactorRateType' => '\\Mnm\\StructType\\OrderableUnitFactorRateType',
            'TargetCurrencyBaseRateType' => '\\Mnm\\StructType\\TargetCurrencyBaseRateType',
            'TargetServicePercentType' => '\\Mnm\\StructType\\TargetServicePercentType',
            'PaymentPercentType' => '\\Mnm\\StructType\\PaymentPercentType',
            'TierRatePercentType' => '\\Mnm\\StructType\\TierRatePercentType',
            'ReliabilityPercentType' => '\\Mnm\\StructType\\ReliabilityPercentType',
            'SettlementDiscountPercentType' => '\\Mnm\\StructType\\SettlementDiscountPercentType',
            'ProgressPercentType' => '\\Mnm\\StructType\\ProgressPercentType',
            'PenaltySurchargePercentType' => '\\Mnm\\StructType\\PenaltySurchargePercentType',
            'ParticipationPercentType' => '\\Mnm\\StructType\\ParticipationPercentType',
            'HumidityPercentType' => '\\Mnm\\StructType\\HumidityPercentType',
            'AirFlowPercentType' => '\\Mnm\\StructType\\AirFlowPercentType',
            'MaximumPercentType' => '\\Mnm\\StructType\\MaximumPercentType',
            'PartecipationPercentType' => '\\Mnm\\StructType\\PartecipationPercentType',
            'MinimumPercentType' => '\\Mnm\\StructType\\MinimumPercentType',
            'ReminderSequenceNumericType' => '\\Mnm\\StructType\\ReminderSequenceNumericType',
            'ResidentOccupantsNumericType' => '\\Mnm\\StructType\\ResidentOccupantsNumericType',
            'SequenceNumericType' => '\\Mnm\\StructType\\SequenceNumericType',
            'OrderQuantityIncrementNumericType' => '\\Mnm\\StructType\\OrderQuantityIncrementNumericType',
            'PackSizeNumericType' => '\\Mnm\\StructType\\PackSizeNumericType',
            'WeightNumericType' => '\\Mnm\\StructType\\WeightNumericType',
            'BudgetYearNumericType' => '\\Mnm\\StructType\\BudgetYearNumericType',
            'CalculationSequenceNumericType' => '\\Mnm\\StructType\\CalculationSequenceNumericType',
            'MinimumNumberNumericType' => '\\Mnm\\StructType\\MinimumNumberNumericType',
            'FrozenPeriodDaysNumericType' => '\\Mnm\\StructType\\FrozenPeriodDaysNumericType',
            'MaximumPaymentInstructionsNumericType' => '\\Mnm\\StructType\\MaximumPaymentInstructionsNumericType',
            'MultiplierFactorNumericType' => '\\Mnm\\StructType\\MultiplierFactorNumericType',
            'OrderIntervalDaysNumericType' => '\\Mnm\\StructType\\OrderIntervalDaysNumericType',
            'MaximumNumberNumericType' => '\\Mnm\\StructType\\MaximumNumberNumericType',
            'LineNumberNumericType' => '\\Mnm\\StructType\\LineNumberNumericType',
            'MaximumCopiesNumericType' => '\\Mnm\\StructType\\MaximumCopiesNumericType',
            'DurationMeasureType' => '\\Mnm\\StructType\\DurationMeasureType',
            'MinimumMeasureType' => '\\Mnm\\StructType\\MinimumMeasureType',
            'NetNetWeightMeasureType' => '\\Mnm\\StructType\\NetNetWeightMeasureType',
            'MaximumMeasureType' => '\\Mnm\\StructType\\MaximumMeasureType',
            'LoadingLengthMeasureType' => '\\Mnm\\StructType\\LoadingLengthMeasureType',
            'LongitudeDegreesMeasureType' => '\\Mnm\\StructType\\LongitudeDegreesMeasureType',
            'LongitudeMinutesMeasureType' => '\\Mnm\\StructType\\LongitudeMinutesMeasureType',
            'NetTonnageMeasureType' => '\\Mnm\\StructType\\NetTonnageMeasureType',
            'TareWeightMeasureType' => '\\Mnm\\StructType\\TareWeightMeasureType',
            'ValueMeasureType' => '\\Mnm\\StructType\\ValueMeasureType',
            'SourceValueMeasureType' => '\\Mnm\\StructType\\SourceValueMeasureType',
            'NetWeightMeasureType' => '\\Mnm\\StructType\\NetWeightMeasureType',
            'PostEventNotificationDurationMeasureType' => '\\Mnm\\StructType\\PostEventNotificationDurationMeasureType',
            'PreEventNotificationDurationMeasureType' => '\\Mnm\\StructType\\PreEventNotificationDurationMeasureType',
            'AltitudeMeasureType' => '\\Mnm\\StructType\\AltitudeMeasureType',
            'ChargeableWeightMeasureType' => '\\Mnm\\StructType\\ChargeableWeightMeasureType',
            'BaseUnitMeasureType' => '\\Mnm\\StructType\\BaseUnitMeasureType',
            'NetVolumeMeasureType' => '\\Mnm\\StructType\\NetVolumeMeasureType',
            'GrossWeightMeasureType' => '\\Mnm\\StructType\\GrossWeightMeasureType',
            'GrossVolumeMeasureType' => '\\Mnm\\StructType\\GrossVolumeMeasureType',
            'LeadTimeMeasureType' => '\\Mnm\\StructType\\LeadTimeMeasureType',
            'LatitudeMinutesMeasureType' => '\\Mnm\\StructType\\LatitudeMinutesMeasureType',
            'ComparedValueMeasureType' => '\\Mnm\\StructType\\ComparedValueMeasureType',
            'LatitudeDegreesMeasureType' => '\\Mnm\\StructType\\LatitudeDegreesMeasureType',
            'GrossTonnageMeasureType' => '\\Mnm\\StructType\\GrossTonnageMeasureType',
            'EmbeddedDocumentBinaryObjectType' => '\\Mnm\\StructType\\EmbeddedDocumentBinaryObjectType',
            'CorporateStockAmountType' => '\\Mnm\\StructType\\CorporateStockAmountType',
            'PerUnitAmountType' => '\\Mnm\\StructType\\PerUnitAmountType',
            'PrepaidAmountType' => '\\Mnm\\StructType\\PrepaidAmountType',
            'PenaltyAmountType' => '\\Mnm\\StructType\\PenaltyAmountType',
            'PayableRoundingAmountType' => '\\Mnm\\StructType\\PayableRoundingAmountType',
            'RoundingAmountType' => '\\Mnm\\StructType\\RoundingAmountType',
            'SettlementDiscountAmountType' => '\\Mnm\\StructType\\SettlementDiscountAmountType',
            'PriceAmountType' => '\\Mnm\\StructType\\PriceAmountType',
            'RequiredFeeAmountType' => '\\Mnm\\StructType\\RequiredFeeAmountType',
            'PayableAmountType' => '\\Mnm\\StructType\\PayableAmountType',
            'PartyCapacityAmountType' => '\\Mnm\\StructType\\PartyCapacityAmountType',
            'PayableAlternativeAmountType' => '\\Mnm\\StructType\\PayableAlternativeAmountType',
            'MinimumAmountType' => '\\Mnm\\StructType\\MinimumAmountType',
            'PaidAmountType' => '\\Mnm\\StructType\\PaidAmountType',
            'DeclaredCarriageValueAmountType' => '\\Mnm\\StructType\\DeclaredCarriageValueAmountType',
            'DeclaredCustomsValueAmountType' => '\\Mnm\\StructType\\DeclaredCustomsValueAmountType',
            'CreditLineAmountType' => '\\Mnm\\StructType\\CreditLineAmountType',
            'DebitLineAmountType' => '\\Mnm\\StructType\\DebitLineAmountType',
            'TaxAmountType' => '\\Mnm\\StructType\\TaxAmountType',
            'TotalInvoiceAmountType' => '\\Mnm\\StructType\\TotalInvoiceAmountType',
            'TotalPaymentAmountType' => '\\Mnm\\StructType\\TotalPaymentAmountType',
            'TotalCreditAmountType' => '\\Mnm\\StructType\\TotalCreditAmountType',
            'TotalDebitAmountType' => '\\Mnm\\StructType\\TotalDebitAmountType',
            'TotalTaskAmountType' => '\\Mnm\\StructType\\TotalTaskAmountType',
            'ValueAmountType' => '\\Mnm\\StructType\\ValueAmountType',
            'TotalTaxAmountType' => '\\Mnm\\StructType\\TotalTaxAmountType',
            'TransactionCurrencyTaxAmountType' => '\\Mnm\\StructType\\TransactionCurrencyTaxAmountType',
            'TaxEnergyOnAccountAmountType' => '\\Mnm\\StructType\\TaxEnergyOnAccountAmountType',
            'TaxExclusiveAmountType' => '\\Mnm\\StructType\\TaxExclusiveAmountType',
            'TaxEnergyAmountType' => '\\Mnm\\StructType\\TaxEnergyAmountType',
            'TaxEnergyBalanceAmountType' => '\\Mnm\\StructType\\TaxEnergyBalanceAmountType',
            'TaxInclusiveAmountType' => '\\Mnm\\StructType\\TaxInclusiveAmountType',
            'TotalAmountType' => '\\Mnm\\StructType\\TotalAmountType',
            'TotalBalanceAmountType' => '\\Mnm\\StructType\\TotalBalanceAmountType',
            'TaxableAmountType' => '\\Mnm\\StructType\\TaxableAmountType',
            'ThresholdAmountType' => '\\Mnm\\StructType\\ThresholdAmountType',
            'InsurancePremiumAmountType' => '\\Mnm\\StructType\\InsurancePremiumAmountType',
            'InsuranceValueAmountType' => '\\Mnm\\StructType\\InsuranceValueAmountType',
            'AnnualAverageAmountType' => '\\Mnm\\StructType\\AnnualAverageAmountType',
            'AdvertisementAmountType' => '\\Mnm\\StructType\\AdvertisementAmountType',
            'AllowanceTotalAmountType' => '\\Mnm\\StructType\\AllowanceTotalAmountType',
            'EstimatedAmountType' => '\\Mnm\\StructType\\EstimatedAmountType',
            'EstimatedOverallContractAmountType' => '\\Mnm\\StructType\\EstimatedOverallContractAmountType',
            'DeclaredStatisticsValueAmountType' => '\\Mnm\\StructType\\DeclaredStatisticsValueAmountType',
            'DocumentationFeeAmountType' => '\\Mnm\\StructType\\DocumentationFeeAmountType',
            'FaceValueAmountType' => '\\Mnm\\StructType\\FaceValueAmountType',
            'HigherTenderAmountType' => '\\Mnm\\StructType\\HigherTenderAmountType',
            'FeeAmountType' => '\\Mnm\\StructType\\FeeAmountType',
            'FreeOnBoardValueAmountType' => '\\Mnm\\StructType\\FreeOnBoardValueAmountType',
            'CorrectionAmountType' => '\\Mnm\\StructType\\CorrectionAmountType',
            'CorrectionUnitAmountType' => '\\Mnm\\StructType\\CorrectionUnitAmountType',
            'ChargeTotalAmountType' => '\\Mnm\\StructType\\ChargeTotalAmountType',
            'LowerTenderAmountType' => '\\Mnm\\StructType\\LowerTenderAmountType',
            'MaximumAmountType' => '\\Mnm\\StructType\\MaximumAmountType',
            'MaximumPaidAmountType' => '\\Mnm\\StructType\\MaximumPaidAmountType',
            'MarketValueAmountType' => '\\Mnm\\StructType\\MarketValueAmountType',
            'MaximumAdvertisementAmountType' => '\\Mnm\\StructType\\MaximumAdvertisementAmountType',
            'AverageSubsequentContractAmountType' => '\\Mnm\\StructType\\AverageSubsequentContractAmountType',
            'BalanceAmountType' => '\\Mnm\\StructType\\BalanceAmountType',
            'InventoryValueAmountType' => '\\Mnm\\StructType\\InventoryValueAmountType',
            'AverageAmountType' => '\\Mnm\\StructType\\AverageAmountType',
            'BaseAmountType' => '\\Mnm\\StructType\\BaseAmountType',
            'LineExtensionAmountType' => '\\Mnm\\StructType\\LineExtensionAmountType',
            'CallExtensionAmountType' => '\\Mnm\\StructType\\CallExtensionAmountType',
            'CallBaseAmountType' => '\\Mnm\\StructType\\CallBaseAmountType',
            'LiabilityAmountType' => '\\Mnm\\StructType\\LiabilityAmountType',
            'DeclaredForCarriageValueAmountType' => '\\Mnm\\StructType\\DeclaredForCarriageValueAmountType',
            'TotalConsumedQuantityType' => '\\Mnm\\StructType\\TotalConsumedQuantityType',
            'TimeDeltaDaysQuantityType' => '\\Mnm\\StructType\\TimeDeltaDaysQuantityType',
            'TotalGoodsItemQuantityType' => '\\Mnm\\StructType\\TotalGoodsItemQuantityType',
            'TotalDeliveredQuantityType' => '\\Mnm\\StructType\\TotalDeliveredQuantityType',
            'ThresholdQuantityType' => '\\Mnm\\StructType\\ThresholdQuantityType',
            'MinimumOrderQuantityType' => '\\Mnm\\StructType\\MinimumOrderQuantityType',
            'MinimumQuantityType' => '\\Mnm\\StructType\\MinimumQuantityType',
            'TargetInventoryQuantityType' => '\\Mnm\\StructType\\TargetInventoryQuantityType',
            'MinimumInventoryQuantityType' => '\\Mnm\\StructType\\MinimumInventoryQuantityType',
            'VarianceQuantityType' => '\\Mnm\\StructType\\VarianceQuantityType',
            'MaximumVariantQuantityType' => '\\Mnm\\StructType\\MaximumVariantQuantityType',
            'MinimumBackorderQuantityType' => '\\Mnm\\StructType\\MinimumBackorderQuantityType',
            'ValueQuantityType' => '\\Mnm\\StructType\\ValueQuantityType',
            'TotalPackageQuantityType' => '\\Mnm\\StructType\\TotalPackageQuantityType',
            'TotalMeteredQuantityType' => '\\Mnm\\StructType\\TotalMeteredQuantityType',
            'TotalTransportHandlingUnitQuantityType' => '\\Mnm\\StructType\\TotalTransportHandlingUnitQuantityType',
            'TotalPackagesQuantityType' => '\\Mnm\\StructType\\TotalPackagesQuantityType',
            'ReceivedForeignTenderQuantityType' => '\\Mnm\\StructType\\ReceivedForeignTenderQuantityType',
            'ShortQuantityType' => '\\Mnm\\StructType\\ShortQuantityType',
            'ReceivedElectronicTenderQuantityType' => '\\Mnm\\StructType\\ReceivedElectronicTenderQuantityType',
            'SharesNumberQuantityType' => '\\Mnm\\StructType\\SharesNumberQuantityType',
            'ReceivedTenderQuantityType' => '\\Mnm\\StructType\\ReceivedTenderQuantityType',
            'ReceivedQuantityType' => '\\Mnm\\StructType\\ReceivedQuantityType',
            'ReturnableQuantityType' => '\\Mnm\\StructType\\ReturnableQuantityType',
            'RejectedQuantityType' => '\\Mnm\\StructType\\RejectedQuantityType',
            'OperatingYearsQuantityType' => '\\Mnm\\StructType\\OperatingYearsQuantityType',
            'OutstandingQuantityType' => '\\Mnm\\StructType\\OutstandingQuantityType',
            'MultipleOrderQuantityType' => '\\Mnm\\StructType\\MultipleOrderQuantityType',
            'NormalTemperatureReductionQuantityType' => '\\Mnm\\StructType\\NormalTemperatureReductionQuantityType',
            'OversupplyQuantityType' => '\\Mnm\\StructType\\OversupplyQuantityType',
            'PerformanceValueQuantityType' => '\\Mnm\\StructType\\PerformanceValueQuantityType',
            'PreviousMeterQuantityType' => '\\Mnm\\StructType\\PreviousMeterQuantityType',
            'PackQuantityType' => '\\Mnm\\StructType\\PackQuantityType',
            'PassengerQuantityType' => '\\Mnm\\StructType\\PassengerQuantityType',
            'ConsignmentQuantityType' => '\\Mnm\\StructType\\ConsignmentQuantityType',
            'ConsumerUnitQuantityType' => '\\Mnm\\StructType\\ConsumerUnitQuantityType',
            'ChargeableQuantityType' => '\\Mnm\\StructType\\ChargeableQuantityType',
            'ChildConsignmentQuantityType' => '\\Mnm\\StructType\\ChildConsignmentQuantityType',
            'ContentUnitQuantityType' => '\\Mnm\\StructType\\ContentUnitQuantityType',
            'CreditedQuantityType' => '\\Mnm\\StructType\\CreditedQuantityType',
            'ConsumptionEnergyQuantityType' => '\\Mnm\\StructType\\ConsumptionEnergyQuantityType',
            'ConsumptionWaterQuantityType' => '\\Mnm\\StructType\\ConsumptionWaterQuantityType',
            'BatchQuantityType' => '\\Mnm\\StructType\\BatchQuantityType',
            'BaseQuantityType' => '\\Mnm\\StructType\\BaseQuantityType',
            'BasicConsumedQuantityType' => '\\Mnm\\StructType\\BasicConsumedQuantityType',
            'ActualTemperatureReductionQuantityType' => '\\Mnm\\StructType\\ActualTemperatureReductionQuantityType',
            'BackorderQuantityType' => '\\Mnm\\StructType\\BackorderQuantityType',
            'InvoicedQuantityType' => '\\Mnm\\StructType\\InvoicedQuantityType',
            'LatestMeterQuantityType' => '\\Mnm\\StructType\\LatestMeterQuantityType',
            'ExpectedQuantityType' => '\\Mnm\\StructType\\ExpectedQuantityType',
            'GasPressureQuantityType' => '\\Mnm\\StructType\\GasPressureQuantityType',
            'MaximumOrderQuantityType' => '\\Mnm\\StructType\\MaximumOrderQuantityType',
            'MaximumQuantityType' => '\\Mnm\\StructType\\MaximumQuantityType',
            'MaximumBackorderQuantityType' => '\\Mnm\\StructType\\MaximumBackorderQuantityType',
            'MaximumOperatorQuantityType' => '\\Mnm\\StructType\\MaximumOperatorQuantityType',
            'ExpectedOperatorQuantityType' => '\\Mnm\\StructType\\ExpectedOperatorQuantityType',
            'DebitedQuantityType' => '\\Mnm\\StructType\\DebitedQuantityType',
            'DeliveredQuantityType' => '\\Mnm\\StructType\\DeliveredQuantityType',
            'CrewQuantityType' => '\\Mnm\\StructType\\CrewQuantityType',
            'CustomsTariffQuantityType' => '\\Mnm\\StructType\\CustomsTariffQuantityType',
            'EstimatedConsumedQuantityType' => '\\Mnm\\StructType\\EstimatedConsumedQuantityType',
            'EstimatedOverallContractQuantityType' => '\\Mnm\\StructType\\EstimatedOverallContractQuantityType',
            'DifferenceTemperatureReductionQuantityType' => '\\Mnm\\StructType\\DifferenceTemperatureReductionQuantityType',
            'EmployeeQuantityType' => '\\Mnm\\StructType\\EmployeeQuantityType',
            'PeriodType' => '\\Mnm\\StructType\\PeriodType',
            'OrderReferenceType' => '\\Mnm\\StructType\\OrderReferenceType',
            'DocumentReferenceType' => '\\Mnm\\StructType\\DocumentReferenceType',
            'AttachmentType' => '\\Mnm\\StructType\\AttachmentType',
            'ExternalReferenceType' => '\\Mnm\\StructType\\ExternalReferenceType',
            'PartyType' => '\\Mnm\\StructType\\PartyType',
            'PartyIdentificationType' => '\\Mnm\\StructType\\PartyIdentificationType',
            'PartyNameType' => '\\Mnm\\StructType\\PartyNameType',
            'AddressType' => '\\Mnm\\StructType\\AddressType',
            'CountryType' => '\\Mnm\\StructType\\CountryType',
            'PartyTaxSchemeType' => '\\Mnm\\StructType\\PartyTaxSchemeType',
            'TaxSchemeType' => '\\Mnm\\StructType\\TaxSchemeType',
            'PartyLegalEntityType' => '\\Mnm\\StructType\\PartyLegalEntityType',
            'CorporateRegistrationSchemeType' => '\\Mnm\\StructType\\CorporateRegistrationSchemeType',
            'ContactType' => '\\Mnm\\StructType\\ContactType',
            'CommunicationType' => '\\Mnm\\StructType\\CommunicationType',
            'PersonType' => '\\Mnm\\StructType\\PersonType',
            'FinancialAccountType' => '\\Mnm\\StructType\\FinancialAccountType',
            'BranchType' => '\\Mnm\\StructType\\BranchType',
            'FinancialInstitutionType' => '\\Mnm\\StructType\\FinancialInstitutionType',
            'BillingReferenceType' => '\\Mnm\\StructType\\BillingReferenceType',
            'BillingReferenceLineType' => '\\Mnm\\StructType\\BillingReferenceLineType',
            'AllowanceChargeType' => '\\Mnm\\StructType\\AllowanceChargeType',
            'SupplierPartyType' => '\\Mnm\\StructType\\SupplierPartyType',
            'CustomerPartyType' => '\\Mnm\\StructType\\CustomerPartyType',
            'DeliveryType' => '\\Mnm\\StructType\\DeliveryType',
            'DespatchType' => '\\Mnm\\StructType\\DespatchType',
            'DeliveryTermsType' => '\\Mnm\\StructType\\DeliveryTermsType',
            'ShipmentType' => '\\Mnm\\StructType\\ShipmentType',
            'GoodsItemType' => '\\Mnm\\StructType\\GoodsItemType',
            'ItemType' => '\\Mnm\\StructType\\ItemType',
            'ItemIdentificationType' => '\\Mnm\\StructType\\ItemIdentificationType',
            'CommodityClassificationType' => '\\Mnm\\StructType\\CommodityClassificationType',
            'ItemInstanceType' => '\\Mnm\\StructType\\ItemInstanceType',
            'ItemPropertyType' => '\\Mnm\\StructType\\ItemPropertyType',
            'ItemPropertyGroupType' => '\\Mnm\\StructType\\ItemPropertyGroupType',
            'DimensionType' => '\\Mnm\\StructType\\DimensionType',
            'ItemPropertyRangeType' => '\\Mnm\\StructType\\ItemPropertyRangeType',
            'LotIdentificationType' => '\\Mnm\\StructType\\LotIdentificationType',
            'InvoiceLineType' => '\\Mnm\\StructType\\InvoiceLineType',
            'OrderLineReferenceType' => '\\Mnm\\StructType\\OrderLineReferenceType',
            'LineReferenceType' => '\\Mnm\\StructType\\LineReferenceType',
            'TaxTotalType' => '\\Mnm\\StructType\\TaxTotalType',
            'TaxSubtotalType' => '\\Mnm\\StructType\\TaxSubtotalType',
            'TaxCategoryType' => '\\Mnm\\StructType\\TaxCategoryType',
            'PriceType' => '\\Mnm\\StructType\\PriceType',
            'TemperatureType' => '\\Mnm\\StructType\\TemperatureType',
            'ShipmentStageType' => '\\Mnm\\StructType\\ShipmentStageType',
            'TransportMeansType' => '\\Mnm\\StructType\\TransportMeansType',
            'StowageType' => '\\Mnm\\StructType\\StowageType',
            'AirTransportType' => '\\Mnm\\StructType\\AirTransportType',
            'RoadTransportType' => '\\Mnm\\StructType\\RoadTransportType',
            'RailTransportType' => '\\Mnm\\StructType\\RailTransportType',
            'MaritimeTransportType' => '\\Mnm\\StructType\\MaritimeTransportType',
            'TransportHandlingUnitType' => '\\Mnm\\StructType\\TransportHandlingUnitType',
            'PackageType' => '\\Mnm\\StructType\\PackageType',
            'TransportEquipmentType' => '\\Mnm\\StructType\\TransportEquipmentType',
            'HazardousGoodsTransitType' => '\\Mnm\\StructType\\HazardousGoodsTransitType',
            'CustomsDeclarationType' => '\\Mnm\\StructType\\CustomsDeclarationType',
            'PaymentMeansType' => '\\Mnm\\StructType\\PaymentMeansType',
            'PaymentTermsType' => '\\Mnm\\StructType\\PaymentTermsType',
            'ExchangeRateType' => '\\Mnm\\StructType\\ExchangeRateType',
            'MonetaryTotalType' => '\\Mnm\\StructType\\MonetaryTotalType',
            'InvoiceType' => '\\Mnm\\StructType\\InvoiceType',
            'GetSystemDate' => '\\Mnm\\StructType\\GetSystemDate',
            'UserInformation' => '\\Mnm\\StructType\\UserInformation',
            'GetSystemDateResponse' => '\\Mnm\\StructType\\GetSystemDateResponse',
            'DateResponse' => '\\Mnm\\StructType\\DateResponse',
            'Response' => '\\Mnm\\StructType\\Response',
            'GetSystemDateWithFormat' => '\\Mnm\\StructType\\GetSystemDateWithFormat',
            'GetSystemDateWithFormatResponse' => '\\Mnm\\StructType\\GetSystemDateWithFormatResponse',
            'StringResponse' => '\\Mnm\\StructType\\StringResponse',
            'IsEInvoiceUser' => '\\Mnm\\StructType\\IsEInvoiceUser',
            'IsEInvoiceUserResponse' => '\\Mnm\\StructType\\IsEInvoiceUserResponse',
            'FlagResponse' => '\\Mnm\\StructType\\FlagResponse',
            'GetEInvoiceUsers' => '\\Mnm\\StructType\\GetEInvoiceUsers',
            'PagedQueryContext' => '\\Mnm\\StructType\\PagedQueryContext',
            'GetEInvoiceUsersResponse' => '\\Mnm\\StructType\\GetEInvoiceUsersResponse',
            'SystemUsersResponse' => '\\Mnm\\StructType\\SystemUsersResponse',
            'PagedResponseOfSystemUser' => '\\Mnm\\StructType\\PagedResponseOfSystemUser',
            'SystemUser' => '\\Mnm\\StructType\\SystemUser',
            'EntityUpdatedHistory' => '\\Mnm\\StructType\\EntityUpdatedHistory',
            'EntityCreateHistory' => '\\Mnm\\StructType\\EntityCreateHistory',
            'EntityBaseInt' => '\\Mnm\\StructType\\EntityBaseInt',
            'EntityBase' => '\\Mnm\\StructType\\EntityBase',
            'FilterEInvoiceUsers' => '\\Mnm\\StructType\\FilterEInvoiceUsers',
            'SystemUserFilterContext' => '\\Mnm\\StructType\\SystemUserFilterContext',
            'FilterablePagedQueryContext' => '\\Mnm\\StructType\\FilterablePagedQueryContext',
            'FilterEInvoiceUsersResponse' => '\\Mnm\\StructType\\FilterEInvoiceUsersResponse',
            'GetUserAliasses' => '\\Mnm\\StructType\\GetUserAliasses',
            'GetUserAliassesResponse' => '\\Mnm\\StructType\\GetUserAliassesResponse',
            'UserAliassesResponse' => '\\Mnm\\StructType\\UserAliassesResponse',
            'SystemUserWithAlias' => '\\Mnm\\StructType\\SystemUserWithAlias',
            'SystemUserDefinition' => '\\Mnm\\StructType\\SystemUserDefinition',
            'SystemUserAlias' => '\\Mnm\\StructType\\SystemUserAlias',
            'SetXsltView' => '\\Mnm\\StructType\\SetXsltView',
            'SetXsltViewResponse' => '\\Mnm\\StructType\\SetXsltViewResponse',
            'GetXsltView' => '\\Mnm\\StructType\\GetXsltView',
            'GetXsltViewResponse' => '\\Mnm\\StructType\\GetXsltViewResponse',
            'StringElementResponse' => '\\Mnm\\StructType\\StringElementResponse',
            'ValidateInvoice' => '\\Mnm\\StructType\\ValidateInvoice',
            'ValidateInvoiceResponse' => '\\Mnm\\StructType\\ValidateInvoiceResponse',
            'GetInboxInvoices' => '\\Mnm\\StructType\\GetInboxInvoices',
            'InboxInvoiceQueryModel' => '\\Mnm\\StructType\\InboxInvoiceQueryModel',
            'InvoiceQueryModel' => '\\Mnm\\StructType\\InvoiceQueryModel',
            'GetInboxInvoicesResponse' => '\\Mnm\\StructType\\GetInboxInvoicesResponse',
            'InvoicesResponse' => '\\Mnm\\StructType\\InvoicesResponse',
            'PagedResponseOfInvoiceInfo' => '\\Mnm\\StructType\\PagedResponseOfInvoiceInfo',
            'InvoiceInfo' => '\\Mnm\\StructType\\InvoiceInfo',
            'CustomerInfo' => '\\Mnm\\StructType\\CustomerInfo',
            'EArchiveInvoiceInformation' => '\\Mnm\\StructType\\EArchiveInvoiceInformation',
            'NewGenerationPaymentRecorderInformation' => '\\Mnm\\StructType\\NewGenerationPaymentRecorderInformation',
            'InternetSalesInformation' => '\\Mnm\\StructType\\InternetSalesInformation',
            'ShipmentInformation' => '\\Mnm\\StructType\\ShipmentInformation',
            'ShipmentCarier' => '\\Mnm\\StructType\\ShipmentCarier',
            'EArchiveWithHoldingInformation' => '\\Mnm\\StructType\\EArchiveWithHoldingInformation',
            'NotificationInformation' => '\\Mnm\\StructType\\NotificationInformation',
            'MailingInformation' => '\\Mnm\\StructType\\MailingInformation',
            'MailAttachmentInformation' => '\\Mnm\\StructType\\MailAttachmentInformation',
            'SmsMessageInformation' => '\\Mnm\\StructType\\SmsMessageInformation',
            'GetInboxInvoiceList' => '\\Mnm\\StructType\\GetInboxInvoiceList',
            'InboxInvoiceListQueryModel' => '\\Mnm\\StructType\\InboxInvoiceListQueryModel',
            'InvoiceListQueryModel' => '\\Mnm\\StructType\\InvoiceListQueryModel',
            'GetInboxInvoiceListResponse' => '\\Mnm\\StructType\\GetInboxInvoiceListResponse',
            'InboxInvoiceListResponse' => '\\Mnm\\StructType\\InboxInvoiceListResponse',
            'PagedResponseOfInboxInvoiceListItem' => '\\Mnm\\StructType\\PagedResponseOfInboxInvoiceListItem',
            'InboxInvoiceListItem' => '\\Mnm\\StructType\\InboxInvoiceListItem',
            'InvoiceListItemBase' => '\\Mnm\\StructType\\InvoiceListItemBase',
            'GetInboxInvoice' => '\\Mnm\\StructType\\GetInboxInvoice',
            'GetInboxInvoiceResponse' => '\\Mnm\\StructType\\GetInboxInvoiceResponse',
            'InvoiceResponse' => '\\Mnm\\StructType\\InvoiceResponse',
            'QueryInboxInvoiceStatus' => '\\Mnm\\StructType\\QueryInboxInvoiceStatus',
            'ArrayOfString' => '\\Mnm\\ArrayType\\ArrayOfString',
            'QueryInboxInvoiceStatusResponse' => '\\Mnm\\StructType\\QueryInboxInvoiceStatusResponse',
            'InvoiceStatusResponse' => '\\Mnm\\StructType\\InvoiceStatusResponse',
            'InvoiceStatusInfo' => '\\Mnm\\StructType\\InvoiceStatusInfo',
            'SetInvoicesTaken' => '\\Mnm\\StructType\\SetInvoicesTaken',
            'SetInvoicesTakenResponse' => '\\Mnm\\StructType\\SetInvoicesTakenResponse',
            'SendDocumentResponse' => '\\Mnm\\StructType\\SendDocumentResponse',
            'ArrayOfDocumentResponseInfo' => '\\Mnm\\ArrayType\\ArrayOfDocumentResponseInfo',
            'DocumentResponseInfo' => '\\Mnm\\StructType\\DocumentResponseInfo',
            'ArrayOfLineResponseInfo' => '\\Mnm\\ArrayType\\ArrayOfLineResponseInfo',
            'LineResponseInfo' => '\\Mnm\\StructType\\LineResponseInfo',
            'SendDocumentResponseResponse' => '\\Mnm\\StructType\\SendDocumentResponseResponse',
            'QueryDocumentResponseStatus' => '\\Mnm\\StructType\\QueryDocumentResponseStatus',
            'QueryDocumentResponseStatusResponse' => '\\Mnm\\StructType\\QueryDocumentResponseStatusResponse',
            'DocumentResponseStatusResponse' => '\\Mnm\\StructType\\DocumentResponseStatusResponse',
            'DocumentResponseStatusInfo' => '\\Mnm\\StructType\\DocumentResponseStatusInfo',
            'GetOutboxInvoices' => '\\Mnm\\StructType\\GetOutboxInvoices',
            'GetOutboxInvoicesResponse' => '\\Mnm\\StructType\\GetOutboxInvoicesResponse',
            'GetOutboxInvoiceList' => '\\Mnm\\StructType\\GetOutboxInvoiceList',
            'OutboxInvoiceListQueryModel' => '\\Mnm\\StructType\\OutboxInvoiceListQueryModel',
            'GetOutboxInvoiceListResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceListResponse',
            'OutboxInvoiceListResponse' => '\\Mnm\\StructType\\OutboxInvoiceListResponse',
            'PagedResponseOfOutboxInvoiceListItem' => '\\Mnm\\StructType\\PagedResponseOfOutboxInvoiceListItem',
            'OutboxInvoiceListItem' => '\\Mnm\\StructType\\OutboxInvoiceListItem',
            'GetOutboxInvoice' => '\\Mnm\\StructType\\GetOutboxInvoice',
            'GetOutboxInvoiceResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceResponse',
            'GetOutboxInvoicesData' => '\\Mnm\\StructType\\GetOutboxInvoicesData',
            'GetOutboxInvoicesDataResponse' => '\\Mnm\\StructType\\GetOutboxInvoicesDataResponse',
            'InvoicesDataResponse' => '\\Mnm\\StructType\\InvoicesDataResponse',
            'PagedResponseOfInvoiceData' => '\\Mnm\\StructType\\PagedResponseOfInvoiceData',
            'InvoiceData' => '\\Mnm\\StructType\\InvoiceData',
            'GetOutboxInvoiceData' => '\\Mnm\\StructType\\GetOutboxInvoiceData',
            'GetOutboxInvoiceDataResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceDataResponse',
            'InvoiceDataResponse' => '\\Mnm\\StructType\\InvoiceDataResponse',
            'GetInboxInvoicesData' => '\\Mnm\\StructType\\GetInboxInvoicesData',
            'GetInboxInvoicesDataResponse' => '\\Mnm\\StructType\\GetInboxInvoicesDataResponse',
            'GetInboxInvoiceData' => '\\Mnm\\StructType\\GetInboxInvoiceData',
            'GetInboxInvoiceDataResponse' => '\\Mnm\\StructType\\GetInboxInvoiceDataResponse',
            'QueryOutboxInvoiceStatus' => '\\Mnm\\StructType\\QueryOutboxInvoiceStatus',
            'QueryOutboxInvoiceStatusResponse' => '\\Mnm\\StructType\\QueryOutboxInvoiceStatusResponse',
            'QueryInvoiceGtbResponses' => '\\Mnm\\StructType\\QueryInvoiceGtbResponses',
            'QueryInvoiceGtbResponsesResponse' => '\\Mnm\\StructType\\QueryInvoiceGtbResponsesResponse',
            'InvoiceGtbInfoResponse' => '\\Mnm\\StructType\\InvoiceGtbInfoResponse',
            'InvoiceExportGtbInformation' => '\\Mnm\\StructType\\InvoiceExportGtbInformation',
            'SaveAsDraft' => '\\Mnm\\StructType\\SaveAsDraft',
            'ArrayOfInvoiceInfo' => '\\Mnm\\ArrayType\\ArrayOfInvoiceInfo',
            'SaveAsDraftResponse' => '\\Mnm\\StructType\\SaveAsDraftResponse',
            'InvoiceIdentitiesResponse' => '\\Mnm\\StructType\\InvoiceIdentitiesResponse',
            'InvoiceIdentity' => '\\Mnm\\StructType\\InvoiceIdentity',
            'SendInvoice' => '\\Mnm\\StructType\\SendInvoice',
            'SendInvoiceResponse' => '\\Mnm\\StructType\\SendInvoiceResponse',
            'CompressedSaveAsDraft' => '\\Mnm\\StructType\\CompressedSaveAsDraft',
            'BinaryRequestData' => '\\Mnm\\StructType\\BinaryRequestData',
            'CompressedSaveAsDraftResponse' => '\\Mnm\\StructType\\CompressedSaveAsDraftResponse',
            'CompressedSendInvoice' => '\\Mnm\\StructType\\CompressedSendInvoice',
            'CompressedSendInvoiceResponse' => '\\Mnm\\StructType\\CompressedSendInvoiceResponse',
            'SendDraft' => '\\Mnm\\StructType\\SendDraft',
            'SendDraftResponse' => '\\Mnm\\StructType\\SendDraftResponse',
            'CancelDraft' => '\\Mnm\\StructType\\CancelDraft',
            'CancelDraftResponse' => '\\Mnm\\StructType\\CancelDraftResponse',
            'GetInboxInvoiceView' => '\\Mnm\\StructType\\GetInboxInvoiceView',
            'GetInboxInvoiceViewResponse' => '\\Mnm\\StructType\\GetInboxInvoiceViewResponse',
            'InvoiceViewResponse' => '\\Mnm\\StructType\\InvoiceViewResponse',
            'ViewResult' => '\\Mnm\\StructType\\ViewResult',
            'VerificationResult' => '\\Mnm\\StructType\\VerificationResult',
            'GetOutboxInvoiceView' => '\\Mnm\\StructType\\GetOutboxInvoiceView',
            'GetOutboxInvoiceViewResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceViewResponse',
            'GetOutboxInvoiceResponseView' => '\\Mnm\\StructType\\GetOutboxInvoiceResponseView',
            'GetOutboxInvoiceResponseViewResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceResponseViewResponse',
            'GetInboxInvoiceStatusWithLogs' => '\\Mnm\\StructType\\GetInboxInvoiceStatusWithLogs',
            'GetInboxInvoiceStatusWithLogsResponse' => '\\Mnm\\StructType\\GetInboxInvoiceStatusWithLogsResponse',
            'InvoiceStatusWithLogResponse' => '\\Mnm\\StructType\\InvoiceStatusWithLogResponse',
            'InvoiceStatusWithLogInfo' => '\\Mnm\\StructType\\InvoiceStatusWithLogInfo',
            'InvoiceLogItem' => '\\Mnm\\StructType\\InvoiceLogItem',
            'LogRecordItem' => '\\Mnm\\StructType\\LogRecordItem',
            'GetOutboxInvoiceStatusWithLogs' => '\\Mnm\\StructType\\GetOutboxInvoiceStatusWithLogs',
            'GetOutboxInvoiceStatusWithLogsResponse' => '\\Mnm\\StructType\\GetOutboxInvoiceStatusWithLogsResponse',
            'RetrySendInvoices' => '\\Mnm\\StructType\\RetrySendInvoices',
            'RetrySendInvoicesResponse' => '\\Mnm\\StructType\\RetrySendInvoicesResponse',
            'CloneInvoices' => '\\Mnm\\StructType\\CloneInvoices',
            'CloneInvoicesResponse' => '\\Mnm\\StructType\\CloneInvoicesResponse',
            'CloneInvoiceServiceResponse' => '\\Mnm\\StructType\\CloneInvoiceServiceResponse',
            'ClonedInvoiceInfo' => '\\Mnm\\StructType\\ClonedInvoiceInfo',
            'CancelEArchiveInvoice' => '\\Mnm\\StructType\\CancelEArchiveInvoice',
            'EArchiveCancelInvoiceContext' => '\\Mnm\\StructType\\EArchiveCancelInvoiceContext',
            'CancelEArchiveInvoiceResponse' => '\\Mnm\\StructType\\CancelEArchiveInvoiceResponse',
            'GetInboxInvoicePdf' => '\\Mnm\\StructType\\GetInboxInvoicePdf',
            'GetInboxInvoicePdfResponse' => '\\Mnm\\StructType\\GetInboxInvoicePdfResponse',
            'GetOutboxInvoicePdf' => '\\Mnm\\StructType\\GetOutboxInvoicePdf',
            'GetOutboxInvoicePdfResponse' => '\\Mnm\\StructType\\GetOutboxInvoicePdfResponse',
            'ChangeInvoiceArchiveStatus' => '\\Mnm\\StructType\\ChangeInvoiceArchiveStatus',
            'ChangeInvoiceArchiveStatusResponse' => '\\Mnm\\StructType\\ChangeInvoiceArchiveStatusResponse',
            'GetSystemUsersCompressedList' => '\\Mnm\\StructType\\GetSystemUsersCompressedList',
            'GetSystemUsersCompressedListResponse' => '\\Mnm\\StructType\\GetSystemUsersCompressedListResponse',
            'ByteArrayResponse' => '\\Mnm\\StructType\\ByteArrayResponse',
            'GetSystemUsersCompressedListOld' => '\\Mnm\\StructType\\GetSystemUsersCompressedListOld',
            'GetSystemUsersCompressedListOldResponse' => '\\Mnm\\StructType\\GetSystemUsersCompressedListOldResponse',
            'ImportExistingInvoice' => '\\Mnm\\StructType\\ImportExistingInvoice',
            'FileUploadRequest' => '\\Mnm\\StructType\\FileUploadRequest',
            'ImportExistingInvoiceResponse' => '\\Mnm\\StructType\\ImportExistingInvoiceResponse',
            'QueueInvoiceNotification' => '\\Mnm\\StructType\\QueueInvoiceNotification',
            'QueueInvoiceNotificationRequest' => '\\Mnm\\StructType\\QueueInvoiceNotificationRequest',
            'QueueInvoiceNotificationResponse' => '\\Mnm\\StructType\\QueueInvoiceNotificationResponse',
            'GetInvoiceEnvelope' => '\\Mnm\\StructType\\GetInvoiceEnvelope',
            'GetInvoiceEnvelopeResponse' => '\\Mnm\\StructType\\GetInvoiceEnvelopeResponse',
            'EnvelopeResponse' => '\\Mnm\\StructType\\EnvelopeResponse',
            'ResponseOfEnvelopeData' => '\\Mnm\\StructType\\ResponseOfEnvelopeData',
            'EnvelopeData' => '\\Mnm\\StructType\\EnvelopeData',
            'TestConnection' => '\\Mnm\\StructType\\TestConnection',
            'TestConnectionResponse' => '\\Mnm\\StructType\\TestConnectionResponse',
            'GetSummaryReport' => '\\Mnm\\StructType\\GetSummaryReport',
            'GetSummaryReportResponse' => '\\Mnm\\StructType\\GetSummaryReportResponse',
            'SummaryReportResponse' => '\\Mnm\\StructType\\SummaryReportResponse',
            'CustomerSummaryUsageReport' => '\\Mnm\\StructType\\CustomerSummaryUsageReport',
            'Last10DaysReport' => '\\Mnm\\StructType\\Last10DaysReport',
            'MonthlyReportItem' => '\\Mnm\\StructType\\MonthlyReportItem',
            'WhoAmI' => '\\Mnm\\StructType\\WhoAmI',
            'WhoAmIResponse' => '\\Mnm\\StructType\\WhoAmIResponse',
            'ResponseOfWhoAmIInfo' => '\\Mnm\\StructType\\ResponseOfWhoAmIInfo',
            'WhoAmIInfo' => '\\Mnm\\StructType\\WhoAmIInfo',
            'UserShortInfo' => '\\Mnm\\StructType\\UserShortInfo',
            'CustomerWithoutServiceInformation' => '\\Mnm\\StructType\\CustomerWithoutServiceInformation',
            'ReferencedSignatureIDType' => '\\Mnm\\StructType\\ReferencedSignatureIDType',
        );
    }
}
