<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureType StructType
 * @subpackage Structs
 */
class TemperatureType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q189:AttributeID
     * @var \Mnm\StructType\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q190:Measure
     * @var \Mnm\StructType\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q191:Description
     * @var \Mnm\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for TemperatureType
     * @uses TemperatureType::setAttributeID()
     * @uses TemperatureType::setMeasure()
     * @uses TemperatureType::setDescription()
     * @param \Mnm\StructType\AttributeIDType $attributeID
     * @param \Mnm\StructType\MeasureType $measure
     * @param \Mnm\StructType\DescriptionType[] $description
     */
    public function __construct(\Mnm\StructType\AttributeIDType $attributeID = null, \Mnm\StructType\MeasureType $measure = null, array $description = array())
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description);
    }
    /**
     * Get AttributeID value
     * @return \Mnm\StructType\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Mnm\StructType\AttributeIDType $attributeID
     * @return \Mnm\StructType\TemperatureType
     */
    public function setAttributeID(\Mnm\StructType\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Mnm\StructType\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Mnm\StructType\MeasureType $measure
     * @return \Mnm\StructType\TemperatureType
     */
    public function setMeasure(\Mnm\StructType\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Mnm\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\StructType\DescriptionType[] $description
     * @return \Mnm\StructType\TemperatureType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DescriptionType $item
     * @return \Mnm\StructType\TemperatureType
     */
    public function addToDescription(\Mnm\StructType\DescriptionType $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\TemperatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
