<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q81:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The SignatoryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $SignatoryParty;
    /**
     * The DigitalSignatureAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AttachmentType
     */
    public $DigitalSignatureAttachment;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @uses SignatureType::setID_1()
     * @uses SignatureType::setSignatoryParty()
     * @uses SignatureType::setDigitalSignatureAttachment()
     * @param \Mnm\StructType\SignedInfoType $signedInfo
     * @param \Mnm\StructType\SignatureValueType $signatureValue
     * @param \Mnm\StructType\KeyInfoType $keyInfo
     * @param \Mnm\StructType\ObjectType[] $object
     * @param string $id
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\PartyType $signatoryParty
     * @param \Mnm\StructType\AttachmentType $digitalSignatureAttachment
     */
    public function __construct(\Mnm\StructType\SignedInfoType $signedInfo = null, \Mnm\StructType\SignatureValueType $signatureValue = null, \Mnm\StructType\KeyInfoType $keyInfo = null, array $object = array(), $id = null, \Mnm\StructType\IDType $iD_1 = null, \Mnm\StructType\PartyType $signatoryParty = null, \Mnm\StructType\AttachmentType $digitalSignatureAttachment = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id)
            ->setID_1($iD_1)
            ->setSignatoryParty($signatoryParty)
            ->setDigitalSignatureAttachment($digitalSignatureAttachment);
    }
    /**
     * Get SignedInfo value
     * @return \Mnm\StructType\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Mnm\StructType\SignedInfoType $signedInfo
     * @return \Mnm\StructType\SignatureType
     */
    public function setSignedInfo(\Mnm\StructType\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Mnm\StructType\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Mnm\StructType\SignatureValueType $signatureValue
     * @return \Mnm\StructType\SignatureType
     */
    public function setSignatureValue(\Mnm\StructType\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Mnm\StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Mnm\StructType\KeyInfoType $keyInfo
     * @return \Mnm\StructType\SignatureType
     */
    public function setKeyInfo(\Mnm\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Mnm\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \Mnm\StructType\ObjectType[] $object
     * @return \Mnm\StructType\SignatureType
     */
    public function setObject(array $object = array())
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\ObjectType $item
     * @return \Mnm\StructType\SignatureType
     */
    public function addToObject(\Mnm\StructType\ObjectType $item)
    {
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Mnm\StructType\SignatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\SignatureType
     */
    public function setID_1(\Mnm\StructType\IDType $iD_1 = null)
    {
        $this->ID = $iD_1;
        return $this;
    }
    /**
     * Get SignatoryParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getSignatoryParty()
    {
        return $this->SignatoryParty;
    }
    /**
     * Set SignatoryParty value
     * @param \Mnm\StructType\PartyType $signatoryParty
     * @return \Mnm\StructType\SignatureType
     */
    public function setSignatoryParty(\Mnm\StructType\PartyType $signatoryParty = null)
    {
        $this->SignatoryParty = $signatoryParty;
        return $this;
    }
    /**
     * Get DigitalSignatureAttachment value
     * @return \Mnm\StructType\AttachmentType|null
     */
    public function getDigitalSignatureAttachment()
    {
        return $this->DigitalSignatureAttachment;
    }
    /**
     * Set DigitalSignatureAttachment value
     * @param \Mnm\StructType\AttachmentType $digitalSignatureAttachment
     * @return \Mnm\StructType\SignatureType
     */
    public function setDigitalSignatureAttachment(\Mnm\StructType\AttachmentType $digitalSignatureAttachment = null)
    {
        $this->DigitalSignatureAttachment = $digitalSignatureAttachment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
