<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q192:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q193:TransportModeCode
     * @var \Mnm\StructType\TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q194:TransportMeansTypeCode
     * @var \Mnm\StructType\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q195:TransitDirectionCode
     * @var \Mnm\StructType\TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q196:Instructions
     * @var \Mnm\StructType\InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\PersonType[]
     */
    public $DriverPerson;
    /**
     * Constructor method for ShipmentStageType
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\TransportModeCodeType $transportModeCode
     * @param \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Mnm\StructType\TransitDirectionCodeType $transitDirectionCode
     * @param \Mnm\StructType\InstructionsType[] $instructions
     * @param \Mnm\StructType\PeriodType $transitPeriod
     * @param \Mnm\StructType\TransportMeansType $transportMeans
     * @param \Mnm\StructType\PersonType[] $driverPerson
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\TransportModeCodeType $transportModeCode = null, \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Mnm\StructType\TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), \Mnm\StructType\PeriodType $transitPeriod = null, \Mnm\StructType\TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return \Mnm\StructType\TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param \Mnm\StructType\TransportModeCodeType $transportModeCode
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setTransportModeCode(\Mnm\StructType\TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Mnm\StructType\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setTransportMeansTypeCode(\Mnm\StructType\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TransitDirectionCode value
     * @return \Mnm\StructType\TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }
    /**
     * Set TransitDirectionCode value
     * @param \Mnm\StructType\TransitDirectionCodeType $transitDirectionCode
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setTransitDirectionCode(\Mnm\StructType\TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Mnm\StructType\InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * Set Instructions value
     * @param \Mnm\StructType\InstructionsType[] $instructions
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setInstructions(array $instructions = array())
    {
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Add item to Instructions value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\InstructionsType $item
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function addToInstructions(\Mnm\StructType\InstructionsType $item)
    {
        $this->Instructions[] = $item;
        return $this;
    }
    /**
     * Get TransitPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }
    /**
     * Set TransitPeriod value
     * @param \Mnm\StructType\PeriodType $transitPeriod
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setTransitPeriod(\Mnm\StructType\PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Mnm\StructType\TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Mnm\StructType\TransportMeansType $transportMeans
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setTransportMeans(\Mnm\StructType\TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Get DriverPerson value
     * @return \Mnm\StructType\PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }
    /**
     * Set DriverPerson value
     * @param \Mnm\StructType\PersonType[] $driverPerson
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        $this->DriverPerson = $driverPerson;
        return $this;
    }
    /**
     * Add item to DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\PersonType $item
     * @return \Mnm\StructType\ShipmentStageType
     */
    public function addToDriverPerson(\Mnm\StructType\PersonType $item)
    {
        $this->DriverPerson[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\ShipmentStageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
