<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceInformation StructType
 * @subpackage Structs
 */
class EArchiveInvoiceInformation extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryType;
    /**
     * The NewGenerationPamentRecorderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\NewGenerationPaymentRecorderInformation
     */
    public $NewGenerationPamentRecorderInfo;
    /**
     * The InternetSalesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\InternetSalesInformation
     */
    public $InternetSalesInfo;
    /**
     * The WithHoldings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\EArchiveWithHoldingInformation[]
     */
    public $WithHoldings;
    /**
     * Constructor method for EArchiveInvoiceInformation
     * @uses EArchiveInvoiceInformation::setDeliveryType()
     * @uses EArchiveInvoiceInformation::setNewGenerationPamentRecorderInfo()
     * @uses EArchiveInvoiceInformation::setInternetSalesInfo()
     * @uses EArchiveInvoiceInformation::setWithHoldings()
     * @param string $deliveryType
     * @param \Mnm\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @param \Mnm\StructType\InternetSalesInformation $internetSalesInfo
     * @param \Mnm\StructType\EArchiveWithHoldingInformation[] $withHoldings
     */
    public function __construct($deliveryType = null, \Mnm\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null, \Mnm\StructType\InternetSalesInformation $internetSalesInfo = null, array $withHoldings = array())
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setNewGenerationPamentRecorderInfo($newGenerationPamentRecorderInfo)
            ->setInternetSalesInfo($internetSalesInfo)
            ->setWithHoldings($withHoldings);
    }
    /**
     * Get DeliveryType value
     * @return string
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public function setDeliveryType($deliveryType = null)
    {
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get NewGenerationPamentRecorderInfo value
     * @return \Mnm\StructType\NewGenerationPaymentRecorderInformation|null
     */
    public function getNewGenerationPamentRecorderInfo()
    {
        return $this->NewGenerationPamentRecorderInfo;
    }
    /**
     * Set NewGenerationPamentRecorderInfo value
     * @param \Mnm\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public function setNewGenerationPamentRecorderInfo(\Mnm\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null)
    {
        $this->NewGenerationPamentRecorderInfo = $newGenerationPamentRecorderInfo;
        return $this;
    }
    /**
     * Get InternetSalesInfo value
     * @return \Mnm\StructType\InternetSalesInformation|null
     */
    public function getInternetSalesInfo()
    {
        return $this->InternetSalesInfo;
    }
    /**
     * Set InternetSalesInfo value
     * @param \Mnm\StructType\InternetSalesInformation $internetSalesInfo
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public function setInternetSalesInfo(\Mnm\StructType\InternetSalesInformation $internetSalesInfo = null)
    {
        $this->InternetSalesInfo = $internetSalesInfo;
        return $this;
    }
    /**
     * Get WithHoldings value
     * @return \Mnm\StructType\EArchiveWithHoldingInformation[]|null
     */
    public function getWithHoldings()
    {
        return $this->WithHoldings;
    }
    /**
     * Set WithHoldings value
     * @param \Mnm\StructType\EArchiveWithHoldingInformation[] $withHoldings
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public function setWithHoldings(array $withHoldings = array())
    {
        $this->WithHoldings = $withHoldings;
        return $this;
    }
    /**
     * Add item to WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\EArchiveWithHoldingInformation $item
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public function addToWithHoldings(\Mnm\StructType\EArchiveWithHoldingInformation $item)
    {
        $this->WithHoldings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\EArchiveInvoiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
