<?php

namespace Mnm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q82:ID
     * @var \Mnm\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q83:Quantity
     * @var \Mnm\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q84:ActualDeliveryDate
     * @var \Mnm\StructType\ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q85:ActualDeliveryTime
     * @var \Mnm\StructType\ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q86:LatestDeliveryDate
     * @var \Mnm\StructType\LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q87:LatestDeliveryTime
     * @var \Mnm\StructType\LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q88:TrackingID
     * @var \Mnm\StructType\TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StructType\ShipmentType
     */
    public $Shipment;
    /**
     * Constructor method for DeliveryType
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     * @param \Mnm\StructType\IDType $iD
     * @param \Mnm\StructType\QuantityType $quantity
     * @param \Mnm\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @param \Mnm\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @param \Mnm\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @param \Mnm\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @param \Mnm\StructType\TrackingIDType $trackingID
     * @param \Mnm\StructType\AddressType $deliveryAddress
     * @param \Mnm\StructType\LocationType $alternativeDeliveryLocation
     * @param \Mnm\StructType\PeriodType $estimatedDeliveryPeriod
     * @param \Mnm\StructType\PartyType $carrierParty
     * @param \Mnm\StructType\PartyType $deliveryParty
     * @param \Mnm\StructType\DespatchType $despatch
     * @param \Mnm\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \Mnm\StructType\ShipmentType $shipment
     */
    public function __construct(\Mnm\StructType\IDType $iD = null, \Mnm\StructType\QuantityType $quantity = null, \Mnm\StructType\ActualDeliveryDateType $actualDeliveryDate = null, \Mnm\StructType\ActualDeliveryTimeType $actualDeliveryTime = null, \Mnm\StructType\LatestDeliveryDateType $latestDeliveryDate = null, \Mnm\StructType\LatestDeliveryTimeType $latestDeliveryTime = null, \Mnm\StructType\TrackingIDType $trackingID = null, \Mnm\StructType\AddressType $deliveryAddress = null, \Mnm\StructType\LocationType $alternativeDeliveryLocation = null, \Mnm\StructType\PeriodType $estimatedDeliveryPeriod = null, \Mnm\StructType\PartyType $carrierParty = null, \Mnm\StructType\PartyType $deliveryParty = null, \Mnm\StructType\DespatchType $despatch = null, array $deliveryTerms = array(), \Mnm\StructType\ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }
    /**
     * Get ID value
     * @return \Mnm\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\StructType\IDType $iD
     * @return \Mnm\StructType\DeliveryType
     */
    public function setID(\Mnm\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\StructType\QuantityType $quantity
     * @return \Mnm\StructType\DeliveryType
     */
    public function setQuantity(\Mnm\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualDeliveryDate value
     * @return \Mnm\StructType\ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }
    /**
     * Set ActualDeliveryDate value
     * @param \Mnm\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @return \Mnm\StructType\DeliveryType
     */
    public function setActualDeliveryDate(\Mnm\StructType\ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get ActualDeliveryTime value
     * @return \Mnm\StructType\ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }
    /**
     * Set ActualDeliveryTime value
     * @param \Mnm\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @return \Mnm\StructType\DeliveryType
     */
    public function setActualDeliveryTime(\Mnm\StructType\ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }
    /**
     * Get LatestDeliveryDate value
     * @return \Mnm\StructType\LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }
    /**
     * Set LatestDeliveryDate value
     * @param \Mnm\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @return \Mnm\StructType\DeliveryType
     */
    public function setLatestDeliveryDate(\Mnm\StructType\LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get LatestDeliveryTime value
     * @return \Mnm\StructType\LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }
    /**
     * Set LatestDeliveryTime value
     * @param \Mnm\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @return \Mnm\StructType\DeliveryType
     */
    public function setLatestDeliveryTime(\Mnm\StructType\LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \Mnm\StructType\TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \Mnm\StructType\TrackingIDType $trackingID
     * @return \Mnm\StructType\DeliveryType
     */
    public function setTrackingID(\Mnm\StructType\TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \Mnm\StructType\AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \Mnm\StructType\AddressType $deliveryAddress
     * @return \Mnm\StructType\DeliveryType
     */
    public function setDeliveryAddress(\Mnm\StructType\AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * @return \Mnm\StructType\LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * @param \Mnm\StructType\LocationType $alternativeDeliveryLocation
     * @return \Mnm\StructType\DeliveryType
     */
    public function setAlternativeDeliveryLocation(\Mnm\StructType\LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * @return \Mnm\StructType\PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * @param \Mnm\StructType\PeriodType $estimatedDeliveryPeriod
     * @return \Mnm\StructType\DeliveryType
     */
    public function setEstimatedDeliveryPeriod(\Mnm\StructType\PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }
    /**
     * Get CarrierParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }
    /**
     * Set CarrierParty value
     * @param \Mnm\StructType\PartyType $carrierParty
     * @return \Mnm\StructType\DeliveryType
     */
    public function setCarrierParty(\Mnm\StructType\PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }
    /**
     * Get DeliveryParty value
     * @return \Mnm\StructType\PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }
    /**
     * Set DeliveryParty value
     * @param \Mnm\StructType\PartyType $deliveryParty
     * @return \Mnm\StructType\DeliveryType
     */
    public function setDeliveryParty(\Mnm\StructType\PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }
    /**
     * Get Despatch value
     * @return \Mnm\StructType\DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }
    /**
     * Set Despatch value
     * @param \Mnm\StructType\DespatchType $despatch
     * @return \Mnm\StructType\DeliveryType
     */
    public function setDespatch(\Mnm\StructType\DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \Mnm\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @param \Mnm\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \Mnm\StructType\DeliveryType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Mnm\StructType\DeliveryTermsType $item
     * @return \Mnm\StructType\DeliveryType
     */
    public function addToDeliveryTerms(\Mnm\StructType\DeliveryTermsType $item)
    {
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Mnm\StructType\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Mnm\StructType\ShipmentType $shipment
     * @return \Mnm\StructType\DeliveryType
     */
    public function setShipment(\Mnm\StructType\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\StructType\DeliveryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
