<?php

namespace Mnm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryOutboxInvoiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Mnm\StructType\QueryOutboxInvoiceStatus $parameters
     * @return \Mnm\StructType\QueryOutboxInvoiceStatusResponse|bool
     */
    public function QueryOutboxInvoiceStatus(\Mnm\StructType\QueryOutboxInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryOutboxInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Mnm\StructType\QueryOutboxInvoiceStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
