<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509DataType StructType
 * @subpackage Structs
 */
class X509DataType extends AbstractStructBase
{
    /**
     * The X509Certificate
     * Meta information extracted from the WSDL
     * - choice: X509Certificate | X509SKI | X509CRL | X509IssuerSerial | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $X509Certificate;
    /**
     * The X509SKI
     * Meta information extracted from the WSDL
     * - choice: X509Certificate | X509SKI | X509CRL | X509IssuerSerial | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $X509SKI;
    /**
     * The X509CRL
     * Meta information extracted from the WSDL
     * - choice: X509Certificate | X509SKI | X509CRL | X509IssuerSerial | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $X509CRL;
    /**
     * The X509IssuerSerial
     * Meta information extracted from the WSDL
     * - choice: X509Certificate | X509SKI | X509CRL | X509IssuerSerial | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\X509IssuerSerialType
     */
    public $X509IssuerSerial;
    /**
     * The X509SubjectName
     * Meta information extracted from the WSDL
     * - choice: X509Certificate | X509SKI | X509CRL | X509IssuerSerial | X509SubjectName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $X509SubjectName;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for X509DataType
     * @uses X509DataType::setX509Certificate()
     * @uses X509DataType::setX509SKI()
     * @uses X509DataType::setX509CRL()
     * @uses X509DataType::setX509IssuerSerial()
     * @uses X509DataType::setX509SubjectName()
     * @uses X509DataType::setAny()
     * @param string $x509Certificate
     * @param string $x509SKI
     * @param string $x509CRL
     * @param \Mnm\X509IssuerSerialType $x509IssuerSerial
     * @param string $x509SubjectName
     * @param \DOMDocument $any
     */
    public function __construct($x509Certificate = null, $x509SKI = null, $x509CRL = null, \Mnm\X509IssuerSerialType $x509IssuerSerial = null, $x509SubjectName = null, \DOMDocument $any = null)
    {
        $this
            ->setX509Certificate($x509Certificate)
            ->setX509SKI($x509SKI)
            ->setX509CRL($x509CRL)
            ->setX509IssuerSerial($x509IssuerSerial)
            ->setX509SubjectName($x509SubjectName)
            ->setAny($any);
    }
    /**
     * Get X509Certificate value
     * @return string|null
     */
    public function getX509Certificate()
    {
        return isset($this->X509Certificate) ? $this->X509Certificate : null;
    }
    /**
     * Set X509Certificate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $x509Certificate
     * @return \Mnm\X509DataType
     */
    public function setX509Certificate($x509Certificate = null)
    {
        if (is_null($x509Certificate) || (is_array($x509Certificate) && empty($x509Certificate))) {
            unset($this->X509Certificate);
        } else {
            $this->X509Certificate = $x509Certificate;
        }
        return $this;
    }
    /**
     * Get X509SKI value
     * @return string|null
     */
    public function getX509SKI()
    {
        return isset($this->X509SKI) ? $this->X509SKI : null;
    }
    /**
     * Set X509SKI value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $x509SKI
     * @return \Mnm\X509DataType
     */
    public function setX509SKI($x509SKI = null)
    {
        if (is_null($x509SKI) || (is_array($x509SKI) && empty($x509SKI))) {
            unset($this->X509SKI);
        } else {
            $this->X509SKI = $x509SKI;
        }
        return $this;
    }
    /**
     * Get X509CRL value
     * @return string|null
     */
    public function getX509CRL()
    {
        return isset($this->X509CRL) ? $this->X509CRL : null;
    }
    /**
     * Set X509CRL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $x509CRL
     * @return \Mnm\X509DataType
     */
    public function setX509CRL($x509CRL = null)
    {
        if (is_null($x509CRL) || (is_array($x509CRL) && empty($x509CRL))) {
            unset($this->X509CRL);
        } else {
            $this->X509CRL = $x509CRL;
        }
        return $this;
    }
    /**
     * Get X509IssuerSerial value
     * @return \Mnm\X509IssuerSerialType|null
     */
    public function getX509IssuerSerial()
    {
        return isset($this->X509IssuerSerial) ? $this->X509IssuerSerial : null;
    }
    /**
     * Set X509IssuerSerial value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\X509IssuerSerialType $x509IssuerSerial
     * @return \Mnm\X509DataType
     */
    public function setX509IssuerSerial(\Mnm\X509IssuerSerialType $x509IssuerSerial = null)
    {
        if (is_null($x509IssuerSerial) || (is_array($x509IssuerSerial) && empty($x509IssuerSerial))) {
            unset($this->X509IssuerSerial);
        } else {
            $this->X509IssuerSerial = $x509IssuerSerial;
        }
        return $this;
    }
    /**
     * Get X509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return isset($this->X509SubjectName) ? $this->X509SubjectName : null;
    }
    /**
     * Set X509SubjectName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $x509SubjectName
     * @return \Mnm\X509DataType
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        if (is_null($x509SubjectName) || (is_array($x509SubjectName) && empty($x509SubjectName))) {
            unset($this->X509SubjectName);
        } else {
            $this->X509SubjectName = $x509SubjectName;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Mnm\X509DataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\X509DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
