<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewResult StructType
 * @subpackage Structs
 */
class ViewResult extends AbstractStructBase
{
    /**
     * The IsUsingDefaultXslt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsUsingDefaultXslt;
    /**
     * The Html
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Html;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\VerificationResult
     */
    public $Verification;
    /**
     * Constructor method for ViewResult
     * @uses ViewResult::setIsUsingDefaultXslt()
     * @uses ViewResult::setHtml()
     * @uses ViewResult::setVerification()
     * @param bool $isUsingDefaultXslt
     * @param string $html
     * @param \Mnm\VerificationResult $verification
     */
    public function __construct($isUsingDefaultXslt = null, $html = null, \Mnm\VerificationResult $verification = null)
    {
        $this
            ->setIsUsingDefaultXslt($isUsingDefaultXslt)
            ->setHtml($html)
            ->setVerification($verification);
    }
    /**
     * Get IsUsingDefaultXslt value
     * @return bool
     */
    public function getIsUsingDefaultXslt()
    {
        return $this->IsUsingDefaultXslt;
    }
    /**
     * Set IsUsingDefaultXslt value
     * @param bool $isUsingDefaultXslt
     * @return \Mnm\ViewResult
     */
    public function setIsUsingDefaultXslt($isUsingDefaultXslt = null)
    {
        $this->IsUsingDefaultXslt = $isUsingDefaultXslt;
        return $this;
    }
    /**
     * Get Html value
     * @return string|null
     */
    public function getHtml()
    {
        return $this->Html;
    }
    /**
     * Set Html value
     * @param string $html
     * @return \Mnm\ViewResult
     */
    public function setHtml($html = null)
    {
        $this->Html = $html;
        return $this;
    }
    /**
     * Get Verification value
     * @return \Mnm\VerificationResult|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \Mnm\VerificationResult $verification
     * @return \Mnm\ViewResult
     */
    public function setVerification(\Mnm\VerificationResult $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ViewResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
