<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationResult StructType
 * @subpackage Structs
 */
class VerificationResult extends AbstractStructBase
{
    /**
     * The SigningDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SigningDate;
    /**
     * The IsVerified
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsVerified;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * Constructor method for VerificationResult
     * @uses VerificationResult::setSigningDate()
     * @uses VerificationResult::setIsVerified()
     * @uses VerificationResult::setData()
     * @param string $signingDate
     * @param bool $isVerified
     * @param string $data
     */
    public function __construct($signingDate = null, $isVerified = null, $data = null)
    {
        $this
            ->setSigningDate($signingDate)
            ->setIsVerified($isVerified)
            ->setData($data);
    }
    /**
     * Get SigningDate value
     * @return string
     */
    public function getSigningDate()
    {
        return $this->SigningDate;
    }
    /**
     * Set SigningDate value
     * @param string $signingDate
     * @return \Mnm\VerificationResult
     */
    public function setSigningDate($signingDate = null)
    {
        $this->SigningDate = $signingDate;
        return $this;
    }
    /**
     * Get IsVerified value
     * @return bool
     */
    public function getIsVerified()
    {
        return $this->IsVerified;
    }
    /**
     * Set IsVerified value
     * @param bool $isVerified
     * @return \Mnm\VerificationResult
     */
    public function setIsVerified($isVerified = null)
    {
        $this->IsVerified = $isVerified;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Mnm\VerificationResult
     */
    public function setData($data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\VerificationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
