<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotalType StructType
 * @subpackage Structs
 */
class TaxSubtotalType extends AbstractStructBase
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q178:TaxableAmount
     * @var \Mnm\TaxableAmountType
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q179:TaxAmount
     * @var \Mnm\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The CalculationSequenceNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q180:CalculationSequenceNumeric
     * @var \Mnm\CalculationSequenceNumericType
     */
    public $CalculationSequenceNumeric;
    /**
     * The TransactionCurrencyTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q181:TransactionCurrencyTaxAmount
     * @var \Mnm\TransactionCurrencyTaxAmountType
     */
    public $TransactionCurrencyTaxAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q182:Percent
     * @var \Mnm\PercentType
     */
    public $Percent;
    /**
     * The BaseUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q183:BaseUnitMeasure
     * @var \Mnm\BaseUnitMeasureType
     */
    public $BaseUnitMeasure;
    /**
     * The PerUnitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q184:PerUnitAmount
     * @var \Mnm\PerUnitAmountType
     */
    public $PerUnitAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TaxCategoryType
     */
    public $TaxCategory;
    /**
     * Constructor method for TaxSubtotalType
     * @uses TaxSubtotalType::setTaxableAmount()
     * @uses TaxSubtotalType::setTaxAmount()
     * @uses TaxSubtotalType::setCalculationSequenceNumeric()
     * @uses TaxSubtotalType::setTransactionCurrencyTaxAmount()
     * @uses TaxSubtotalType::setPercent()
     * @uses TaxSubtotalType::setBaseUnitMeasure()
     * @uses TaxSubtotalType::setPerUnitAmount()
     * @uses TaxSubtotalType::setTaxCategory()
     * @param \Mnm\TaxableAmountType $taxableAmount
     * @param \Mnm\TaxAmountType $taxAmount
     * @param \Mnm\CalculationSequenceNumericType $calculationSequenceNumeric
     * @param \Mnm\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @param \Mnm\PercentType $percent
     * @param \Mnm\BaseUnitMeasureType $baseUnitMeasure
     * @param \Mnm\PerUnitAmountType $perUnitAmount
     * @param \Mnm\TaxCategoryType $taxCategory
     */
    public function __construct(\Mnm\TaxableAmountType $taxableAmount = null, \Mnm\TaxAmountType $taxAmount = null, \Mnm\CalculationSequenceNumericType $calculationSequenceNumeric = null, \Mnm\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null, \Mnm\PercentType $percent = null, \Mnm\BaseUnitMeasureType $baseUnitMeasure = null, \Mnm\PerUnitAmountType $perUnitAmount = null, \Mnm\TaxCategoryType $taxCategory = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setCalculationSequenceNumeric($calculationSequenceNumeric)
            ->setTransactionCurrencyTaxAmount($transactionCurrencyTaxAmount)
            ->setPercent($percent)
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setPerUnitAmount($perUnitAmount)
            ->setTaxCategory($taxCategory);
    }
    /**
     * Get TaxableAmount value
     * @return \Mnm\TaxableAmountType|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param \Mnm\TaxableAmountType $taxableAmount
     * @return \Mnm\TaxSubtotalType
     */
    public function setTaxableAmount(\Mnm\TaxableAmountType $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \Mnm\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \Mnm\TaxAmountType $taxAmount
     * @return \Mnm\TaxSubtotalType
     */
    public function setTaxAmount(\Mnm\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get CalculationSequenceNumeric value
     * @return \Mnm\CalculationSequenceNumericType|null
     */
    public function getCalculationSequenceNumeric()
    {
        return $this->CalculationSequenceNumeric;
    }
    /**
     * Set CalculationSequenceNumeric value
     * @param \Mnm\CalculationSequenceNumericType $calculationSequenceNumeric
     * @return \Mnm\TaxSubtotalType
     */
    public function setCalculationSequenceNumeric(\Mnm\CalculationSequenceNumericType $calculationSequenceNumeric = null)
    {
        $this->CalculationSequenceNumeric = $calculationSequenceNumeric;
        return $this;
    }
    /**
     * Get TransactionCurrencyTaxAmount value
     * @return \Mnm\TransactionCurrencyTaxAmountType|null
     */
    public function getTransactionCurrencyTaxAmount()
    {
        return $this->TransactionCurrencyTaxAmount;
    }
    /**
     * Set TransactionCurrencyTaxAmount value
     * @param \Mnm\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @return \Mnm\TaxSubtotalType
     */
    public function setTransactionCurrencyTaxAmount(\Mnm\TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null)
    {
        $this->TransactionCurrencyTaxAmount = $transactionCurrencyTaxAmount;
        return $this;
    }
    /**
     * Get Percent value
     * @return \Mnm\PercentType|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param \Mnm\PercentType $percent
     * @return \Mnm\TaxSubtotalType
     */
    public function setPercent(\Mnm\PercentType $percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get BaseUnitMeasure value
     * @return \Mnm\BaseUnitMeasureType|null
     */
    public function getBaseUnitMeasure()
    {
        return $this->BaseUnitMeasure;
    }
    /**
     * Set BaseUnitMeasure value
     * @param \Mnm\BaseUnitMeasureType $baseUnitMeasure
     * @return \Mnm\TaxSubtotalType
     */
    public function setBaseUnitMeasure(\Mnm\BaseUnitMeasureType $baseUnitMeasure = null)
    {
        $this->BaseUnitMeasure = $baseUnitMeasure;
        return $this;
    }
    /**
     * Get PerUnitAmount value
     * @return \Mnm\PerUnitAmountType|null
     */
    public function getPerUnitAmount()
    {
        return $this->PerUnitAmount;
    }
    /**
     * Set PerUnitAmount value
     * @param \Mnm\PerUnitAmountType $perUnitAmount
     * @return \Mnm\TaxSubtotalType
     */
    public function setPerUnitAmount(\Mnm\PerUnitAmountType $perUnitAmount = null)
    {
        $this->PerUnitAmount = $perUnitAmount;
        return $this;
    }
    /**
     * Get TaxCategory value
     * @return \Mnm\TaxCategoryType|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * Set TaxCategory value
     * @param \Mnm\TaxCategoryType $taxCategory
     * @return \Mnm\TaxSubtotalType
     */
    public function setTaxCategory(\Mnm\TaxCategoryType $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\TaxSubtotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
