<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q96:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q97:HandlingCode
     * @var \Mnm\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q98:HandlingInstructions
     * @var \Mnm\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q99:GrossWeightMeasure
     * @var \Mnm\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q100:NetWeightMeasure
     * @var \Mnm\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q101:GrossVolumeMeasure
     * @var \Mnm\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q102:NetVolumeMeasure
     * @var \Mnm\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q103:TotalGoodsItemQuantity
     * @var \Mnm\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q104:TotalTransportHandlingUnitQuantity
     * @var \Mnm\TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q105:InsuranceValueAmount
     * @var \Mnm\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q106:DeclaredCustomsValueAmount
     * @var \Mnm\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q107:DeclaredForCarriageValueAmount
     * @var \Mnm\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q108:DeclaredStatisticsValueAmount
     * @var \Mnm\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q109:FreeOnBoardValueAmount
     * @var \Mnm\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q110:SpecialInstructions
     * @var \Mnm\SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LocationType
     */
    public $LastExitPortLocation;
    /**
     * Constructor method for ShipmentType
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     * @param \Mnm\IDType $iD
     * @param \Mnm\HandlingCodeType $handlingCode
     * @param \Mnm\HandlingInstructionsType $handlingInstructions
     * @param \Mnm\GrossWeightMeasureType $grossWeightMeasure
     * @param \Mnm\NetWeightMeasureType $netWeightMeasure
     * @param \Mnm\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Mnm\NetVolumeMeasureType $netVolumeMeasure
     * @param \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Mnm\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param \Mnm\InsuranceValueAmountType $insuranceValueAmount
     * @param \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Mnm\SpecialInstructionsType[] $specialInstructions
     * @param \Mnm\GoodsItemType[] $goodsItem
     * @param \Mnm\ShipmentStageType[] $shipmentStage
     * @param \Mnm\DeliveryType $delivery
     * @param \Mnm\TransportHandlingUnitType[] $transportHandlingUnit
     * @param \Mnm\AddressType $returnAddress
     * @param \Mnm\LocationType $firstArrivalPortLocation
     * @param \Mnm\LocationType $lastExitPortLocation
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\HandlingCodeType $handlingCode = null, \Mnm\HandlingInstructionsType $handlingInstructions = null, \Mnm\GrossWeightMeasureType $grossWeightMeasure = null, \Mnm\NetWeightMeasureType $netWeightMeasure = null, \Mnm\GrossVolumeMeasureType $grossVolumeMeasure = null, \Mnm\NetVolumeMeasureType $netVolumeMeasure = null, \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Mnm\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, \Mnm\InsuranceValueAmountType $insuranceValueAmount = null, \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), \Mnm\DeliveryType $delivery = null, array $transportHandlingUnit = array(), \Mnm\AddressType $returnAddress = null, \Mnm\LocationType $firstArrivalPortLocation = null, \Mnm\LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\ShipmentType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Mnm\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Mnm\HandlingCodeType $handlingCode
     * @return \Mnm\ShipmentType
     */
    public function setHandlingCode(\Mnm\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Mnm\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Mnm\HandlingInstructionsType $handlingInstructions
     * @return \Mnm\ShipmentType
     */
    public function setHandlingInstructions(\Mnm\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Mnm\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Mnm\GrossWeightMeasureType $grossWeightMeasure
     * @return \Mnm\ShipmentType
     */
    public function setGrossWeightMeasure(\Mnm\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Mnm\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Mnm\NetWeightMeasureType $netWeightMeasure
     * @return \Mnm\ShipmentType
     */
    public function setNetWeightMeasure(\Mnm\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Mnm\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Mnm\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Mnm\ShipmentType
     */
    public function setGrossVolumeMeasure(\Mnm\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Mnm\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Mnm\NetVolumeMeasureType $netVolumeMeasure
     * @return \Mnm\ShipmentType
     */
    public function setNetVolumeMeasure(\Mnm\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Mnm\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Mnm\ShipmentType
     */
    public function setTotalGoodsItemQuantity(\Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return \Mnm\TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }
    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param \Mnm\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return \Mnm\ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(\Mnm\TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Mnm\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Mnm\InsuranceValueAmountType $insuranceValueAmount
     * @return \Mnm\ShipmentType
     */
    public function setInsuranceValueAmount(\Mnm\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Mnm\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Mnm\ShipmentType
     */
    public function setDeclaredCustomsValueAmount(\Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Mnm\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Mnm\ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(\Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Mnm\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Mnm\ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(\Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Mnm\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Mnm\ShipmentType
     */
    public function setFreeOnBoardValueAmount(\Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * @return \Mnm\SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }
    /**
     * Set SpecialInstructions value
     * @param \Mnm\SpecialInstructionsType[] $specialInstructions
     * @return \Mnm\ShipmentType
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }
    /**
     * Add item to SpecialInstructions value
     * @throws \InvalidArgumentException
     * @param \Mnm\SpecialInstructionsType $item
     * @return \Mnm\ShipmentType
     */
    public function addToSpecialInstructions(\Mnm\SpecialInstructionsType $item)
    {
        $this->SpecialInstructions[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Mnm\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @param \Mnm\GoodsItemType[] $goodsItem
     * @return \Mnm\ShipmentType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Mnm\GoodsItemType $item
     * @return \Mnm\ShipmentType
     */
    public function addToGoodsItem(\Mnm\GoodsItemType $item)
    {
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get ShipmentStage value
     * @return \Mnm\ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }
    /**
     * Set ShipmentStage value
     * @param \Mnm\ShipmentStageType[] $shipmentStage
     * @return \Mnm\ShipmentType
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }
    /**
     * Add item to ShipmentStage value
     * @throws \InvalidArgumentException
     * @param \Mnm\ShipmentStageType $item
     * @return \Mnm\ShipmentType
     */
    public function addToShipmentStage(\Mnm\ShipmentStageType $item)
    {
        $this->ShipmentStage[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\DeliveryType $delivery
     * @return \Mnm\ShipmentType
     */
    public function setDelivery(\Mnm\DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get TransportHandlingUnit value
     * @return \Mnm\TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }
    /**
     * Set TransportHandlingUnit value
     * @param \Mnm\TransportHandlingUnitType[] $transportHandlingUnit
     * @return \Mnm\ShipmentType
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }
    /**
     * Add item to TransportHandlingUnit value
     * @throws \InvalidArgumentException
     * @param \Mnm\TransportHandlingUnitType $item
     * @return \Mnm\ShipmentType
     */
    public function addToTransportHandlingUnit(\Mnm\TransportHandlingUnitType $item)
    {
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \Mnm\AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \Mnm\AddressType $returnAddress
     * @return \Mnm\ShipmentType
     */
    public function setReturnAddress(\Mnm\AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get FirstArrivalPortLocation value
     * @return \Mnm\LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }
    /**
     * Set FirstArrivalPortLocation value
     * @param \Mnm\LocationType $firstArrivalPortLocation
     * @return \Mnm\ShipmentType
     */
    public function setFirstArrivalPortLocation(\Mnm\LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }
    /**
     * Get LastExitPortLocation value
     * @return \Mnm\LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }
    /**
     * Set LastExitPortLocation value
     * @param \Mnm\LocationType $lastExitPortLocation
     * @return \Mnm\ShipmentType
     */
    public function setLastExitPortLocation(\Mnm\LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ShipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
