<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q192:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q193:TransportModeCode
     * @var \Mnm\TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q194:TransportMeansTypeCode
     * @var \Mnm\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q195:TransitDirectionCode
     * @var \Mnm\TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q196:Instructions
     * @var \Mnm\InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\PersonType[]
     */
    public $DriverPerson;
    /**
     * Constructor method for ShipmentStageType
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     * @param \Mnm\IDType $iD
     * @param \Mnm\TransportModeCodeType $transportModeCode
     * @param \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Mnm\TransitDirectionCodeType $transitDirectionCode
     * @param \Mnm\InstructionsType[] $instructions
     * @param \Mnm\PeriodType $transitPeriod
     * @param \Mnm\TransportMeansType $transportMeans
     * @param \Mnm\PersonType[] $driverPerson
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\TransportModeCodeType $transportModeCode = null, \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Mnm\TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), \Mnm\PeriodType $transitPeriod = null, \Mnm\TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\ShipmentStageType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportModeCode value
     * @return \Mnm\TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }
    /**
     * Set TransportModeCode value
     * @param \Mnm\TransportModeCodeType $transportModeCode
     * @return \Mnm\ShipmentStageType
     */
    public function setTransportModeCode(\Mnm\TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Mnm\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Mnm\ShipmentStageType
     */
    public function setTransportMeansTypeCode(\Mnm\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TransitDirectionCode value
     * @return \Mnm\TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }
    /**
     * Set TransitDirectionCode value
     * @param \Mnm\TransitDirectionCodeType $transitDirectionCode
     * @return \Mnm\ShipmentStageType
     */
    public function setTransitDirectionCode(\Mnm\TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Mnm\InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * Set Instructions value
     * @param \Mnm\InstructionsType[] $instructions
     * @return \Mnm\ShipmentStageType
     */
    public function setInstructions(array $instructions = array())
    {
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Add item to Instructions value
     * @throws \InvalidArgumentException
     * @param \Mnm\InstructionsType $item
     * @return \Mnm\ShipmentStageType
     */
    public function addToInstructions(\Mnm\InstructionsType $item)
    {
        $this->Instructions[] = $item;
        return $this;
    }
    /**
     * Get TransitPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }
    /**
     * Set TransitPeriod value
     * @param \Mnm\PeriodType $transitPeriod
     * @return \Mnm\ShipmentStageType
     */
    public function setTransitPeriod(\Mnm\PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Mnm\TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Mnm\TransportMeansType $transportMeans
     * @return \Mnm\ShipmentStageType
     */
    public function setTransportMeans(\Mnm\TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Get DriverPerson value
     * @return \Mnm\PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }
    /**
     * Set DriverPerson value
     * @param \Mnm\PersonType[] $driverPerson
     * @return \Mnm\ShipmentStageType
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        $this->DriverPerson = $driverPerson;
        return $this;
    }
    /**
     * Add item to DriverPerson value
     * @throws \InvalidArgumentException
     * @param \Mnm\PersonType $item
     * @return \Mnm\ShipmentStageType
     */
    public function addToDriverPerson(\Mnm\PersonType $item)
    {
        $this->DriverPerson[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ShipmentStageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
