<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPKIDataType StructType
 * @subpackage Structs
 */
class SPKIDataType extends AbstractStructBase
{
    /**
     * The SPKISexp
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SPKISexp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SPKIDataType
     * @uses SPKIDataType::setSPKISexp()
     * @uses SPKIDataType::setAny()
     * @param string[] $sPKISexp
     * @param \DOMDocument $any
     */
    public function __construct(array $sPKISexp = array(), \DOMDocument $any = null)
    {
        $this
            ->setSPKISexp($sPKISexp)
            ->setAny($any);
    }
    /**
     * Get SPKISexp value
     * @return string[]|null
     */
    public function getSPKISexp()
    {
        return $this->SPKISexp;
    }
    /**
     * Set SPKISexp value
     * @param string[] $sPKISexp
     * @return \Mnm\SPKIDataType
     */
    public function setSPKISexp(array $sPKISexp = array())
    {
        $this->SPKISexp = $sPKISexp;
        return $this;
    }
    /**
     * Add item to SPKISexp value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Mnm\SPKIDataType
     */
    public function addToSPKISexp($item)
    {
        $this->SPKISexp[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Mnm\SPKIDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\SPKIDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
