<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q243:Note
     * @var \Mnm\NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q244:PenaltySurchargePercent
     * @var \Mnm\PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q245:Amount
     * @var \Mnm\AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q246:PenaltyAmount
     * @var \Mnm\PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q247:PaymentDueDate
     * @var \Mnm\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTermsType
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     * @param \Mnm\NoteType $note
     * @param \Mnm\PenaltySurchargePercentType $penaltySurchargePercent
     * @param \Mnm\AmountType $amount
     * @param \Mnm\PenaltyAmountType $penaltyAmount
     * @param \Mnm\PaymentDueDateType $paymentDueDate
     * @param \Mnm\PeriodType $settlementPeriod
     */
    public function __construct(\Mnm\NoteType $note = null, \Mnm\PenaltySurchargePercentType $penaltySurchargePercent = null, \Mnm\AmountType $amount = null, \Mnm\PenaltyAmountType $penaltyAmount = null, \Mnm\PaymentDueDateType $paymentDueDate = null, \Mnm\PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Note value
     * @return \Mnm\NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\NoteType $note
     * @return \Mnm\PaymentTermsType
     */
    public function setNote(\Mnm\NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return \Mnm\PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param \Mnm\PenaltySurchargePercentType $penaltySurchargePercent
     * @return \Mnm\PaymentTermsType
     */
    public function setPenaltySurchargePercent(\Mnm\PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Mnm\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Mnm\AmountType $amount
     * @return \Mnm\PaymentTermsType
     */
    public function setAmount(\Mnm\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return \Mnm\PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param \Mnm\PenaltyAmountType $penaltyAmount
     * @return \Mnm\PaymentTermsType
     */
    public function setPenaltyAmount(\Mnm\PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Mnm\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Mnm\PaymentDueDateType $paymentDueDate
     * @return \Mnm\PaymentTermsType
     */
    public function setPaymentDueDate(\Mnm\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }
    /**
     * Set SettlementPeriod value
     * @param \Mnm\PeriodType $settlementPeriod
     * @return \Mnm\PaymentTermsType
     */
    public function setSettlementPeriod(\Mnm\PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PaymentTermsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
