<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeansType StructType
 * @subpackage Structs
 */
class PaymentMeansType extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q239:PaymentMeansCode
     * @var \Mnm\PaymentMeansCodeType
     */
    public $PaymentMeansCode;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q240:PaymentDueDate
     * @var \Mnm\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q241:PaymentChannelCode
     * @var \Mnm\PaymentChannelCodeType
     */
    public $PaymentChannelCode;
    /**
     * The InstructionNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q242:InstructionNote
     * @var \Mnm\InstructionNoteType
     */
    public $InstructionNote;
    /**
     * The PayerFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\FinancialAccountType
     */
    public $PayerFinancialAccount;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\FinancialAccountType
     */
    public $PayeeFinancialAccount;
    /**
     * Constructor method for PaymentMeansType
     * @uses PaymentMeansType::setPaymentMeansCode()
     * @uses PaymentMeansType::setPaymentDueDate()
     * @uses PaymentMeansType::setPaymentChannelCode()
     * @uses PaymentMeansType::setInstructionNote()
     * @uses PaymentMeansType::setPayerFinancialAccount()
     * @uses PaymentMeansType::setPayeeFinancialAccount()
     * @param \Mnm\PaymentMeansCodeType $paymentMeansCode
     * @param \Mnm\PaymentDueDateType $paymentDueDate
     * @param \Mnm\PaymentChannelCodeType $paymentChannelCode
     * @param \Mnm\InstructionNoteType $instructionNote
     * @param \Mnm\FinancialAccountType $payerFinancialAccount
     * @param \Mnm\FinancialAccountType $payeeFinancialAccount
     */
    public function __construct(\Mnm\PaymentMeansCodeType $paymentMeansCode = null, \Mnm\PaymentDueDateType $paymentDueDate = null, \Mnm\PaymentChannelCodeType $paymentChannelCode = null, \Mnm\InstructionNoteType $instructionNote = null, \Mnm\FinancialAccountType $payerFinancialAccount = null, \Mnm\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setInstructionNote($instructionNote)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPayeeFinancialAccount($payeeFinancialAccount);
    }
    /**
     * Get PaymentMeansCode value
     * @return \Mnm\PaymentMeansCodeType|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param \Mnm\PaymentMeansCodeType $paymentMeansCode
     * @return \Mnm\PaymentMeansType
     */
    public function setPaymentMeansCode(\Mnm\PaymentMeansCodeType $paymentMeansCode = null)
    {
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Mnm\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Mnm\PaymentDueDateType $paymentDueDate
     * @return \Mnm\PaymentMeansType
     */
    public function setPaymentDueDate(\Mnm\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * @return \Mnm\PaymentChannelCodeType|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }
    /**
     * Set PaymentChannelCode value
     * @param \Mnm\PaymentChannelCodeType $paymentChannelCode
     * @return \Mnm\PaymentMeansType
     */
    public function setPaymentChannelCode(\Mnm\PaymentChannelCodeType $paymentChannelCode = null)
    {
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }
    /**
     * Get InstructionNote value
     * @return \Mnm\InstructionNoteType|null
     */
    public function getInstructionNote()
    {
        return $this->InstructionNote;
    }
    /**
     * Set InstructionNote value
     * @param \Mnm\InstructionNoteType $instructionNote
     * @return \Mnm\PaymentMeansType
     */
    public function setInstructionNote(\Mnm\InstructionNoteType $instructionNote = null)
    {
        $this->InstructionNote = $instructionNote;
        return $this;
    }
    /**
     * Get PayerFinancialAccount value
     * @return \Mnm\FinancialAccountType|null
     */
    public function getPayerFinancialAccount()
    {
        return $this->PayerFinancialAccount;
    }
    /**
     * Set PayerFinancialAccount value
     * @param \Mnm\FinancialAccountType $payerFinancialAccount
     * @return \Mnm\PaymentMeansType
     */
    public function setPayerFinancialAccount(\Mnm\FinancialAccountType $payerFinancialAccount = null)
    {
        $this->PayerFinancialAccount = $payerFinancialAccount;
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * @return \Mnm\FinancialAccountType|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }
    /**
     * Set PayeeFinancialAccount value
     * @param \Mnm\FinancialAccountType $payeeFinancialAccount
     * @return \Mnm\PaymentMeansType
     */
    public function setPayeeFinancialAccount(\Mnm\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PaymentMeansType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
