<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyLegalEntityType StructType
 * @subpackage Structs
 */
class PartyLegalEntityType extends AbstractStructBase
{
    /**
     * The RegistrationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q43:RegistrationName
     * @var \Mnm\RegistrationNameType
     */
    public $RegistrationName;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q44:CompanyID
     * @var \Mnm\CompanyIDType
     */
    public $CompanyID;
    /**
     * The RegistrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q45:RegistrationDate
     * @var \Mnm\RegistrationDateType
     */
    public $RegistrationDate;
    /**
     * The SoleProprietorshipIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q46:SoleProprietorshipIndicator
     * @var \Mnm\SoleProprietorshipIndicatorType
     */
    public $SoleProprietorshipIndicator;
    /**
     * The CorporateStockAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q47:CorporateStockAmount
     * @var \Mnm\CorporateStockAmountType
     */
    public $CorporateStockAmount;
    /**
     * The FullyPaidSharesIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q48:FullyPaidSharesIndicator
     * @var \Mnm\FullyPaidSharesIndicatorType
     */
    public $FullyPaidSharesIndicator;
    /**
     * The CorporateRegistrationScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\CorporateRegistrationSchemeType
     */
    public $CorporateRegistrationScheme;
    /**
     * The HeadOfficeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $HeadOfficeParty;
    /**
     * Constructor method for PartyLegalEntityType
     * @uses PartyLegalEntityType::setRegistrationName()
     * @uses PartyLegalEntityType::setCompanyID()
     * @uses PartyLegalEntityType::setRegistrationDate()
     * @uses PartyLegalEntityType::setSoleProprietorshipIndicator()
     * @uses PartyLegalEntityType::setCorporateStockAmount()
     * @uses PartyLegalEntityType::setFullyPaidSharesIndicator()
     * @uses PartyLegalEntityType::setCorporateRegistrationScheme()
     * @uses PartyLegalEntityType::setHeadOfficeParty()
     * @param \Mnm\RegistrationNameType $registrationName
     * @param \Mnm\CompanyIDType $companyID
     * @param \Mnm\RegistrationDateType $registrationDate
     * @param \Mnm\SoleProprietorshipIndicatorType $soleProprietorshipIndicator
     * @param \Mnm\CorporateStockAmountType $corporateStockAmount
     * @param \Mnm\FullyPaidSharesIndicatorType $fullyPaidSharesIndicator
     * @param \Mnm\CorporateRegistrationSchemeType $corporateRegistrationScheme
     * @param \Mnm\PartyType $headOfficeParty
     */
    public function __construct(\Mnm\RegistrationNameType $registrationName = null, \Mnm\CompanyIDType $companyID = null, \Mnm\RegistrationDateType $registrationDate = null, \Mnm\SoleProprietorshipIndicatorType $soleProprietorshipIndicator = null, \Mnm\CorporateStockAmountType $corporateStockAmount = null, \Mnm\FullyPaidSharesIndicatorType $fullyPaidSharesIndicator = null, \Mnm\CorporateRegistrationSchemeType $corporateRegistrationScheme = null, \Mnm\PartyType $headOfficeParty = null)
    {
        $this
            ->setRegistrationName($registrationName)
            ->setCompanyID($companyID)
            ->setRegistrationDate($registrationDate)
            ->setSoleProprietorshipIndicator($soleProprietorshipIndicator)
            ->setCorporateStockAmount($corporateStockAmount)
            ->setFullyPaidSharesIndicator($fullyPaidSharesIndicator)
            ->setCorporateRegistrationScheme($corporateRegistrationScheme)
            ->setHeadOfficeParty($headOfficeParty);
    }
    /**
     * Get RegistrationName value
     * @return \Mnm\RegistrationNameType|null
     */
    public function getRegistrationName()
    {
        return $this->RegistrationName;
    }
    /**
     * Set RegistrationName value
     * @param \Mnm\RegistrationNameType $registrationName
     * @return \Mnm\PartyLegalEntityType
     */
    public function setRegistrationName(\Mnm\RegistrationNameType $registrationName = null)
    {
        $this->RegistrationName = $registrationName;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return \Mnm\CompanyIDType|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param \Mnm\CompanyIDType $companyID
     * @return \Mnm\PartyLegalEntityType
     */
    public function setCompanyID(\Mnm\CompanyIDType $companyID = null)
    {
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return \Mnm\RegistrationDateType|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param \Mnm\RegistrationDateType $registrationDate
     * @return \Mnm\PartyLegalEntityType
     */
    public function setRegistrationDate(\Mnm\RegistrationDateType $registrationDate = null)
    {
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get SoleProprietorshipIndicator value
     * @return \Mnm\SoleProprietorshipIndicatorType|null
     */
    public function getSoleProprietorshipIndicator()
    {
        return $this->SoleProprietorshipIndicator;
    }
    /**
     * Set SoleProprietorshipIndicator value
     * @param \Mnm\SoleProprietorshipIndicatorType $soleProprietorshipIndicator
     * @return \Mnm\PartyLegalEntityType
     */
    public function setSoleProprietorshipIndicator(\Mnm\SoleProprietorshipIndicatorType $soleProprietorshipIndicator = null)
    {
        $this->SoleProprietorshipIndicator = $soleProprietorshipIndicator;
        return $this;
    }
    /**
     * Get CorporateStockAmount value
     * @return \Mnm\CorporateStockAmountType|null
     */
    public function getCorporateStockAmount()
    {
        return $this->CorporateStockAmount;
    }
    /**
     * Set CorporateStockAmount value
     * @param \Mnm\CorporateStockAmountType $corporateStockAmount
     * @return \Mnm\PartyLegalEntityType
     */
    public function setCorporateStockAmount(\Mnm\CorporateStockAmountType $corporateStockAmount = null)
    {
        $this->CorporateStockAmount = $corporateStockAmount;
        return $this;
    }
    /**
     * Get FullyPaidSharesIndicator value
     * @return \Mnm\FullyPaidSharesIndicatorType|null
     */
    public function getFullyPaidSharesIndicator()
    {
        return $this->FullyPaidSharesIndicator;
    }
    /**
     * Set FullyPaidSharesIndicator value
     * @param \Mnm\FullyPaidSharesIndicatorType $fullyPaidSharesIndicator
     * @return \Mnm\PartyLegalEntityType
     */
    public function setFullyPaidSharesIndicator(\Mnm\FullyPaidSharesIndicatorType $fullyPaidSharesIndicator = null)
    {
        $this->FullyPaidSharesIndicator = $fullyPaidSharesIndicator;
        return $this;
    }
    /**
     * Get CorporateRegistrationScheme value
     * @return \Mnm\CorporateRegistrationSchemeType|null
     */
    public function getCorporateRegistrationScheme()
    {
        return $this->CorporateRegistrationScheme;
    }
    /**
     * Set CorporateRegistrationScheme value
     * @param \Mnm\CorporateRegistrationSchemeType $corporateRegistrationScheme
     * @return \Mnm\PartyLegalEntityType
     */
    public function setCorporateRegistrationScheme(\Mnm\CorporateRegistrationSchemeType $corporateRegistrationScheme = null)
    {
        $this->CorporateRegistrationScheme = $corporateRegistrationScheme;
        return $this;
    }
    /**
     * Get HeadOfficeParty value
     * @return \Mnm\PartyType|null
     */
    public function getHeadOfficeParty()
    {
        return $this->HeadOfficeParty;
    }
    /**
     * Set HeadOfficeParty value
     * @param \Mnm\PartyType $headOfficeParty
     * @return \Mnm\PartyLegalEntityType
     */
    public function setHeadOfficeParty(\Mnm\PartyType $headOfficeParty = null)
    {
        $this->HeadOfficeParty = $headOfficeParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PartyLegalEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
