<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedQueryContext StructType
 * @subpackage Structs
 */
class PagedQueryContext extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * Constructor method for PagedQueryContext
     * @uses PagedQueryContext::setPageIndex()
     * @uses PagedQueryContext::setPageSize()
     * @param int $pageIndex
     * @param int $pageSize
     */
    public function __construct($pageIndex = null, $pageSize = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize);
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \Mnm\PagedQueryContext
     */
    public function setPageIndex($pageIndex = null)
    {
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \Mnm\PagedQueryContext
     */
    public function setPageSize($pageSize = null)
    {
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PagedQueryContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
