<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q224:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q225:Quantity
     * @var \Mnm\QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q226:ReturnableMaterialIndicator
     * @var \Mnm\ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q227:PackageLevelCode
     * @var \Mnm\PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q228:PackagingTypeCode
     * @var \Mnm\PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q229:PackingMaterial
     * @var \Mnm\PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     * @param \Mnm\IDType $iD
     * @param \Mnm\QuantityType $quantity
     * @param \Mnm\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param \Mnm\PackageLevelCodeType $packageLevelCode
     * @param \Mnm\PackagingTypeCodeType $packagingTypeCode
     * @param \Mnm\PackingMaterialType[] $packingMaterial
     * @param \Mnm\PackageType[] $containedPackage
     * @param \Mnm\GoodsItemType[] $goodsItem
     * @param \Mnm\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\QuantityType $quantity = null, \Mnm\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, \Mnm\PackageLevelCodeType $packageLevelCode = null, \Mnm\PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\PackageType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\QuantityType $quantity
     * @return \Mnm\PackageType
     */
    public function setQuantity(\Mnm\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return \Mnm\ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param \Mnm\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return \Mnm\PackageType
     */
    public function setReturnableMaterialIndicator(\Mnm\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * @return \Mnm\PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }
    /**
     * Set PackageLevelCode value
     * @param \Mnm\PackageLevelCodeType $packageLevelCode
     * @return \Mnm\PackageType
     */
    public function setPackageLevelCode(\Mnm\PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return \Mnm\PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param \Mnm\PackagingTypeCodeType $packagingTypeCode
     * @return \Mnm\PackageType
     */
    public function setPackagingTypeCode(\Mnm\PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackingMaterial value
     * @return \Mnm\PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }
    /**
     * Set PackingMaterial value
     * @param \Mnm\PackingMaterialType[] $packingMaterial
     * @return \Mnm\PackageType
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }
    /**
     * Add item to PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Mnm\PackingMaterialType $item
     * @return \Mnm\PackageType
     */
    public function addToPackingMaterial(\Mnm\PackingMaterialType $item)
    {
        $this->PackingMaterial[] = $item;
        return $this;
    }
    /**
     * Get ContainedPackage value
     * @return \Mnm\PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }
    /**
     * Set ContainedPackage value
     * @param \Mnm\PackageType[] $containedPackage
     * @return \Mnm\PackageType
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        $this->ContainedPackage = $containedPackage;
        return $this;
    }
    /**
     * Add item to ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Mnm\PackageType $item
     * @return \Mnm\PackageType
     */
    public function addToContainedPackage(\Mnm\PackageType $item)
    {
        $this->ContainedPackage[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Mnm\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * Set GoodsItem value
     * @param \Mnm\GoodsItemType[] $goodsItem
     * @return \Mnm\PackageType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Mnm\GoodsItemType $item
     * @return \Mnm\PackageType
     */
    public function addToGoodsItem(\Mnm\GoodsItemType $item)
    {
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\DimensionType[] $measurementDimension
     * @return \Mnm\PackageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\DimensionType $item
     * @return \Mnm\PackageType
     */
    public function addToMeasurementDimension(\Mnm\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
