<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReferenceType StructType
 * @subpackage Structs
 */
class OrderReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q7:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The SalesOrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q8:SalesOrderID
     * @var \Mnm\SalesOrderIDType
     */
    public $SalesOrderID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q9:IssueDate
     * @var \Mnm\IssueDateType
     */
    public $IssueDate;
    /**
     * The OrderTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q10:OrderTypeCode
     * @var \Mnm\OrderTypeCodeType
     */
    public $OrderTypeCode;
    /**
     * The DocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $DocumentReference;
    /**
     * Constructor method for OrderReferenceType
     * @uses OrderReferenceType::setID()
     * @uses OrderReferenceType::setSalesOrderID()
     * @uses OrderReferenceType::setIssueDate()
     * @uses OrderReferenceType::setOrderTypeCode()
     * @uses OrderReferenceType::setDocumentReference()
     * @param \Mnm\IDType $iD
     * @param \Mnm\SalesOrderIDType $salesOrderID
     * @param \Mnm\IssueDateType $issueDate
     * @param \Mnm\OrderTypeCodeType $orderTypeCode
     * @param \Mnm\DocumentReferenceType $documentReference
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\SalesOrderIDType $salesOrderID = null, \Mnm\IssueDateType $issueDate = null, \Mnm\OrderTypeCodeType $orderTypeCode = null, \Mnm\DocumentReferenceType $documentReference = null)
    {
        $this
            ->setID($iD)
            ->setSalesOrderID($salesOrderID)
            ->setIssueDate($issueDate)
            ->setOrderTypeCode($orderTypeCode)
            ->setDocumentReference($documentReference);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\OrderReferenceType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SalesOrderID value
     * @return \Mnm\SalesOrderIDType|null
     */
    public function getSalesOrderID()
    {
        return $this->SalesOrderID;
    }
    /**
     * Set SalesOrderID value
     * @param \Mnm\SalesOrderIDType $salesOrderID
     * @return \Mnm\OrderReferenceType
     */
    public function setSalesOrderID(\Mnm\SalesOrderIDType $salesOrderID = null)
    {
        $this->SalesOrderID = $salesOrderID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\IssueDateType $issueDate
     * @return \Mnm\OrderReferenceType
     */
    public function setIssueDate(\Mnm\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get OrderTypeCode value
     * @return \Mnm\OrderTypeCodeType|null
     */
    public function getOrderTypeCode()
    {
        return $this->OrderTypeCode;
    }
    /**
     * Set OrderTypeCode value
     * @param \Mnm\OrderTypeCodeType $orderTypeCode
     * @return \Mnm\OrderReferenceType
     */
    public function setOrderTypeCode(\Mnm\OrderTypeCodeType $orderTypeCode = null)
    {
        $this->OrderTypeCode = $orderTypeCode;
        return $this;
    }
    /**
     * Get DocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getDocumentReference()
    {
        return $this->DocumentReference;
    }
    /**
     * Set DocumentReference value
     * @param \Mnm\DocumentReferenceType $documentReference
     * @return \Mnm\OrderReferenceType
     */
    public function setDocumentReference(\Mnm\DocumentReferenceType $documentReference = null)
    {
        $this->DocumentReference = $documentReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\OrderReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
