<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthlyReportItem StructType
 * @subpackage Structs
 */
class MonthlyReportItem extends AbstractStructBase
{
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Period;
    /**
     * The InboxCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InboxCount;
    /**
     * The OutboxCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutboxCount;
    /**
     * Constructor method for MonthlyReportItem
     * @uses MonthlyReportItem::setPeriod()
     * @uses MonthlyReportItem::setInboxCount()
     * @uses MonthlyReportItem::setOutboxCount()
     * @param int $period
     * @param int $inboxCount
     * @param int $outboxCount
     */
    public function __construct($period = null, $inboxCount = null, $outboxCount = null)
    {
        $this
            ->setPeriod($period)
            ->setInboxCount($inboxCount)
            ->setOutboxCount($outboxCount);
    }
    /**
     * Get Period value
     * @return int
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param int $period
     * @return \Mnm\MonthlyReportItem
     */
    public function setPeriod($period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get InboxCount value
     * @return int
     */
    public function getInboxCount()
    {
        return $this->InboxCount;
    }
    /**
     * Set InboxCount value
     * @param int $inboxCount
     * @return \Mnm\MonthlyReportItem
     */
    public function setInboxCount($inboxCount = null)
    {
        $this->InboxCount = $inboxCount;
        return $this;
    }
    /**
     * Get OutboxCount value
     * @return int
     */
    public function getOutboxCount()
    {
        return $this->OutboxCount;
    }
    /**
     * Set OutboxCount value
     * @param int $outboxCount
     * @return \Mnm\MonthlyReportItem
     */
    public function setOutboxCount($outboxCount = null)
    {
        $this->OutboxCount = $outboxCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\MonthlyReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
