<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q252:LineExtensionAmount
     * @var \Mnm\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q253:TaxExclusiveAmount
     * @var \Mnm\TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q254:TaxInclusiveAmount
     * @var \Mnm\TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q255:AllowanceTotalAmount
     * @var \Mnm\AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q256:ChargeTotalAmount
     * @var \Mnm\ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q257:PayableRoundingAmount
     * @var \Mnm\PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q258:PayableAmount
     * @var \Mnm\PayableAmountType
     */
    public $PayableAmount;
    /**
     * Constructor method for MonetaryTotalType
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     * @param \Mnm\LineExtensionAmountType $lineExtensionAmount
     * @param \Mnm\TaxExclusiveAmountType $taxExclusiveAmount
     * @param \Mnm\TaxInclusiveAmountType $taxInclusiveAmount
     * @param \Mnm\AllowanceTotalAmountType $allowanceTotalAmount
     * @param \Mnm\ChargeTotalAmountType $chargeTotalAmount
     * @param \Mnm\PayableRoundingAmountType $payableRoundingAmount
     * @param \Mnm\PayableAmountType $payableAmount
     */
    public function __construct(\Mnm\LineExtensionAmountType $lineExtensionAmount = null, \Mnm\TaxExclusiveAmountType $taxExclusiveAmount = null, \Mnm\TaxInclusiveAmountType $taxInclusiveAmount = null, \Mnm\AllowanceTotalAmountType $allowanceTotalAmount = null, \Mnm\ChargeTotalAmountType $chargeTotalAmount = null, \Mnm\PayableRoundingAmountType $payableRoundingAmount = null, \Mnm\PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }
    /**
     * Get LineExtensionAmount value
     * @return \Mnm\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Mnm\LineExtensionAmountType $lineExtensionAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setLineExtensionAmount(\Mnm\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return \Mnm\TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param \Mnm\TaxExclusiveAmountType $taxExclusiveAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setTaxExclusiveAmount(\Mnm\TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return \Mnm\TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param \Mnm\TaxInclusiveAmountType $taxInclusiveAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setTaxInclusiveAmount(\Mnm\TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return \Mnm\AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param \Mnm\AllowanceTotalAmountType $allowanceTotalAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setAllowanceTotalAmount(\Mnm\AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return \Mnm\ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param \Mnm\ChargeTotalAmountType $chargeTotalAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setChargeTotalAmount(\Mnm\ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get PayableRoundingAmount value
     * @return \Mnm\PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }
    /**
     * Set PayableRoundingAmount value
     * @param \Mnm\PayableRoundingAmountType $payableRoundingAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setPayableRoundingAmount(\Mnm\PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return \Mnm\PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param \Mnm\PayableAmountType $payableAmount
     * @return \Mnm\MonetaryTotalType
     */
    public function setPayableAmount(\Mnm\PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\MonetaryTotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
