<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LotIdentificationType StructType
 * @subpackage Structs
 */
class LotIdentificationType extends AbstractStructBase
{
    /**
     * The LotNumberID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q165:LotNumberID
     * @var \Mnm\LotNumberIDType
     */
    public $LotNumberID;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q166:ExpiryDate
     * @var \Mnm\ExpiryDateType
     */
    public $ExpiryDate;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * Constructor method for LotIdentificationType
     * @uses LotIdentificationType::setLotNumberID()
     * @uses LotIdentificationType::setExpiryDate()
     * @uses LotIdentificationType::setAdditionalItemProperty()
     * @param \Mnm\LotNumberIDType $lotNumberID
     * @param \Mnm\ExpiryDateType $expiryDate
     * @param \Mnm\ItemPropertyType[] $additionalItemProperty
     */
    public function __construct(\Mnm\LotNumberIDType $lotNumberID = null, \Mnm\ExpiryDateType $expiryDate = null, array $additionalItemProperty = array())
    {
        $this
            ->setLotNumberID($lotNumberID)
            ->setExpiryDate($expiryDate)
            ->setAdditionalItemProperty($additionalItemProperty);
    }
    /**
     * Get LotNumberID value
     * @return \Mnm\LotNumberIDType|null
     */
    public function getLotNumberID()
    {
        return $this->LotNumberID;
    }
    /**
     * Set LotNumberID value
     * @param \Mnm\LotNumberIDType $lotNumberID
     * @return \Mnm\LotIdentificationType
     */
    public function setLotNumberID(\Mnm\LotNumberIDType $lotNumberID = null)
    {
        $this->LotNumberID = $lotNumberID;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return \Mnm\ExpiryDateType|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param \Mnm\ExpiryDateType $expiryDate
     * @return \Mnm\LotIdentificationType
     */
    public function setExpiryDate(\Mnm\ExpiryDateType $expiryDate = null)
    {
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Mnm\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * Set AdditionalItemProperty value
     * @param \Mnm\ItemPropertyType[] $additionalItemProperty
     * @return \Mnm\LotIdentificationType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemPropertyType $item
     * @return \Mnm\LotIdentificationType
     */
    public function addToAdditionalItemProperty(\Mnm\ItemPropertyType $item)
    {
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\LotIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
