<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q1:UBLExtensions
     * @var \Mnm\ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q2:UBLVersionID
     * @var \Mnm\UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q3:CustomizationID
     * @var \Mnm\CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q4:ProfileID
     * @var \Mnm\ProfileIDType
     */
    public $ProfileID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q5:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q6:CopyIndicator
     * @var \Mnm\CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q7:UUID
     * @var \Mnm\UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q8:IssueDate
     * @var \Mnm\IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q9:IssueTime
     * @var \Mnm\IssueTimeType
     */
    public $IssueTime;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q10:InvoiceTypeCode
     * @var \Mnm\InvoiceTypeCodeType
     */
    public $InvoiceTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q11:Note
     * @var \Mnm\NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:DocumentCurrencyCode
     * @var \Mnm\DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:TaxCurrencyCode
     * @var \Mnm\TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:PricingCurrencyCode
     * @var \Mnm\PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q15:PaymentCurrencyCode
     * @var \Mnm\PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q16:PaymentAlternativeCurrencyCode
     * @var \Mnm\PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q17:AccountingCost
     * @var \Mnm\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:LineCountNumeric
     * @var \Mnm\LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:InvoicePeriod
     * @var \Mnm\PeriodType
     */
    public $InvoicePeriod;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:OrderReference
     * @var \Mnm\OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q21:BillingReference
     * @var \Mnm\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q22:DespatchDocumentReference
     * @var \Mnm\DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q23:ReceiptDocumentReference
     * @var \Mnm\DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q24:OriginatorDocumentReference
     * @var \Mnm\DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q25:ContractDocumentReference
     * @var \Mnm\DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q26:AdditionalDocumentReference
     * @var \Mnm\DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q27:Signature
     * @var \Mnm\SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q28:AccountingSupplierParty
     * @var \Mnm\SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q29:AccountingCustomerParty
     * @var \Mnm\CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q30:BuyerCustomerParty
     * @var \Mnm\CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q31:SellerSupplierParty
     * @var \Mnm\SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q32:TaxRepresentativeParty
     * @var \Mnm\PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q33:Delivery
     * @var \Mnm\DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q34:PaymentMeans
     * @var \Mnm\PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q35:PaymentTerms
     * @var \Mnm\PaymentTermsType
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q36:AllowanceCharge
     * @var \Mnm\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q37:TaxExchangeRate
     * @var \Mnm\ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q38:PricingExchangeRate
     * @var \Mnm\ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q39:PaymentExchangeRate
     * @var \Mnm\ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q40:PaymentAlternativeExchangeRate
     * @var \Mnm\ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q41:TaxTotal
     * @var \Mnm\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q42:WithholdingTaxTotal
     * @var \Mnm\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q43:LegalMonetaryTotal
     * @var \Mnm\MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q44:InvoiceLine
     * @var \Mnm\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The schemaLocation
     * @var string
     */
    public $schemaLocation;
    /**
     * Constructor method for InvoiceType
     * @uses InvoiceType::setUBLExtensions()
     * @uses InvoiceType::setUBLVersionID()
     * @uses InvoiceType::setCustomizationID()
     * @uses InvoiceType::setProfileID()
     * @uses InvoiceType::setID()
     * @uses InvoiceType::setCopyIndicator()
     * @uses InvoiceType::setUUID()
     * @uses InvoiceType::setIssueDate()
     * @uses InvoiceType::setIssueTime()
     * @uses InvoiceType::setInvoiceTypeCode()
     * @uses InvoiceType::setNote()
     * @uses InvoiceType::setDocumentCurrencyCode()
     * @uses InvoiceType::setTaxCurrencyCode()
     * @uses InvoiceType::setPricingCurrencyCode()
     * @uses InvoiceType::setPaymentCurrencyCode()
     * @uses InvoiceType::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceType::setAccountingCost()
     * @uses InvoiceType::setLineCountNumeric()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setOrderReference()
     * @uses InvoiceType::setBillingReference()
     * @uses InvoiceType::setDespatchDocumentReference()
     * @uses InvoiceType::setReceiptDocumentReference()
     * @uses InvoiceType::setOriginatorDocumentReference()
     * @uses InvoiceType::setContractDocumentReference()
     * @uses InvoiceType::setAdditionalDocumentReference()
     * @uses InvoiceType::setSignature()
     * @uses InvoiceType::setAccountingSupplierParty()
     * @uses InvoiceType::setAccountingCustomerParty()
     * @uses InvoiceType::setBuyerCustomerParty()
     * @uses InvoiceType::setSellerSupplierParty()
     * @uses InvoiceType::setTaxRepresentativeParty()
     * @uses InvoiceType::setDelivery()
     * @uses InvoiceType::setPaymentMeans()
     * @uses InvoiceType::setPaymentTerms()
     * @uses InvoiceType::setAllowanceCharge()
     * @uses InvoiceType::setTaxExchangeRate()
     * @uses InvoiceType::setPricingExchangeRate()
     * @uses InvoiceType::setPaymentExchangeRate()
     * @uses InvoiceType::setPaymentAlternativeExchangeRate()
     * @uses InvoiceType::setTaxTotal()
     * @uses InvoiceType::setWithholdingTaxTotal()
     * @uses InvoiceType::setLegalMonetaryTotal()
     * @uses InvoiceType::setInvoiceLine()
     * @uses InvoiceType::setSchemaLocation()
     * @param \Mnm\ArrayOfUBLExtensionType $uBLExtensions
     * @param \Mnm\UBLVersionIDType $uBLVersionID
     * @param \Mnm\CustomizationIDType $customizationID
     * @param \Mnm\ProfileIDType $profileID
     * @param \Mnm\IDType $iD
     * @param \Mnm\CopyIndicatorType $copyIndicator
     * @param \Mnm\UUIDType $uUID
     * @param \Mnm\IssueDateType $issueDate
     * @param \Mnm\IssueTimeType $issueTime
     * @param \Mnm\InvoiceTypeCodeType $invoiceTypeCode
     * @param \Mnm\NoteType[] $note
     * @param \Mnm\DocumentCurrencyCodeType $documentCurrencyCode
     * @param \Mnm\TaxCurrencyCodeType $taxCurrencyCode
     * @param \Mnm\PricingCurrencyCodeType $pricingCurrencyCode
     * @param \Mnm\PaymentCurrencyCodeType $paymentCurrencyCode
     * @param \Mnm\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param \Mnm\AccountingCostType $accountingCost
     * @param \Mnm\LineCountNumericType $lineCountNumeric
     * @param \Mnm\PeriodType $invoicePeriod
     * @param \Mnm\OrderReferenceType $orderReference
     * @param \Mnm\BillingReferenceType[] $billingReference
     * @param \Mnm\DocumentReferenceType[] $despatchDocumentReference
     * @param \Mnm\DocumentReferenceType[] $receiptDocumentReference
     * @param \Mnm\DocumentReferenceType[] $originatorDocumentReference
     * @param \Mnm\DocumentReferenceType[] $contractDocumentReference
     * @param \Mnm\DocumentReferenceType[] $additionalDocumentReference
     * @param \Mnm\SignatureType[] $signature
     * @param \Mnm\SupplierPartyType $accountingSupplierParty
     * @param \Mnm\CustomerPartyType $accountingCustomerParty
     * @param \Mnm\CustomerPartyType $buyerCustomerParty
     * @param \Mnm\SupplierPartyType $sellerSupplierParty
     * @param \Mnm\PartyType $taxRepresentativeParty
     * @param \Mnm\DeliveryType[] $delivery
     * @param \Mnm\PaymentMeansType[] $paymentMeans
     * @param \Mnm\PaymentTermsType $paymentTerms
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     * @param \Mnm\ExchangeRateType $taxExchangeRate
     * @param \Mnm\ExchangeRateType $pricingExchangeRate
     * @param \Mnm\ExchangeRateType $paymentExchangeRate
     * @param \Mnm\ExchangeRateType $paymentAlternativeExchangeRate
     * @param \Mnm\TaxTotalType[] $taxTotal
     * @param \Mnm\TaxTotalType[] $withholdingTaxTotal
     * @param \Mnm\MonetaryTotalType $legalMonetaryTotal
     * @param \Mnm\InvoiceLineType[] $invoiceLine
     * @param string $schemaLocation
     */
    public function __construct(\Mnm\ArrayOfUBLExtensionType $uBLExtensions = null, \Mnm\UBLVersionIDType $uBLVersionID = null, \Mnm\CustomizationIDType $customizationID = null, \Mnm\ProfileIDType $profileID = null, \Mnm\IDType $iD = null, \Mnm\CopyIndicatorType $copyIndicator = null, \Mnm\UUIDType $uUID = null, \Mnm\IssueDateType $issueDate = null, \Mnm\IssueTimeType $issueTime = null, \Mnm\InvoiceTypeCodeType $invoiceTypeCode = null, array $note = array(), \Mnm\DocumentCurrencyCodeType $documentCurrencyCode = null, \Mnm\TaxCurrencyCodeType $taxCurrencyCode = null, \Mnm\PricingCurrencyCodeType $pricingCurrencyCode = null, \Mnm\PaymentCurrencyCodeType $paymentCurrencyCode = null, \Mnm\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, \Mnm\AccountingCostType $accountingCost = null, \Mnm\LineCountNumericType $lineCountNumeric = null, \Mnm\PeriodType $invoicePeriod = null, \Mnm\OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $originatorDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $signature = array(), \Mnm\SupplierPartyType $accountingSupplierParty = null, \Mnm\CustomerPartyType $accountingCustomerParty = null, \Mnm\CustomerPartyType $buyerCustomerParty = null, \Mnm\SupplierPartyType $sellerSupplierParty = null, \Mnm\PartyType $taxRepresentativeParty = null, array $delivery = array(), array $paymentMeans = array(), \Mnm\PaymentTermsType $paymentTerms = null, array $allowanceCharge = array(), \Mnm\ExchangeRateType $taxExchangeRate = null, \Mnm\ExchangeRateType $pricingExchangeRate = null, \Mnm\ExchangeRateType $paymentExchangeRate = null, \Mnm\ExchangeRateType $paymentAlternativeExchangeRate = null, array $taxTotal = array(), array $withholdingTaxTotal = array(), \Mnm\MonetaryTotalType $legalMonetaryTotal = null, array $invoiceLine = array(), $schemaLocation = null)
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceLine($invoiceLine)
            ->setSchemaLocation($schemaLocation);
    }
    /**
     * Get UBLExtensions value
     * @return \Mnm\ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }
    /**
     * Set UBLExtensions value
     * @param \Mnm\ArrayOfUBLExtensionType $uBLExtensions
     * @return \Mnm\InvoiceType
     */
    public function setUBLExtensions(\Mnm\ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return \Mnm\UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param \Mnm\UBLVersionIDType $uBLVersionID
     * @return \Mnm\InvoiceType
     */
    public function setUBLVersionID(\Mnm\UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return \Mnm\CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param \Mnm\CustomizationIDType $customizationID
     * @return \Mnm\InvoiceType
     */
    public function setCustomizationID(\Mnm\CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return \Mnm\ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param \Mnm\ProfileIDType $profileID
     * @return \Mnm\InvoiceType
     */
    public function setProfileID(\Mnm\ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\InvoiceType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return \Mnm\CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param \Mnm\CopyIndicatorType $copyIndicator
     * @return \Mnm\InvoiceType
     */
    public function setCopyIndicator(\Mnm\CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Mnm\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Mnm\UUIDType $uUID
     * @return \Mnm\InvoiceType
     */
    public function setUUID(\Mnm\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\IssueDateType $issueDate
     * @return \Mnm\InvoiceType
     */
    public function setIssueDate(\Mnm\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return \Mnm\IssueTimeType|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param \Mnm\IssueTimeType $issueTime
     * @return \Mnm\InvoiceType
     */
    public function setIssueTime(\Mnm\IssueTimeType $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return \Mnm\InvoiceTypeCodeType|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param \Mnm\InvoiceTypeCodeType $invoiceTypeCode
     * @return \Mnm\InvoiceType
     */
    public function setInvoiceTypeCode(\Mnm\InvoiceTypeCodeType $invoiceTypeCode = null)
    {
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get Note value
     * @return \Mnm\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\NoteType[] $note
     * @return \Mnm\InvoiceType
     */
    public function setNote(array $note = array())
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Mnm\NoteType $item
     * @return \Mnm\InvoiceType
     */
    public function addToNote(\Mnm\NoteType $item)
    {
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return \Mnm\DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param \Mnm\DocumentCurrencyCodeType $documentCurrencyCode
     * @return \Mnm\InvoiceType
     */
    public function setDocumentCurrencyCode(\Mnm\DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * @return \Mnm\TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }
    /**
     * Set TaxCurrencyCode value
     * @param \Mnm\TaxCurrencyCodeType $taxCurrencyCode
     * @return \Mnm\InvoiceType
     */
    public function setTaxCurrencyCode(\Mnm\TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * @return \Mnm\PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }
    /**
     * Set PricingCurrencyCode value
     * @param \Mnm\PricingCurrencyCodeType $pricingCurrencyCode
     * @return \Mnm\InvoiceType
     */
    public function setPricingCurrencyCode(\Mnm\PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return \Mnm\PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param \Mnm\PaymentCurrencyCodeType $paymentCurrencyCode
     * @return \Mnm\InvoiceType
     */
    public function setPaymentCurrencyCode(\Mnm\PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return \Mnm\PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param \Mnm\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return \Mnm\InvoiceType
     */
    public function setPaymentAlternativeCurrencyCode(\Mnm\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \Mnm\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \Mnm\AccountingCostType $accountingCost
     * @return \Mnm\InvoiceType
     */
    public function setAccountingCost(\Mnm\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get LineCountNumeric value
     * @return \Mnm\LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }
    /**
     * Set LineCountNumeric value
     * @param \Mnm\LineCountNumericType $lineCountNumeric
     * @return \Mnm\InvoiceType
     */
    public function setLineCountNumeric(\Mnm\LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * Set InvoicePeriod value
     * @param \Mnm\PeriodType $invoicePeriod
     * @return \Mnm\InvoiceType
     */
    public function setInvoicePeriod(\Mnm\PeriodType $invoicePeriod = null)
    {
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Mnm\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Mnm\OrderReferenceType $orderReference
     * @return \Mnm\InvoiceType
     */
    public function setOrderReference(\Mnm\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \Mnm\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * Set BillingReference value
     * @param \Mnm\BillingReferenceType[] $billingReference
     * @return \Mnm\InvoiceType
     */
    public function setBillingReference(array $billingReference = array())
    {
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\BillingReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToBillingReference(\Mnm\BillingReferenceType $item)
    {
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }
    /**
     * Set DespatchDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $despatchDocumentReference
     * @return \Mnm\InvoiceType
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }
    /**
     * Add item to DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToDespatchDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }
    /**
     * Set ReceiptDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $receiptDocumentReference
     * @return \Mnm\InvoiceType
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }
    /**
     * Add item to ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToReceiptDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }
    /**
     * Set OriginatorDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $originatorDocumentReference
     * @return \Mnm\InvoiceType
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }
    /**
     * Add item to OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToOriginatorDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }
    /**
     * Set ContractDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $contractDocumentReference
     * @return \Mnm\InvoiceType
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }
    /**
     * Add item to ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToContractDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->ContractDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * Set AdditionalDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $additionalDocumentReference
     * @return \Mnm\InvoiceType
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Add item to AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\InvoiceType
     */
    public function addToAdditionalDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \Mnm\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \Mnm\SignatureType[] $signature
     * @return \Mnm\InvoiceType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \Mnm\SignatureType $item
     * @return \Mnm\InvoiceType
     */
    public function addToSignature(\Mnm\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * @return \Mnm\SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }
    /**
     * Set AccountingSupplierParty value
     * @param \Mnm\SupplierPartyType $accountingSupplierParty
     * @return \Mnm\InvoiceType
     */
    public function setAccountingSupplierParty(\Mnm\SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * @return \Mnm\CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }
    /**
     * Set AccountingCustomerParty value
     * @param \Mnm\CustomerPartyType $accountingCustomerParty
     * @return \Mnm\InvoiceType
     */
    public function setAccountingCustomerParty(\Mnm\CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \Mnm\CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \Mnm\CustomerPartyType $buyerCustomerParty
     * @return \Mnm\InvoiceType
     */
    public function setBuyerCustomerParty(\Mnm\CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \Mnm\SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \Mnm\SupplierPartyType $sellerSupplierParty
     * @return \Mnm\InvoiceType
     */
    public function setSellerSupplierParty(\Mnm\SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * @return \Mnm\PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }
    /**
     * Set TaxRepresentativeParty value
     * @param \Mnm\PartyType $taxRepresentativeParty
     * @return \Mnm\InvoiceType
     */
    public function setTaxRepresentativeParty(\Mnm\PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\DeliveryType[] $delivery
     * @return \Mnm\InvoiceType
     */
    public function setDelivery(array $delivery = array())
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Mnm\DeliveryType $item
     * @return \Mnm\InvoiceType
     */
    public function addToDelivery(\Mnm\DeliveryType $item)
    {
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \Mnm\PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param \Mnm\PaymentMeansType[] $paymentMeans
     * @return \Mnm\InvoiceType
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Add item to PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Mnm\PaymentMeansType $item
     * @return \Mnm\InvoiceType
     */
    public function addToPaymentMeans(\Mnm\PaymentMeansType $item)
    {
        $this->PaymentMeans[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \Mnm\PaymentTermsType|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \Mnm\PaymentTermsType $paymentTerms
     * @return \Mnm\InvoiceType
     */
    public function setPaymentTerms(\Mnm\PaymentTermsType $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Mnm\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * Set AllowanceCharge value
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     * @return \Mnm\InvoiceType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\AllowanceChargeType $item
     * @return \Mnm\InvoiceType
     */
    public function addToAllowanceCharge(\Mnm\AllowanceChargeType $item)
    {
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * @return \Mnm\ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }
    /**
     * Set TaxExchangeRate value
     * @param \Mnm\ExchangeRateType $taxExchangeRate
     * @return \Mnm\InvoiceType
     */
    public function setTaxExchangeRate(\Mnm\ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return \Mnm\ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param \Mnm\ExchangeRateType $pricingExchangeRate
     * @return \Mnm\InvoiceType
     */
    public function setPricingExchangeRate(\Mnm\ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * @return \Mnm\ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }
    /**
     * Set PaymentExchangeRate value
     * @param \Mnm\ExchangeRateType $paymentExchangeRate
     * @return \Mnm\InvoiceType
     */
    public function setPaymentExchangeRate(\Mnm\ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * @return \Mnm\ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * @param \Mnm\ExchangeRateType $paymentAlternativeExchangeRate
     * @return \Mnm\InvoiceType
     */
    public function setPaymentAlternativeExchangeRate(\Mnm\ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Mnm\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \Mnm\TaxTotalType[] $taxTotal
     * @return \Mnm\InvoiceType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\TaxTotalType $item
     * @return \Mnm\InvoiceType
     */
    public function addToTaxTotal(\Mnm\TaxTotalType $item)
    {
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Mnm\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * Set WithholdingTaxTotal value
     * @param \Mnm\TaxTotalType[] $withholdingTaxTotal
     * @return \Mnm\InvoiceType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\TaxTotalType $item
     * @return \Mnm\InvoiceType
     */
    public function addToWithholdingTaxTotal(\Mnm\TaxTotalType $item)
    {
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * @return \Mnm\MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }
    /**
     * Set LegalMonetaryTotal value
     * @param \Mnm\MonetaryTotalType $legalMonetaryTotal
     * @return \Mnm\InvoiceType
     */
    public function setLegalMonetaryTotal(\Mnm\MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Mnm\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * Set InvoiceLine value
     * @param \Mnm\InvoiceLineType[] $invoiceLine
     * @return \Mnm\InvoiceType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\InvoiceLineType $item
     * @return \Mnm\InvoiceType
     */
    public function addToInvoiceLine(\Mnm\InvoiceLineType $item)
    {
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get schemaLocation value
     * @return string|null
     */
    public function getSchemaLocation()
    {
        return $this->schemaLocation;
    }
    /**
     * Set schemaLocation value
     * @param string $schemaLocation
     * @return \Mnm\InvoiceType
     */
    public function setSchemaLocation($schemaLocation = null)
    {
        $this->schemaLocation = $schemaLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\InvoiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
