<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceStatusWithLogInfo StructType
 * @subpackage Structs
 */
class InvoiceStatusWithLogInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The EnvelopeStatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $EnvelopeStatusCode;
    /**
     * The LocalDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The Logs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\InvoiceLogItem[]
     */
    public $Logs;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for InvoiceStatusWithLogInfo
     * @uses InvoiceStatusWithLogInfo::setStatus()
     * @uses InvoiceStatusWithLogInfo::setStatusCode()
     * @uses InvoiceStatusWithLogInfo::setEnvelopeStatusCode()
     * @uses InvoiceStatusWithLogInfo::setLocalDocumentId()
     * @uses InvoiceStatusWithLogInfo::setLogs()
     * @uses InvoiceStatusWithLogInfo::setInvoiceId()
     * @uses InvoiceStatusWithLogInfo::setMessage()
     * @param string $status
     * @param int $statusCode
     * @param int $envelopeStatusCode
     * @param string $localDocumentId
     * @param \Mnm\InvoiceLogItem[] $logs
     * @param string $invoiceId
     * @param string $message
     */
    public function __construct($status = null, $statusCode = null, $envelopeStatusCode = null, $localDocumentId = null, array $logs = array(), $invoiceId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelopeStatusCode($envelopeStatusCode)
            ->setLocalDocumentId($localDocumentId)
            ->setLogs($logs)
            ->setInvoiceId($invoiceId)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get EnvelopeStatusCode value
     * @return int
     */
    public function getEnvelopeStatusCode()
    {
        return $this->EnvelopeStatusCode;
    }
    /**
     * Set EnvelopeStatusCode value
     * @param int $envelopeStatusCode
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setEnvelopeStatusCode($envelopeStatusCode = null)
    {
        $this->EnvelopeStatusCode = $envelopeStatusCode;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get Logs value
     * @return \Mnm\InvoiceLogItem[]|null
     */
    public function getLogs()
    {
        return $this->Logs;
    }
    /**
     * Set Logs value
     * @param \Mnm\InvoiceLogItem[] $logs
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setLogs(array $logs = array())
    {
        $this->Logs = $logs;
        return $this;
    }
    /**
     * Add item to Logs value
     * @throws \InvalidArgumentException
     * @param \Mnm\InvoiceLogItem $item
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function addToLogs(\Mnm\InvoiceLogItem $item)
    {
        $this->Logs[] = $item;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\InvoiceStatusWithLogInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
