<?php

namespace Mnm;

/**
 * This class stands for InvoiceScenarioType EnumType
 * @subpackage Enumerations
 */
class InvoiceScenarioType
{
    /**
     * Constant for value 'eInvoice'
     * @return string 'eInvoice'
     */
    const VALUE_E_INVOICE = 'eInvoice';
    /**
     * Constant for value 'eArchive'
     * @return string 'eArchive'
     */
    const VALUE_E_ARCHIVE = 'eArchive';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E_INVOICE
     * @uses self::VALUE_E_ARCHIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E_INVOICE,
            self::VALUE_E_ARCHIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
