<?php

namespace Mnm;

/**
 * This class stands for InvoiceScenarioChoosen EnumType
 * @subpackage Enumerations
 */
class InvoiceScenarioChoosen
{
    /**
     * Constant for value 'Automated'
     * @return string 'Automated'
     */
    const VALUE_AUTOMATED = 'Automated';
    /**
     * Constant for value 'eInvoice'
     * @return string 'eInvoice'
     */
    const VALUE_E_INVOICE = 'eInvoice';
    /**
     * Constant for value 'eArchive'
     * @return string 'eArchive'
     */
    const VALUE_E_ARCHIVE = 'eArchive';
    /**
     * Constant for value 'MusteArchive'
     * @return string 'MusteArchive'
     */
    const VALUE_MUSTE_ARCHIVE = 'MusteArchive';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTOMATED
     * @uses self::VALUE_E_INVOICE
     * @uses self::VALUE_E_ARCHIVE
     * @uses self::VALUE_MUSTE_ARCHIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTOMATED,
            self::VALUE_E_INVOICE,
            self::VALUE_E_ARCHIVE,
            self::VALUE_MUSTE_ARCHIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
