<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialAccountType StructType
 * @subpackage Structs
 */
class FinancialAccountType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q67:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q68:CurrencyCode
     * @var \Mnm\CurrencyCodeType
     */
    public $CurrencyCode;
    /**
     * The PaymentNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q69:PaymentNote
     * @var \Mnm\PaymentNoteType
     */
    public $PaymentNote;
    /**
     * The FinancialInstitutionBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\BranchType
     */
    public $FinancialInstitutionBranch;
    /**
     * Constructor method for FinancialAccountType
     * @uses FinancialAccountType::setID()
     * @uses FinancialAccountType::setCurrencyCode()
     * @uses FinancialAccountType::setPaymentNote()
     * @uses FinancialAccountType::setFinancialInstitutionBranch()
     * @param \Mnm\IDType $iD
     * @param \Mnm\CurrencyCodeType $currencyCode
     * @param \Mnm\PaymentNoteType $paymentNote
     * @param \Mnm\BranchType $financialInstitutionBranch
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\CurrencyCodeType $currencyCode = null, \Mnm\PaymentNoteType $paymentNote = null, \Mnm\BranchType $financialInstitutionBranch = null)
    {
        $this
            ->setID($iD)
            ->setCurrencyCode($currencyCode)
            ->setPaymentNote($paymentNote)
            ->setFinancialInstitutionBranch($financialInstitutionBranch);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\FinancialAccountType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return \Mnm\CurrencyCodeType|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param \Mnm\CurrencyCodeType $currencyCode
     * @return \Mnm\FinancialAccountType
     */
    public function setCurrencyCode(\Mnm\CurrencyCodeType $currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PaymentNote value
     * @return \Mnm\PaymentNoteType|null
     */
    public function getPaymentNote()
    {
        return $this->PaymentNote;
    }
    /**
     * Set PaymentNote value
     * @param \Mnm\PaymentNoteType $paymentNote
     * @return \Mnm\FinancialAccountType
     */
    public function setPaymentNote(\Mnm\PaymentNoteType $paymentNote = null)
    {
        $this->PaymentNote = $paymentNote;
        return $this;
    }
    /**
     * Get FinancialInstitutionBranch value
     * @return \Mnm\BranchType|null
     */
    public function getFinancialInstitutionBranch()
    {
        return $this->FinancialInstitutionBranch;
    }
    /**
     * Set FinancialInstitutionBranch value
     * @param \Mnm\BranchType $financialInstitutionBranch
     * @return \Mnm\FinancialAccountType
     */
    public function setFinancialInstitutionBranch(\Mnm\BranchType $financialInstitutionBranch = null)
    {
        $this->FinancialInstitutionBranch = $financialInstitutionBranch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\FinancialAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
