<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceInformation StructType
 * @subpackage Structs
 */
class EArchiveInvoiceInformation extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryType;
    /**
     * The NewGenerationPamentRecorderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\NewGenerationPaymentRecorderInformation
     */
    public $NewGenerationPamentRecorderInfo;
    /**
     * The InternetSalesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\InternetSalesInformation
     */
    public $InternetSalesInfo;
    /**
     * The WithHoldings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\EArchiveWithHoldingInformation[]
     */
    public $WithHoldings;
    /**
     * Constructor method for EArchiveInvoiceInformation
     * @uses EArchiveInvoiceInformation::setDeliveryType()
     * @uses EArchiveInvoiceInformation::setNewGenerationPamentRecorderInfo()
     * @uses EArchiveInvoiceInformation::setInternetSalesInfo()
     * @uses EArchiveInvoiceInformation::setWithHoldings()
     * @param string $deliveryType
     * @param \Mnm\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @param \Mnm\InternetSalesInformation $internetSalesInfo
     * @param \Mnm\EArchiveWithHoldingInformation[] $withHoldings
     */
    public function __construct($deliveryType = null, \Mnm\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null, \Mnm\InternetSalesInformation $internetSalesInfo = null, array $withHoldings = array())
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setNewGenerationPamentRecorderInfo($newGenerationPamentRecorderInfo)
            ->setInternetSalesInfo($internetSalesInfo)
            ->setWithHoldings($withHoldings);
    }
    /**
     * Get DeliveryType value
     * @return string
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public function setDeliveryType($deliveryType = null)
    {
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get NewGenerationPamentRecorderInfo value
     * @return \Mnm\NewGenerationPaymentRecorderInformation|null
     */
    public function getNewGenerationPamentRecorderInfo()
    {
        return $this->NewGenerationPamentRecorderInfo;
    }
    /**
     * Set NewGenerationPamentRecorderInfo value
     * @param \Mnm\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public function setNewGenerationPamentRecorderInfo(\Mnm\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null)
    {
        $this->NewGenerationPamentRecorderInfo = $newGenerationPamentRecorderInfo;
        return $this;
    }
    /**
     * Get InternetSalesInfo value
     * @return \Mnm\InternetSalesInformation|null
     */
    public function getInternetSalesInfo()
    {
        return $this->InternetSalesInfo;
    }
    /**
     * Set InternetSalesInfo value
     * @param \Mnm\InternetSalesInformation $internetSalesInfo
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public function setInternetSalesInfo(\Mnm\InternetSalesInformation $internetSalesInfo = null)
    {
        $this->InternetSalesInfo = $internetSalesInfo;
        return $this;
    }
    /**
     * Get WithHoldings value
     * @return \Mnm\EArchiveWithHoldingInformation[]|null
     */
    public function getWithHoldings()
    {
        return $this->WithHoldings;
    }
    /**
     * Set WithHoldings value
     * @param \Mnm\EArchiveWithHoldingInformation[] $withHoldings
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public function setWithHoldings(array $withHoldings = array())
    {
        $this->WithHoldings = $withHoldings;
        return $this;
    }
    /**
     * Add item to WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Mnm\EArchiveWithHoldingInformation $item
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public function addToWithHoldings(\Mnm\EArchiveWithHoldingInformation $item)
    {
        $this->WithHoldings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\EArchiveInvoiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
