<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionType StructType
 * @subpackage Structs
 */
class DimensionType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q158:AttributeID
     * @var \Mnm\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q159:Measure
     * @var \Mnm\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q160:Description
     * @var \Mnm\DescriptionType[]
     */
    public $Description;
    /**
     * The MinimumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q161:MinimumMeasure
     * @var \Mnm\MinimumMeasureType
     */
    public $MinimumMeasure;
    /**
     * The MaximumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q162:MaximumMeasure
     * @var \Mnm\MaximumMeasureType
     */
    public $MaximumMeasure;
    /**
     * Constructor method for DimensionType
     * @uses DimensionType::setAttributeID()
     * @uses DimensionType::setMeasure()
     * @uses DimensionType::setDescription()
     * @uses DimensionType::setMinimumMeasure()
     * @uses DimensionType::setMaximumMeasure()
     * @param \Mnm\AttributeIDType $attributeID
     * @param \Mnm\MeasureType $measure
     * @param \Mnm\DescriptionType[] $description
     * @param \Mnm\MinimumMeasureType $minimumMeasure
     * @param \Mnm\MaximumMeasureType $maximumMeasure
     */
    public function __construct(\Mnm\AttributeIDType $attributeID = null, \Mnm\MeasureType $measure = null, array $description = array(), \Mnm\MinimumMeasureType $minimumMeasure = null, \Mnm\MaximumMeasureType $maximumMeasure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description)
            ->setMinimumMeasure($minimumMeasure)
            ->setMaximumMeasure($maximumMeasure);
    }
    /**
     * Get AttributeID value
     * @return \Mnm\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Mnm\AttributeIDType $attributeID
     * @return \Mnm\DimensionType
     */
    public function setAttributeID(\Mnm\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Mnm\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Mnm\MeasureType $measure
     * @return \Mnm\DimensionType
     */
    public function setMeasure(\Mnm\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Mnm\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\DescriptionType[] $description
     * @return \Mnm\DimensionType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Mnm\DescriptionType $item
     * @return \Mnm\DimensionType
     */
    public function addToDescription(\Mnm\DescriptionType $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get MinimumMeasure value
     * @return \Mnm\MinimumMeasureType|null
     */
    public function getMinimumMeasure()
    {
        return $this->MinimumMeasure;
    }
    /**
     * Set MinimumMeasure value
     * @param \Mnm\MinimumMeasureType $minimumMeasure
     * @return \Mnm\DimensionType
     */
    public function setMinimumMeasure(\Mnm\MinimumMeasureType $minimumMeasure = null)
    {
        $this->MinimumMeasure = $minimumMeasure;
        return $this;
    }
    /**
     * Get MaximumMeasure value
     * @return \Mnm\MaximumMeasureType|null
     */
    public function getMaximumMeasure()
    {
        return $this->MaximumMeasure;
    }
    /**
     * Set MaximumMeasure value
     * @param \Mnm\MaximumMeasureType $maximumMeasure
     * @return \Mnm\DimensionType
     */
    public function setMaximumMeasure(\Mnm\MaximumMeasureType $maximumMeasure = null)
    {
        $this->MaximumMeasure = $maximumMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\DimensionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
