<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q82:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q83:Quantity
     * @var \Mnm\QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q84:ActualDeliveryDate
     * @var \Mnm\ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q85:ActualDeliveryTime
     * @var \Mnm\ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q86:LatestDeliveryDate
     * @var \Mnm\LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q87:LatestDeliveryTime
     * @var \Mnm\LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q88:TrackingID
     * @var \Mnm\TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ShipmentType
     */
    public $Shipment;
    /**
     * Constructor method for DeliveryType
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     * @param \Mnm\IDType $iD
     * @param \Mnm\QuantityType $quantity
     * @param \Mnm\ActualDeliveryDateType $actualDeliveryDate
     * @param \Mnm\ActualDeliveryTimeType $actualDeliveryTime
     * @param \Mnm\LatestDeliveryDateType $latestDeliveryDate
     * @param \Mnm\LatestDeliveryTimeType $latestDeliveryTime
     * @param \Mnm\TrackingIDType $trackingID
     * @param \Mnm\AddressType $deliveryAddress
     * @param \Mnm\LocationType $alternativeDeliveryLocation
     * @param \Mnm\PeriodType $estimatedDeliveryPeriod
     * @param \Mnm\PartyType $carrierParty
     * @param \Mnm\PartyType $deliveryParty
     * @param \Mnm\DespatchType $despatch
     * @param \Mnm\DeliveryTermsType[] $deliveryTerms
     * @param \Mnm\ShipmentType $shipment
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\QuantityType $quantity = null, \Mnm\ActualDeliveryDateType $actualDeliveryDate = null, \Mnm\ActualDeliveryTimeType $actualDeliveryTime = null, \Mnm\LatestDeliveryDateType $latestDeliveryDate = null, \Mnm\LatestDeliveryTimeType $latestDeliveryTime = null, \Mnm\TrackingIDType $trackingID = null, \Mnm\AddressType $deliveryAddress = null, \Mnm\LocationType $alternativeDeliveryLocation = null, \Mnm\PeriodType $estimatedDeliveryPeriod = null, \Mnm\PartyType $carrierParty = null, \Mnm\PartyType $deliveryParty = null, \Mnm\DespatchType $despatch = null, array $deliveryTerms = array(), \Mnm\ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\DeliveryType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\QuantityType $quantity
     * @return \Mnm\DeliveryType
     */
    public function setQuantity(\Mnm\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualDeliveryDate value
     * @return \Mnm\ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }
    /**
     * Set ActualDeliveryDate value
     * @param \Mnm\ActualDeliveryDateType $actualDeliveryDate
     * @return \Mnm\DeliveryType
     */
    public function setActualDeliveryDate(\Mnm\ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get ActualDeliveryTime value
     * @return \Mnm\ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }
    /**
     * Set ActualDeliveryTime value
     * @param \Mnm\ActualDeliveryTimeType $actualDeliveryTime
     * @return \Mnm\DeliveryType
     */
    public function setActualDeliveryTime(\Mnm\ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }
    /**
     * Get LatestDeliveryDate value
     * @return \Mnm\LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }
    /**
     * Set LatestDeliveryDate value
     * @param \Mnm\LatestDeliveryDateType $latestDeliveryDate
     * @return \Mnm\DeliveryType
     */
    public function setLatestDeliveryDate(\Mnm\LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get LatestDeliveryTime value
     * @return \Mnm\LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }
    /**
     * Set LatestDeliveryTime value
     * @param \Mnm\LatestDeliveryTimeType $latestDeliveryTime
     * @return \Mnm\DeliveryType
     */
    public function setLatestDeliveryTime(\Mnm\LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \Mnm\TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \Mnm\TrackingIDType $trackingID
     * @return \Mnm\DeliveryType
     */
    public function setTrackingID(\Mnm\TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \Mnm\AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \Mnm\AddressType $deliveryAddress
     * @return \Mnm\DeliveryType
     */
    public function setDeliveryAddress(\Mnm\AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * @return \Mnm\LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * @param \Mnm\LocationType $alternativeDeliveryLocation
     * @return \Mnm\DeliveryType
     */
    public function setAlternativeDeliveryLocation(\Mnm\LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * @param \Mnm\PeriodType $estimatedDeliveryPeriod
     * @return \Mnm\DeliveryType
     */
    public function setEstimatedDeliveryPeriod(\Mnm\PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }
    /**
     * Get CarrierParty value
     * @return \Mnm\PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }
    /**
     * Set CarrierParty value
     * @param \Mnm\PartyType $carrierParty
     * @return \Mnm\DeliveryType
     */
    public function setCarrierParty(\Mnm\PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }
    /**
     * Get DeliveryParty value
     * @return \Mnm\PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }
    /**
     * Set DeliveryParty value
     * @param \Mnm\PartyType $deliveryParty
     * @return \Mnm\DeliveryType
     */
    public function setDeliveryParty(\Mnm\PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }
    /**
     * Get Despatch value
     * @return \Mnm\DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }
    /**
     * Set Despatch value
     * @param \Mnm\DespatchType $despatch
     * @return \Mnm\DeliveryType
     */
    public function setDespatch(\Mnm\DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \Mnm\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @param \Mnm\DeliveryTermsType[] $deliveryTerms
     * @return \Mnm\DeliveryType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Mnm\DeliveryTermsType $item
     * @return \Mnm\DeliveryType
     */
    public function addToDeliveryTerms(\Mnm\DeliveryTermsType $item)
    {
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Mnm\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Mnm\ShipmentType $shipment
     * @return \Mnm\DeliveryType
     */
    public function setShipment(\Mnm\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\DeliveryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
